package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.ArrayList;
import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.OutputDocument;


public class TableTagValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
	    boolean modified = false;
	    if (isListOfList(responseValue)) {
	    	List<List<?>> rowDataList = castToListOfList(responseValue);
	    	Element tbody = elements.get(0).getFirstElement("tbody");
	    	if (tbody != null && tbody.getEndTag() != null) {
	    		Element tr = tbody.getFirstElement("tr");
	    		List<String> rowParts = new ArrayList<String>();
	    		int rowPartsSize = 0;
	    		if (tr != null && tr.getEndTag() != null) {
	    			List<Element> trChildren = tr.getChildElements();
	    			rowParts.add(tr.getStartTag().toString());
	    			for (int i = 0; i < trChildren.size(); i++) {
	    				Element trChild = trChildren.get(i);
	    				if (!ModifierUtil.matchesAny(trChild.getName(), "td", "th")) {
	    					continue;
	    				}
	    				rowParts.set(rowParts.size() - 1, rowParts.get(rowParts.size() - 1)
	    				        + trChild.getStartTag().toString());
	    				rowParts.add(trChild.getEndTag().toString());
	    			}
	    			rowPartsSize = rowParts.size();
	    			rowParts.set(rowPartsSize - 1, rowParts.get(rowPartsSize - 1)
	    			        + tr.getEndTag().toString());

	    			StringBuilder tbodyBuilder = new StringBuilder(tbody.getStartTag().toString());
	    			for (List<?> rowData : rowDataList) {
	    				for (int i = 0; i < rowParts.size() - 1; i++) {
	    					tbodyBuilder.append(rowParts.get(i));
	    					if (rowData.size() > i && rowData.get(i) != null) {
	    						tbodyBuilder.append(rowData.get(i).toString());
	    					}
	    				}
	    				tbodyBuilder.append(rowParts.get(rowPartsSize - 1));
	    			}
	    			tbodyBuilder.append(tbody.getEndTag().toString());

	    			outputDocument.replace(tbody, tbodyBuilder.toString());
	    			modified = true;
	    		}

	    	}

	    }
	    return modified;
    }

	private boolean isListOfList(Object target) {
		if (target instanceof List) {
			for (Object element : (List<?>)target) {
				if (!(element instanceof List)) {
					return false;
				}
			}
			return true;
		} else {
			return false;
		}
	}

	@SuppressWarnings("unchecked")
	private List<List<?>> castToListOfList(Object responseValue) {
		return (List<List<?>>)responseValue;
	}

	public boolean responsible(String elementName) {
	    return "table".equals(elementName);
    }

}
