package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.StartTag;

public class TagTextValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elements, Object responseValue) {
		Element element = elements.get(0);
		EndTag end = element.getEndTag();
		StartTag start = element.getStartTag();
		StringBuilder sb = new StringBuilder();
		if (start.isSyntacticalEmptyElementTag()) {
			sb.append(start.toString().replace("/>", ">"));
			sb.append(responseValue.toString());
			sb.append("</");
			sb.append(element.getName());
			sb.append(">");
			outputDocument.replace(element, sb.toString());
		} else if (end != null) {
			sb.append(start.toString());
			sb.append(responseValue.toString());
			sb.append(end.toString());
			outputDocument.replace(element, sb.toString());
		}
		return true;
	}

	public boolean responsible(String elementName) {
		return ModifierUtil.matchesAny(elementName, "div", "span", "p", "h1", "h2", "h3", "h4", "h5", "h6", "li",
		        "textarea", "title");
	}

}
