package com.small_it_office.flatserve.purehtml.internal.document;

import java.util.List;

import net.htmlparser.jericho.Element;
import net.htmlparser.jericho.EndTag;
import net.htmlparser.jericho.OutputDocument;
import net.htmlparser.jericho.StartTag;


public class TextAreaTagValueModifier implements HtmlTagValueModifier {

	public boolean modifyDocument(OutputDocument outputDocument, List<Element> elementsByName, Object responseValue) {
	    Element elementByName = elementsByName.get(0);
	    EndTag end = elementByName.getEndTag();
	    StartTag start = elementByName.getStartTag();
	    StringBuilder sb = new StringBuilder();
	    if (start.isSyntacticalEmptyElementTag()) {
	    	sb.append(start.toString().replace("/>", ">"));
	    	sb.append(responseValue.toString());
	    	sb.append("</");
	    	sb.append(elementByName.getName());
	    	sb.append(">");
	    	outputDocument.replace(elementByName, sb.toString());
	    	return true;
	    } else if (end != null) {
	    	sb.append(start.toString());
	    	sb.append(responseValue.toString());
	    	sb.append(end.toString());
	    	outputDocument.replace(elementByName, sb.toString());
	    	return true;
	    }
	    return false;
    }

	public boolean responsible(String elementName) {
	    return "textarea".equals(elementName);
    }

}
