/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.extension;

import java.util.HashMap;
import java.util.Map;
import jp.botiboti.flextyle.core.RecordSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pager {
    private static final int DEFAULT_RECORD_COUNT = 10;
    private static final String CURRENT_PAGE_KEY = "Pagenator.currentPage";
    private int recordCount = -1;
    private Direction direction = null;
    private int currentPage = -1;
    private int maxRow = -1;
    public static final Direction NEXT = new Direction();
    public static final Direction PREV = new Direction();
    public static final Direction REFRESH = new Direction();
    Map<String, String> pagingJoken = new HashMap<String, String>();

    public Pager() {
        this(10);
    }

    public Pager(int pageSize) {
        this.recordCount = pageSize;
    }

    public Pager(int currentPage, Direction direc) {
        this(currentPage, direc, 10);
    }

    public Pager(int currentPage, Direction direc, int pageSize) {
        this.direction = direc;
        this.currentPage = currentPage;
        this.recordCount = pageSize;
    }

    public Pager(RecordSet input, Direction direc) {
        this(input, direc, 10);
    }

    public Pager(RecordSet input, Direction direc, int pageSize) {
        this(Integer.parseInt(input.getString(CURRENT_PAGE_KEY)), direc, pageSize);
    }

    public int getShownPageNum() {
        return this.direction == NEXT ? this.currentPage + 1 : (this.direction == PREV ? this.currentPage - 1 : (this.direction == REFRESH ? this.currentPage : 1));
    }

    public int getMaxPageNum() {
        return this.maxRow / this.recordCount + (this.maxRow % this.recordCount == 0 ? 0 : 1);
    }

    public int getMaxRowNum() {
        return this.maxRow;
    }

    public int getShownStartRow() {
        return (this.getShownPageNum() - 1) * this.recordCount + 1;
    }

    public int getShownEndRow() {
        int pageEndRow = this.getShownPageNum() * this.recordCount;
        return this.getMaxRowNum() < pageEndRow ? this.getMaxRowNum() : pageEndRow;
    }

    public boolean getHasNext() {
        return this.getShownPageNum() < this.getMaxPageNum();
    }

    public boolean getHasPrev() {
        return this.getShownPageNum() > 1;
    }

    public String getCurrentPageKey() {
        return CURRENT_PAGE_KEY;
    }

    public RecordSet paging(RecordSet result) {
        this.maxRow = result.isEmpty() ? 0 : result.getCount();
        return result.subSet(this.getShownStartRow(), this.recordCount);
    }

    public Map<String, String> getJoken() {
        return this.pagingJoken;
    }

    public String setJoken(String key, String value) {
        return this.pagingJoken.put(key, value);
    }

    private static class Direction {
        private Direction() {
        }
    }
}

