/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.jsf;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.botiboti.flextyle.jsf.Context;
import jp.botiboti.flextyle.util.Log;

public class AjaxDispatchServletStudy
extends HttpServlet
implements Servlet {
    private static final long serialVersionUID = -5398320268550932900L;
    private static final Logger log = new Log.LoggerFriend(){}.fxt();
    private String errorPrefix = "ERROR";
    private String packageNameOfBeanClass = "jp.botiboti.undone.flextyle.beans";

    public void init(ServletConfig arg0) throws ServletException {
        String str1 = arg0.getInitParameter("ERROR_PREFIX");
        String str2 = arg0.getInitParameter("PACKAGE_NAME_OF_BEAN_CLASS");
        if (str1 != null && !str1.equals("")) {
            this.errorPrefix = str1;
        }
        if (str2 != null && !str2.equals("")) {
            this.packageNameOfBeanClass = str2;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPostOrGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPostOrGet(request, response);
    }

    private void doPostOrGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String key;
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        HashMap<String, Object> sessionMap = new HashMap<String, Object>();
        Enumeration enumer = request.getSession().getAttributeNames();
        while (enumer.hasMoreElements()) {
            String key2 = (String)enumer.nextElement();
            sessionMap.put(key2, request.getSession().getAttribute(key2));
        }
        Context ctx = new Context(request.getParameterMap(), requestMap, sessionMap);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        String pathInfo = request.getPathInfo();
        String[] args = pathInfo.split("\\.");
        Object retValue = null;
        if (!pathInfo.contains(".") || args.length != 2 || !args[0].startsWith("/")) {
            retValue = String.valueOf(this.errorPrefix) + ": \uff35\uff32\uff2c\u306e\u6307\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002[" + pathInfo + "]";
        } else {
            try {
                String pkgName = request.getParameter("packageNameOfBeanClass");
                if (pkgName == null || pkgName.equals("")) {
                    pkgName = this.packageNameOfBeanClass;
                }
                args[0] = args[0].substring(1);
                Class<?> beanClass = Class.forName(String.valueOf(this.packageNameOfBeanClass) + "." + args[0]);
                Object beanObj = beanClass.newInstance();
                retValue = beanClass.getMethod(args[1], new Class[0]).invoke(beanObj, new Object[0]);
            }
            catch (Exception e) {
                retValue = String.valueOf(this.errorPrefix) + ": " + e.toString();
                log.log(Level.WARNING, String.valueOf(this.errorPrefix) + ": " + e.toString(), e);
            }
        }
        ctx.finalizeContext();
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=UTF-8");
        response.getWriter().write(retValue.toString());
        enumer = request.getSession().getAttributeNames();
        while (enumer.hasMoreElements()) {
            request.getSession().removeAttribute((String)enumer.nextElement());
        }
        Iterator sesItr = sessionMap.keySet().iterator();
        while (sesItr.hasNext() && (key = (String)sesItr.next()) != null) {
            request.getSession().setAttribute(key, sessionMap.get(key));
        }
    }
}

