/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.jsf;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.botiboti.flextyle.util.Log;

public class AjaxDispatcher {
    private static final Logger log = new Log.LoggerFriend(){}.fxt();
    private static final String ErrorPrefix = "ERROR";

    private String getPackageNameOfBeanClass(HttpServletRequest request) {
        String pkgName = request.getParameter("packageNameOfBeanClass");
        if (pkgName != null && !pkgName.equals("")) {
            return pkgName;
        }
        log.fine("WARNING: AjaxDispatcher;\n\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u304c\u6307\u5b9a\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u306e\u3067\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30d1\u30c3\u30b1\u30fc\u30b8\u540d\u3092\u9069\u7528\u3057\u307e\u3059.");
        return "jp.botiboti.undone.flextyle.beans";
    }

    private String getBeanAndMethodName(HttpServletRequest request) {
        String name = request.getParameter("beanAndMethodName");
        if (name == null || name.indexOf(".") == -1) {
            return null;
        }
        return name;
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Object retValue = null;
        String beanAndMethodName = this.getBeanAndMethodName(request);
        if (beanAndMethodName == null) {
            retValue = "ERROR: \uff35\uff32\uff2c\u306e\u6307\u5b9a\u304c\u9593\u9055\u3063\u3066\u3044\u307e\u3059\u3002[" + request.getRequestURI() + request.getQueryString() + "]";
        } else {
            try {
                String[] args = beanAndMethodName.split("\\.", 2);
                Class<?> beanClass = Class.forName(String.valueOf(this.getPackageNameOfBeanClass(request)) + "." + args[0]);
                Object beanObj = beanClass.newInstance();
                retValue = beanClass.getMethod(args[1], new Class[0]).invoke(beanObj, new Object[0]);
            }
            catch (Exception e) {
                retValue = "ERROR: " + e.toString();
                log.log(Level.WARNING, "ERROR: " + e.toString(), e);
            }
        }
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=UTF-8");
        response.getWriter().write(retValue.toString());
    }
}

