/*
 * Decompiled with CFR 0.152.
 */
package jp.botiboti.flextyle.web;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.botiboti.flextyle.core.ConnectionFactory;
import jp.botiboti.flextyle.core.RecordSet;
import jp.botiboti.flextyle.util.Log;
import jp.botiboti.flextyle.util.ReflectionUtil;
import jp.botiboti.flextyle.util.Util;
import jp.botiboti.flextyle.web.DispatchParser;
import jp.botiboti.flextyle.web.Dispatcher;
import jp.botiboti.flextyle.web.DispatcherWithGroovy;
import jp.botiboti.flextyle.web.ForwardRequestWrapper;
import jp.botiboti.flextyle.web.PageNavigator;
import jp.botiboti.flextyle.web.RecordSetForJSP;
import jp.botiboti.flextyle.web.WebBean;
import jp.botiboti.flextyle.web.WebErrorUtil;
import jp.botiboti.flextyle.web.WebWriter;

public class DispatchFilter
implements Filter {
    private static final Logger log = new Log.LoggerFriend(){}.fxt();
    public static final String INI_KEY_DATASOURCE_JNDI = "datasource-jndi";
    public static final String INI_KEY_URL_PATTERN = "url-pattern";
    public static final String INI_KEY_CLASS_NAME = "class-name";
    public static final String INI_KEY_METHOD_NAME = "method-name";
    public static final String INI_KEY_PARAMETER = "parameter";
    public static final String INI_KEY_NAVIGATOR_ALIASES = "navigator-aliases";
    public static final String INI_KEY_RUNMODE = "run-mode";
    public static final String iNI_KEY_GROOVY_PATH = "groovy-filepath";
    private static final String SES_KEY_FOR_REDIRECT = String.valueOf(DispatchFilter.class.getName()) + "_DataForRedirect";
    private static final String MESSAGES_KEY = "Messages";
    private Dispatcher dispatcher = null;
    private DispatchParser parser = null;
    private PageNavigator navigator = null;
    private DeployTimestamp deployTimestamp = null;

    public void init(FilterConfig arg0) throws ServletException {
        final String jndi = arg0.getInitParameter(INI_KEY_DATASOURCE_JNDI);
        if (Util.isNotNullOrBlank(jndi)) {
            (new ConnectionFactory(){

                private void init() {
                    ConnectionFactory.initialize(jndi.startsWith("java:comp/env/") ? jndi : "java:comp/env/" + jndi);
                }
            }).init();
        }
        this.parser = new DispatchParser();
        this.parser.setUrlPattern(arg0.getInitParameter(INI_KEY_URL_PATTERN));
        this.parser.setClassNameExpression(arg0.getInitParameter(INI_KEY_CLASS_NAME));
        this.parser.setMethodNameExpression(arg0.getInitParameter(INI_KEY_METHOD_NAME));
        String exp = arg0.getInitParameter("parameter1");
        ArrayList<String> li = null;
        int i = 1;
        while (Util.isNotNullOrBlank(exp)) {
            (li == null ? new ArrayList<String>() : li).add(exp);
            exp = arg0.getInitParameter(INI_KEY_PARAMETER + ++i);
        }
        this.parser.setParameterExpressions(li);
        exp = arg0.getInitParameter(INI_KEY_RUNMODE);
        if (exp != null && exp.equals("product")) {
            final String timestamp = "?" + System.currentTimeMillis();
            this.deployTimestamp = new DeployTimestamp(){

                public String get() {
                    return timestamp;
                }
            };
        } else {
            this.deployTimestamp = new DeployTimestamp(){

                public String get() {
                    return "?" + System.currentTimeMillis();
                }
            };
        }
        String fnm = arg0.getInitParameter(INI_KEY_NAVIGATOR_ALIASES);
        String fileName = Util.isNotNullOrBlank(fnm) ? fnm : "/WEB-INF/navigator-aliases.xml";
        this.navigator = new PageNavigator(arg0.getServletContext().getRealPath(fileName));
        String groovyPath = arg0.getInitParameter(iNI_KEY_GROOVY_PATH);
        this.dispatcher = Util.isNotNullOrBlank(groovyPath) ? new DispatcherWithGroovy(groovyPath) : new Dispatcher();
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain chain) {
        try {
            this.doFileterImpl((HttpServletRequest)arg0, (HttpServletResponse)arg1, chain);
        }
        catch (RuntimeException ex) {
            WebErrorUtil.writeErrorPage((HttpServletResponse)arg1, ex.getMessage(), ex);
        }
        catch (Exception ex) {
            WebErrorUtil.writeErrorPage((HttpServletResponse)arg1, ex.getMessage(), ex);
        }
    }

    private void doFileterImpl(HttpServletRequest req, HttpServletResponse res, FilterChain chain) throws IOException, ServletException {
        String url;
        Matcher matcher;
        Map tmp;
        String pInfo = req.getPathInfo();
        if (pInfo != null && (pInfo.startsWith("/WEB-INF") || pInfo.startsWith("/META-INF"))) {
            res.setStatus(404);
            return;
        }
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        req.setAttribute("timestamp", (Object)this.deployTimestamp.get());
        if (req.getSession() != null && (tmp = (Map)req.getSession().getAttribute(SES_KEY_FOR_REDIRECT)) != null) {
            Iterator iterator = tmp.keySet().iterator();
            while (iterator.hasNext()) {
                String s;
                Object obj = tmp.get(s = (String)iterator.next());
                req.setAttribute(s, obj instanceof RecordSetForJSP ? ((RecordSetForJSP)obj).getRecordSet() : obj);
            }
            req.getSession().removeAttribute(SES_KEY_FOR_REDIRECT);
        }
        if (!(matcher = this.parser.parse(url = req.getPathInfo() == null ? req.getServletPath() : String.valueOf(req.getPathInfo()) + req.getServletPath())).matches()) {
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String className = this.parser.getClassName(matcher);
        String methodName = this.parser.getMethodName(matcher);
        List<String> parameter = this.parser.getParameters(matcher, url);
        WebBean bean = this.dispatcher.createWebBean(className);
        Object obj = this.dispatcher.dispatch(req, res, bean, methodName, parameter);
        if (obj == null || !(obj instanceof String)) {
            WebErrorUtil.writeErrorPage(res, "return value of accessed method [" + className + ". " + methodName + "] is invalid." + obj, null);
            return;
        }
        final String result = (String)obj;
        Map<String, Object> tmp2 = bean.getStoredForRedirect();
        if (tmp2 != null) {
            for (String s : tmp2.keySet()) {
                if (!(tmp2.get(s) instanceof RecordSet)) continue;
                tmp2.put(s, new RecordSetForJSP((RecordSet)tmp2.get(s)));
            }
            req.getSession().setAttribute(SES_KEY_FOR_REDIRECT, tmp2);
        }
        if (bean.hasMessages()) {
            req.setAttribute(MESSAGES_KEY, bean.getMessages());
        }
        if (result.startsWith("{")) {
            this.writeText(res, result);
            return;
        }
        if (result.startsWith("Echo: ")) {
            this.writeText(res, result.substring("Echo: ".length()));
            return;
        }
        if (result.startsWith("Location: ")) {
            res.sendRedirect(result.substring("Location: ".length()));
            return;
        }
        if (result.startsWith("WriterClass: ")) {
            tmp2 = bean.getStoredValues();
            if (tmp2 != null) {
                String prefix = String.valueOf(className.substring(className.lastIndexOf(46) + 1)) + ".";
                for (String s : tmp2.keySet()) {
                    req.setAttribute(String.valueOf(prefix) + s, tmp2.get(s));
                }
            }
            ((WebWriter)new ReflectionUtil<WebWriter>(){

                @Override
                public WebWriter impl() throws Exception {
                    return (WebWriter)Class.forName(result.substring("WriterClass: ".length())).newInstance();
                }
            }.createInstance()).write(req, res);
            return;
        }
        tmp2 = bean.getStoredValues();
        if (tmp2 != null) {
            for (String s : tmp2.keySet()) {
                if (!(tmp2.get(s) instanceof RecordSet)) continue;
                tmp2.put(s, new RecordSetForJSP((RecordSet)tmp2.get(s)));
            }
            req.setAttribute(className.substring(className.lastIndexOf(46) + 1), tmp2);
        }
        String symbol = result;
        this.navigator.isValid();
        req.getRequestDispatcher(symbol).forward((ServletRequest)new ForwardRequestWrapper(req), (ServletResponse)res);
    }

    public void destroy() {
    }

    private void writeText(HttpServletResponse response, String textdata) {
        PrintWriter writer;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/plain; charset=UTF-8");
        try {
            response.setHeader("progma", "no-cache");
            response.setHeader("Cache-Control", "no-cache");
            response.setDateHeader("Expires", -1L);
            writer = response.getWriter();
        }
        catch (IOException ioEx) {
            log.log(Level.SEVERE, "\u30ec\u30b9\u30dd\u30f3\u30b9\u30c7\u30fc\u30bf\u4f5c\u6210\u4e2d\u306b\u3001IO\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002", ioEx);
            return;
        }
        writer.write(textdata);
        writer.close();
    }

    private static interface DeployTimestamp {
        public String get();
    }
}

