/**
 * Flogman (Foto bLOG, Mail is All you Need)
 * Copyright (C) 2003 Junya Ishihara (http://flogman.sourceforge.net)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

package net.sourceforge.flogman;
import java.io.*;
import java.util.*;

public class FromParser{
  private String from;
  private String separator;
  private String name;
  private String mailaddress;


  public static void main(String[] argv) throws Exception {
    if (argv.length == 0) {
      System.err.println("Usage: FromParser from separator");
      System.exit(1);
    }
    FromParser fp = new FromParser(argv[0], argv[1]);
    System.out.println("Name:" + fp.getName());
    System.out.println("MailAddress:" + fp.getMailaddress());			  }

  public FromParser(String from, String separator) {
    this.from = from;
    this.separator = separator;
  }	


  public String getName() {
    try {
      StringTokenizer st = new StringTokenizer(this.from, this.separator);
      return(st.nextToken());
    } catch (Exception e) {
      Flogman.cat.error("Unable to parse from field. " + e);
      return("");
    }
  }

  public String getMailaddress() throws Exception{
    try {
      StringTokenizer st = new StringTokenizer(this.from, this.separator);
      st.nextToken();
      return(st.nextToken());
    } catch (Exception e) {
      Flogman.cat.error("Unable to parse from field. " + e);
      return("");
    }
  }
}
