package net.robotmedia.acv.logic;

import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.MobileAds;

import android.app.Activity;
import android.view.View;

public class AdMobProxy {

	private static void init() {
	}

	public static View getAd(Activity activity, int size, String unitId, String testDevice) {
		init();

		MobileAds.initialize(activity, AdsManager.publisherId);

		View view;
		// == new AdView(activity, size, publisherId)
		AdView adView = new AdView(activity);
		adView.setAdUnitId(unitId);
		adView.setAdSize(sizeToAdSize(size));
		view = (View) adView;


		// == new AdRequest()
		AdRequest adRequest = new AdRequest.Builder().addTestDevice("013B9AE2190161CD436B8E898125F303").build();
//		AdRequest adRequest = new AdRequest.Builder().build();

		// == adRequest.setTesting(true);
		// == adRequest.addTestDevice(...);
		// Only if we are in debug mode (requires Android SDK >= 18)
		// and the proper test device id has been added as a resource string.
//				if(BuildConfig.DEBUG && testDevice != null) {
//					adRequestSetTestingMethod.invoke(adRequest, true);
//					adRequestAddTestDeviceMethod.invoke(adRequest, testDevice);
//					adRequestAddTestDeviceMethod.invoke(adRequest, adRequestClass.getField("TEST_EMULATOR").get(null));
//				}

		// == adView.loadAd(adRequest);
		adView.loadAd(adRequest);

		return view;
	}

	/**
	 * Apparently there's a serious bug with WebViews + Activity.onDestroy in Android 1.5 and 1.6.
	 * As AdMob uses WebViews, it forces the application to crash.
	 * The work-around is to destroy AdViews in activity.onDestroy.
	 * This method removes the ad with id = viewId in the activity view hierarchy.
	 * 
	 * @param activity
	 * @param viewId
	 */
	public static void destroyAds(Activity activity, int viewId) {
		AdView v = (AdView) activity.findViewById(viewId);
		if(v != null) {
			v.destroy();
		}
	}
	
	private static AdSize sizeToAdSize(int size) {

		switch(size) {
			case AdsManager.SIZE_FULL_BANNER:
				return AdSize.FULL_BANNER;
			default:
				case AdsManager.SIZE_BANNER:
				return AdSize.BANNER;	
		}
	}
}
