/*
 * Decompiled with CFR 0.152.
 */
package com.gc.android.market.api;

import com.gc.android.market.api.MarketSession;
import com.gc.android.market.api.model.Market;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public class Main {
    private static void usage() {
        System.out.println("Usage :\nmarket <email> <password> <androidId> <testId> <assetId> <query> \n\temail, password : account linked to the specified android id\n\tandroiId : a valid android id (retrieved typing *#*#8255#*#* on device or emulator)\n\ttestId : test you want to run (1 to test different asyncronous methods; 2 to test different syncronous call. Please note that if you run test 1 and 2 consecutively, you have to change account to avoid Bad request response;  3 to test download)\n\tassetId : application assetId to use for testing\n\tquery to test setQuery in testId 1");
    }

    public static void main(String[] args) {
        try {
            if (args.length < 5) {
                Main.usage();
                return;
            }
            String login = args[0];
            String password = args[1];
            String androidId = args[2];
            Integer testId = new Integer(args[3]);
            String assetId = args[4];
            String query = args.length == 6 ? args[5] : "Test";
            switch (testId) {
                case 1: {
                    Main.testAsyncronousCalls(login, password, androidId, assetId, query);
                    break;
                }
                case 2: {
                    Main.testSyncronousCalls(login, password, androidId, assetId);
                    break;
                }
                case 3: {
                    Main.testDownload(login, password, androidId, assetId);
                    break;
                }
                default: {
                    Main.usage();
                    return;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void testAsyncronousCalls(String login, String password, String androidId, String assetId, String query) {
        try {
            MarketSession session = new MarketSession(false);
            System.out.println("Login...");
            session.login(login, password, androidId);
            System.out.println("Login done");
            Market.AppsRequest appsRequest = Market.AppsRequest.newBuilder().setQuery(query).setStartIndex(2L).setEntriesCount(10).setWithExtendedInfo(true).build();
            Market.CommentsRequest commentsRequest = Market.CommentsRequest.newBuilder().setAppId(assetId).setStartIndex(0).setEntriesCount(10).build();
            Market.GetImageRequest imgReq = Market.GetImageRequest.newBuilder().setAppId(assetId).setImageUsage(Market.GetImageRequest.AppImageUsage.SCREENSHOT).setImageId("1").build();
            MarketSession.Callback callback = new MarketSession.Callback(){

                public void onResult(Market.ResponseContext context, Object response) {
                    System.out.println("Response : " + response);
                }
            };
            session.append(appsRequest, callback);
            session.flush();
            session.append(imgReq, new MarketSession.Callback<Market.GetImageResponse>(){

                @Override
                public void onResult(Market.ResponseContext context, Market.GetImageResponse response) {
                    try {
                        FileOutputStream fos = new FileOutputStream("icon.png");
                        fos.write(response.getImageData().toByteArray());
                        fos.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            session.flush();
            session.append(commentsRequest, callback);
            session.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void testSyncronousCalls(String login, String password, String androidId, String assetId) {
        try {
            MarketSession session = new MarketSession(false);
            ArrayList<Object> rg = new ArrayList<Object>();
            System.out.println("Login...");
            session.login(login, password, androidId);
            System.out.println("Login done");
            Market.AppsRequest appsRequest = Market.AppsRequest.newBuilder().setAppType(Market.AppType.GAME).setStartIndex(1L).setEntriesCount(10).setWithExtendedInfo(true).setViewType(Market.AppsRequest.ViewType.FREE).build();
            rg.addAll(session.queryApp(appsRequest));
            int j = 0;
            while (j < rg.size()) {
                Market.AppsResponse apps = (Market.AppsResponse)rg.get(j);
                System.out.println("#num apps: " + apps.getAppCount());
                ++j;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void testDownload(String login, String password, String androidId, String assetId) {
        try {
            MarketSession session = new MarketSession(true);
            System.out.println("Login...");
            session.login(login, password, androidId);
            System.out.println("Login done");
            Market.GetAssetResponse.InstallAsset ia = session.queryGetAssetRequest(assetId).getInstallAsset(0);
            String cookieName = ia.getDownloadAuthCookieName();
            String cookieValue = ia.getDownloadAuthCookieValue();
            URL url = new URL(ia.getBlobUrl());
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setRequestProperty("User-Agent", "Android-Market/2 (sapphire PLAT-RC33); gzip");
            conn.setRequestProperty("Cookie", String.valueOf(cookieName) + "=" + cookieValue);
            InputStream inputstream = conn.getInputStream();
            String fileToSave = String.valueOf(assetId) + ".apk";
            System.out.println("Downloading " + fileToSave);
            BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(fileToSave));
            byte[] buf = new byte[1024];
            int k = 0;
            long l = 0L;
            while ((k = inputstream.read(buf)) != -1) {
                stream.write(buf, 0, k);
                l += (long)k;
            }
            inputstream.close();
            stream.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

