/*
 * Decompiled with CFR 0.152.
 */
package com.gc.android.market.api;

import com.gc.android.market.api.Base64;
import com.gc.android.market.api.LoginException;
import com.gc.android.market.api.Tools;
import com.gc.android.market.api.model.Market;
import com.google.protobuf.GeneratedMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class MarketSession {
    public String SERVICE = "android";
    private static final String URL_LOGIN = "https://www.google.com/accounts/ClientLogin";
    public static final String ACCOUNT_TYPE_GOOGLE = "GOOGLE";
    public static final String ACCOUNT_TYPE_HOSTED = "HOSTED";
    public static final String ACCOUNT_TYPE_HOSTED_OR_GOOGLE = "HOSTED_OR_GOOGLE";
    public static final int PROTOCOL_VERSION = 2;
    Market.Request.Builder request = Market.Request.newBuilder();
    Market.RequestContext.Builder context = Market.RequestContext.newBuilder();
    List<Callback<?>> callbacks = new Vector();
    String authSubToken = null;

    public Market.RequestContext.Builder getContext() {
        return this.context;
    }

    public String getAuthSubToken() {
        return this.authSubToken;
    }

    public MarketSession(Boolean isSecure) {
        this.SERVICE = isSecure != false ? "androidsecure" : "android";
        this.context.setIsSecure(false);
        this.context.setVersion(2009011);
        this.setLocale(Locale.getDefault());
        this.context.setDeviceAndSdkVersion("passion:9");
        this.setOperatorTMobile();
    }

    public void setLocale(Locale locale) {
        this.context.setUserLanguage(locale.getLanguage().toLowerCase());
        this.context.setUserCountry(locale.getCountry().toLowerCase());
    }

    public void setOperator(String alpha, String numeric) {
        this.setOperator(alpha, alpha, numeric, numeric);
    }

    public void setOperatorTMobile() {
        this.setOperator("T-Mobile", "310260");
    }

    public void setOperatorSFR() {
        this.setOperator("F SFR", "20810");
    }

    public void setOperatorO2() {
        this.setOperator("o2 - de", "26207");
    }

    public void setOperatorSimyo() {
        this.setOperator("E-Plus", "simyo", "26203", "26203");
    }

    public void setOperatorSunrise() {
        this.setOperator("sunrise", "22802");
    }

    public void setOperator(String alpha, String simAlpha, String numeric, String simNumeric) {
        this.context.setOperatorAlpha(alpha);
        this.context.setSimOperatorAlpha(simAlpha);
        this.context.setOperatorNumeric(numeric);
        this.context.setSimOperatorNumeric(simNumeric);
    }

    public void setAuthSubToken(String authSubToken) {
        this.context.setAuthSubToken(authSubToken);
        this.authSubToken = authSubToken;
    }

    public void setIsSecure(Boolean isSecure) {
        this.context.setIsSecure(isSecure);
    }

    public void setAndroidId(String androidId) {
        this.context.setAndroidId(androidId);
    }

    public void login(String email, String password, String androidId) {
        this.login(email, password, androidId, ACCOUNT_TYPE_HOSTED_OR_GOOGLE);
    }

    /*
     * Unable to fully structure code
     */
    public void login(String email, String password, String androidId, String accountType) {
        this.setAndroidId(androidId);
        params = new LinkedHashMap<String, String>();
        params.put("Email", email);
        params.put("Passwd", password);
        params.put("service", this.SERVICE);
        params.put("accountType", accountType);
        try {
            data = Tools.postUrl("https://www.google.com/accounts/ClientLogin", params);
            st = new StringTokenizer(data, "\n\r=");
            authKey = null;
            while (st.hasMoreTokens()) {
                if (!st.nextToken().equalsIgnoreCase("Auth")) continue;
                authKey = st.nextToken();
                break;
            }
            if (authKey == null) {
                throw new RuntimeException("authKey not found in " + data);
            }
            this.setAuthSubToken(authKey);
        }
        catch (Tools.HttpException httpEx) {
            if (httpEx.getErrorCode() != 403) {
                throw httpEx;
            }
            data = httpEx.getErrorData();
            st = new StringTokenizer(data, "\n\r=");
            googleErrorCode = null;
            ** while (st.hasMoreTokens())
        }
lbl-1000:
        // 1 sources

        {
            if (!st.nextToken().equalsIgnoreCase("Error")) continue;
            googleErrorCode = st.nextToken();
            break;
        }
lbl33:
        // 2 sources

        if (googleErrorCode == null) {
            throw httpEx;
        }
        throw new LoginException(googleErrorCode);
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public List<Object> queryApp(Market.AppsRequest requestGroup) {
        ArrayList<Object> retList = new ArrayList<Object>();
        this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setAppsRequest(requestGroup));
        Market.RequestContext ctxt = this.context.build();
        this.context = Market.RequestContext.newBuilder(ctxt);
        this.request.setContext(ctxt);
        try {
            Market.Response resp = this.executeProtobuf(this.request.build());
            for (Market.Response.ResponseGroup grp : resp.getResponseGroupList()) {
                if (!grp.hasAppsResponse()) continue;
                retList.add(grp.getAppsResponse());
            }
        }
        finally {
            this.request = Market.Request.newBuilder();
        }
        return retList;
    }

    public Market.CategoriesResponse queryCategories() {
        Market.RequestContext ctxt = this.context.build();
        this.context = Market.RequestContext.newBuilder(ctxt);
        this.request.setContext(ctxt);
        Market.CategoriesResponse categoriesResponse = null;
        try {
            Market.Response response = this.executeProtobuf(this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setCategoriesRequest(Market.CategoriesRequest.newBuilder().build())).setContext(ctxt).build());
            categoriesResponse = response.getResponseGroup(0).getCategoriesResponse();
        }
        finally {
            this.request = Market.Request.newBuilder();
        }
        return categoriesResponse;
    }

    public Market.GetAssetResponse queryGetAssetRequest(String assetId) {
        this.setIsSecure(true);
        Market.RequestContext ctxt = this.context.build();
        this.context = Market.RequestContext.newBuilder(ctxt);
        this.request.setContext(ctxt);
        Market.GetAssetResponse assetResponse = null;
        try {
            Market.Response response = this.executeProtobuf(this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setGetAssetRequest(Market.GetAssetRequest.newBuilder().setAssetId(assetId).build())).setContext(ctxt).build());
            assetResponse = response.getResponseGroup(0).getGetAssetResponse();
        }
        finally {
            this.setIsSecure(false);
            this.request = Market.Request.newBuilder();
        }
        return assetResponse;
    }

    public void append(Market.AppsRequest requestGroup, Callback<Market.AppsResponse> responseCallback) {
        this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setAppsRequest(requestGroup));
        this.callbacks.add(responseCallback);
    }

    public void append(Market.GetImageRequest requestGroup, Callback<Market.GetImageResponse> responseCallback) {
        this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setImageRequest(requestGroup));
        this.callbacks.add(responseCallback);
    }

    public void append(Market.CommentsRequest requestGroup, Callback<Market.CommentsResponse> responseCallback) {
        this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setCommentsRequest(requestGroup));
        this.callbacks.add(responseCallback);
    }

    public void append(Market.CategoriesRequest requestGroup, Callback<Market.CategoriesResponse> responseCallback) {
        this.request.addRequestGroup(Market.Request.RequestGroup.newBuilder().setCategoriesRequest(requestGroup));
        this.callbacks.add(responseCallback);
    }

    public void flush() {
        Market.RequestContext ctxt = this.context.build();
        this.context = Market.RequestContext.newBuilder(ctxt);
        this.request.setContext(ctxt);
        try {
            Market.Response resp = this.executeProtobuf(this.request.build());
            int i = 0;
            for (Market.Response.ResponseGroup grp : resp.getResponseGroupList()) {
                GeneratedMessage val = null;
                if (grp.hasAppsResponse()) {
                    val = grp.getAppsResponse();
                }
                if (grp.hasCategoriesResponse()) {
                    val = grp.getCategoriesResponse();
                }
                if (grp.hasCommentsResponse()) {
                    val = grp.getCommentsResponse();
                }
                if (grp.hasImageResponse()) {
                    val = grp.getImageResponse();
                }
                this.callbacks.get(i).onResult(grp.getContext(), val);
                ++i;
            }
        }
        finally {
            this.request = Market.Request.newBuilder();
            this.callbacks.clear();
        }
    }

    public Market.Response.ResponseGroup execute(Market.Request.RequestGroup requestGroup) {
        Market.RequestContext ctxt = this.context.build();
        this.context = Market.RequestContext.newBuilder(ctxt);
        this.request.setContext(ctxt);
        Market.Response resp = this.executeProtobuf(this.request.addRequestGroup(requestGroup).setContext(ctxt).build());
        return resp.getResponseGroup(0);
    }

    private Market.Response executeProtobuf(Market.Request request) {
        byte[] requestBytes = request.toByteArray();
        byte[] responseBytes = null;
        try {
            responseBytes = !this.context.getIsSecure() ? this.executeRawHttpQuery(requestBytes) : this.executeRawHttpsQuery(requestBytes);
            Market.Response r = Market.Response.parseFrom(responseBytes);
            return r;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private byte[] executeRawHttpQuery(byte[] request) {
        try {
            int nb;
            URL url = new URL("http://android.clients.google.com/market/api/ApiRequest");
            HttpURLConnection cnx = (HttpURLConnection)url.openConnection();
            cnx.setDoOutput(true);
            cnx.setRequestMethod("POST");
            cnx.setRequestProperty("Cookie", "ANDROID=" + this.authSubToken);
            cnx.setRequestProperty("User-Agent", "Android-Market/2 (sapphire PLAT-RC33); gzip");
            cnx.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            cnx.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            String request64 = Base64.encodeBytes(request, 16);
            String requestData = "version=2&request=" + request64;
            cnx.setFixedLengthStreamingMode(requestData.getBytes("UTF-8").length);
            OutputStream os = cnx.getOutputStream();
            os.write(requestData.getBytes());
            os.close();
            if (cnx.getResponseCode() >= 400) {
                throw new RuntimeException("Response code = " + cnx.getResponseCode() + ", msg = " + cnx.getResponseMessage());
            }
            InputStream is = cnx.getInputStream();
            GZIPInputStream gzIs = new GZIPInputStream(is);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((nb = gzIs.read(buff)) >= 0) {
                bos.write(buff, 0, nb);
            }
            is.close();
            cnx.disconnect();
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Boolean trustAll() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String arg0, SSLSession arg1) {
                    return true;
                }
            });
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] executeRawHttpsQuery(byte[] request) {
        if (request == null) {
            return null;
        }
        if (!this.trustAll().booleanValue()) {
            return null;
        }
        try {
            int nb;
            URL url = new URL("https://android.clients.google.com/market/api/ApiRequest");
            HttpsURLConnection cnx = (HttpsURLConnection)url.openConnection();
            cnx.setDoOutput(true);
            cnx.setRequestMethod("POST");
            cnx.setRequestProperty("Cookie", "ANDROIDSECURE=" + this.getAuthSubToken());
            cnx.setRequestProperty("User-Agent", "Android-Market/2 (sapphire PLAT-RC33); gzip");
            cnx.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            cnx.setRequestProperty("Accept-Charset", "ISO-8859-1,utf-8;q=0.7,*;q=0.7");
            String request64 = Base64.encodeBytes(request, 16);
            String requestData = "version=2&request=" + request64;
            cnx.setFixedLengthStreamingMode(requestData.getBytes("UTF-8").length);
            OutputStream os = cnx.getOutputStream();
            os.write(requestData.getBytes());
            os.close();
            if (cnx.getResponseCode() >= 400) {
                cnx.disconnect();
                throw new IOException("Response code = " + cnx.getResponseCode() + ", msg = " + cnx.getResponseMessage());
            }
            InputStream is = cnx.getInputStream();
            GZIPInputStream gzIs = new GZIPInputStream(is);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buff = new byte[1024];
            while ((nb = gzIs.read(buff)) >= 0) {
                bos.write(buff, 0, nb);
            }
            is.close();
            cnx.disconnect();
            return bos.toByteArray();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static interface Callback<T> {
        public void onResult(Market.ResponseContext var1, T var2);
    }
}

