/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.app;

import android.app.ActionBar;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentTransaction;
import android.view.View;
import android.view.ViewGroup;
import android.widget.SpinnerAdapter;
import com.actionbarsherlock.app.ActionBar;
import java.util.HashSet;
import java.util.Set;

public class ActionBarWrapper
extends com.actionbarsherlock.app.ActionBar
implements ActionBar.OnNavigationListener,
ActionBar.OnMenuVisibilityListener {
    private final Activity mActivity;
    private final ActionBar mActionBar;
    private ActionBar.OnNavigationListener mNavigationListener;
    private Set<ActionBar.OnMenuVisibilityListener> mMenuVisibilityListeners = new HashSet<ActionBar.OnMenuVisibilityListener>(1);
    private FragmentTransaction mFragmentTransaction;

    public ActionBarWrapper(Activity activity) {
        this.mActivity = activity;
        this.mActionBar = activity.getActionBar();
        if (this.mActionBar != null) {
            this.mActionBar.addOnMenuVisibilityListener((ActionBar.OnMenuVisibilityListener)this);
            int displayOptions = this.mActionBar.getDisplayOptions();
            this.mActionBar.setHomeButtonEnabled((displayOptions & 4) != 0);
        }
    }

    @Override
    public void setHomeButtonEnabled(boolean enabled) {
        this.mActionBar.setHomeButtonEnabled(enabled);
    }

    @Override
    public Context getThemedContext() {
        return this.mActionBar.getThemedContext();
    }

    @Override
    public void setCustomView(View view) {
        this.mActionBar.setCustomView(view);
    }

    @Override
    public void setCustomView(View view, ActionBar.LayoutParams layoutParams) {
        ActionBar.LayoutParams lp = new ActionBar.LayoutParams((ViewGroup.LayoutParams)layoutParams);
        lp.gravity = layoutParams.gravity;
        lp.bottomMargin = layoutParams.bottomMargin;
        lp.topMargin = layoutParams.topMargin;
        lp.leftMargin = layoutParams.leftMargin;
        lp.rightMargin = layoutParams.rightMargin;
        this.mActionBar.setCustomView(view, lp);
    }

    @Override
    public void setCustomView(int resId) {
        this.mActionBar.setCustomView(resId);
    }

    @Override
    public void setIcon(int resId) {
        this.mActionBar.setIcon(resId);
    }

    @Override
    public void setIcon(Drawable icon) {
        this.mActionBar.setIcon(icon);
    }

    @Override
    public void setLogo(int resId) {
        this.mActionBar.setLogo(resId);
    }

    @Override
    public void setLogo(Drawable logo) {
        this.mActionBar.setLogo(logo);
    }

    @Override
    public void setListNavigationCallbacks(SpinnerAdapter adapter, ActionBar.OnNavigationListener callback) {
        this.mNavigationListener = callback;
        this.mActionBar.setListNavigationCallbacks(adapter, (ActionBar.OnNavigationListener)(callback != null ? this : null));
    }

    public boolean onNavigationItemSelected(int itemPosition, long itemId) {
        return this.mNavigationListener.onNavigationItemSelected(itemPosition, itemId);
    }

    @Override
    public void setSelectedNavigationItem(int position) {
        this.mActionBar.setSelectedNavigationItem(position);
    }

    @Override
    public int getSelectedNavigationIndex() {
        return this.mActionBar.getSelectedNavigationIndex();
    }

    @Override
    public int getNavigationItemCount() {
        return this.mActionBar.getNavigationItemCount();
    }

    @Override
    public void setTitle(CharSequence title) {
        this.mActionBar.setTitle(title);
    }

    @Override
    public void setTitle(int resId) {
        this.mActionBar.setTitle(resId);
    }

    @Override
    public void setSubtitle(CharSequence subtitle) {
        this.mActionBar.setSubtitle(subtitle);
    }

    @Override
    public void setSubtitle(int resId) {
        this.mActionBar.setSubtitle(resId);
    }

    @Override
    public void setDisplayOptions(int options) {
        this.mActionBar.setDisplayOptions(options);
        this.mActionBar.setHomeButtonEnabled((options & 4) != 0);
    }

    @Override
    public void setDisplayOptions(int options, int mask) {
        this.mActionBar.setDisplayOptions(options, mask);
        if ((mask & 4) != 0) {
            this.mActionBar.setHomeButtonEnabled((options & 4) != 0);
        }
    }

    @Override
    public void setDisplayUseLogoEnabled(boolean useLogo) {
        this.mActionBar.setDisplayUseLogoEnabled(useLogo);
    }

    @Override
    public void setDisplayShowHomeEnabled(boolean showHome) {
        this.mActionBar.setDisplayShowHomeEnabled(showHome);
    }

    @Override
    public void setDisplayHomeAsUpEnabled(boolean showHomeAsUp) {
        this.mActionBar.setDisplayHomeAsUpEnabled(showHomeAsUp);
    }

    @Override
    public void setDisplayShowTitleEnabled(boolean showTitle) {
        this.mActionBar.setDisplayShowTitleEnabled(showTitle);
    }

    @Override
    public void setDisplayShowCustomEnabled(boolean showCustom) {
        this.mActionBar.setDisplayShowCustomEnabled(showCustom);
    }

    @Override
    public void setBackgroundDrawable(Drawable d) {
        this.mActionBar.setBackgroundDrawable(d);
    }

    @Override
    public void setStackedBackgroundDrawable(Drawable d) {
        this.mActionBar.setStackedBackgroundDrawable(d);
    }

    @Override
    public void setSplitBackgroundDrawable(Drawable d) {
        this.mActionBar.setSplitBackgroundDrawable(d);
    }

    @Override
    public View getCustomView() {
        return this.mActionBar.getCustomView();
    }

    @Override
    public CharSequence getTitle() {
        return this.mActionBar.getTitle();
    }

    @Override
    public CharSequence getSubtitle() {
        return this.mActionBar.getSubtitle();
    }

    @Override
    public int getNavigationMode() {
        return this.mActionBar.getNavigationMode();
    }

    @Override
    public void setNavigationMode(int mode) {
        this.mActionBar.setNavigationMode(mode);
    }

    @Override
    public int getDisplayOptions() {
        return this.mActionBar.getDisplayOptions();
    }

    @Override
    public ActionBar.Tab newTab() {
        return new TabWrapper(this.mActionBar.newTab());
    }

    @Override
    public void addTab(ActionBar.Tab tab) {
        this.mActionBar.addTab(((TabWrapper)tab).mNativeTab);
    }

    @Override
    public void addTab(ActionBar.Tab tab, boolean setSelected) {
        this.mActionBar.addTab(((TabWrapper)tab).mNativeTab, setSelected);
    }

    @Override
    public void addTab(ActionBar.Tab tab, int position) {
        this.mActionBar.addTab(((TabWrapper)tab).mNativeTab, position);
    }

    @Override
    public void addTab(ActionBar.Tab tab, int position, boolean setSelected) {
        this.mActionBar.addTab(((TabWrapper)tab).mNativeTab, position, setSelected);
    }

    @Override
    public void removeTab(ActionBar.Tab tab) {
        this.mActionBar.removeTab(((TabWrapper)tab).mNativeTab);
    }

    @Override
    public void removeTabAt(int position) {
        this.mActionBar.removeTabAt(position);
    }

    @Override
    public void removeAllTabs() {
        this.mActionBar.removeAllTabs();
    }

    @Override
    public void selectTab(ActionBar.Tab tab) {
        this.mActionBar.selectTab(((TabWrapper)tab).mNativeTab);
    }

    @Override
    public ActionBar.Tab getSelectedTab() {
        ActionBar.Tab selected = this.mActionBar.getSelectedTab();
        return selected != null ? (ActionBar.Tab)selected.getTag() : null;
    }

    @Override
    public ActionBar.Tab getTabAt(int index) {
        ActionBar.Tab selected = this.mActionBar.getTabAt(index);
        return selected != null ? (ActionBar.Tab)selected.getTag() : null;
    }

    @Override
    public int getTabCount() {
        return this.mActionBar.getTabCount();
    }

    @Override
    public int getHeight() {
        return this.mActionBar.getHeight();
    }

    @Override
    public void show() {
        this.mActionBar.show();
    }

    @Override
    public void hide() {
        this.mActionBar.hide();
    }

    @Override
    public boolean isShowing() {
        return this.mActionBar.isShowing();
    }

    @Override
    public void addOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.add(listener);
    }

    @Override
    public void removeOnMenuVisibilityListener(ActionBar.OnMenuVisibilityListener listener) {
        this.mMenuVisibilityListeners.remove(listener);
    }

    public void onMenuVisibilityChanged(boolean isVisible) {
        for (ActionBar.OnMenuVisibilityListener listener : this.mMenuVisibilityListeners) {
            listener.onMenuVisibilityChanged(isVisible);
        }
    }

    public class TabWrapper
    extends ActionBar.Tab
    implements ActionBar.TabListener {
        final ActionBar.Tab mNativeTab;
        private Object mTag;
        private ActionBar.TabListener mListener;

        public TabWrapper(ActionBar.Tab nativeTab) {
            this.mNativeTab = nativeTab;
            this.mNativeTab.setTag((Object)this);
        }

        @Override
        public int getPosition() {
            return this.mNativeTab.getPosition();
        }

        @Override
        public Drawable getIcon() {
            return this.mNativeTab.getIcon();
        }

        @Override
        public CharSequence getText() {
            return this.mNativeTab.getText();
        }

        @Override
        public ActionBar.Tab setIcon(Drawable icon) {
            this.mNativeTab.setIcon(icon);
            return this;
        }

        @Override
        public ActionBar.Tab setIcon(int resId) {
            this.mNativeTab.setIcon(resId);
            return this;
        }

        @Override
        public ActionBar.Tab setText(CharSequence text) {
            this.mNativeTab.setText(text);
            return this;
        }

        @Override
        public ActionBar.Tab setText(int resId) {
            this.mNativeTab.setText(resId);
            return this;
        }

        @Override
        public ActionBar.Tab setCustomView(View view) {
            this.mNativeTab.setCustomView(view);
            return this;
        }

        @Override
        public ActionBar.Tab setCustomView(int layoutResId) {
            this.mNativeTab.setCustomView(layoutResId);
            return this;
        }

        @Override
        public View getCustomView() {
            return this.mNativeTab.getCustomView();
        }

        @Override
        public ActionBar.Tab setTag(Object obj) {
            this.mTag = obj;
            return this;
        }

        @Override
        public Object getTag() {
            return this.mTag;
        }

        @Override
        public ActionBar.Tab setTabListener(ActionBar.TabListener listener) {
            this.mNativeTab.setTabListener((ActionBar.TabListener)(listener != null ? this : null));
            this.mListener = listener;
            return this;
        }

        @Override
        public void select() {
            this.mNativeTab.select();
        }

        @Override
        public ActionBar.Tab setContentDescription(int resId) {
            this.mNativeTab.setContentDescription(resId);
            return this;
        }

        @Override
        public ActionBar.Tab setContentDescription(CharSequence contentDesc) {
            this.mNativeTab.setContentDescription(contentDesc);
            return this;
        }

        @Override
        public CharSequence getContentDescription() {
            return this.mNativeTab.getContentDescription();
        }

        public void onTabReselected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            if (this.mListener != null) {
                FragmentTransaction trans = null;
                if (ActionBarWrapper.this.mActivity instanceof FragmentActivity) {
                    trans = ((FragmentActivity)ActionBarWrapper.this.mActivity).getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
                }
                this.mListener.onTabReselected(this, trans);
                if (trans != null && !trans.isEmpty()) {
                    trans.commit();
                }
            }
        }

        public void onTabSelected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            if (this.mListener != null) {
                if (ActionBarWrapper.this.mFragmentTransaction == null && ActionBarWrapper.this.mActivity instanceof FragmentActivity) {
                    ActionBarWrapper.this.mFragmentTransaction = ((FragmentActivity)ActionBarWrapper.this.mActivity).getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
                }
                this.mListener.onTabSelected(this, ActionBarWrapper.this.mFragmentTransaction);
                if (ActionBarWrapper.this.mFragmentTransaction != null) {
                    if (!ActionBarWrapper.this.mFragmentTransaction.isEmpty()) {
                        ActionBarWrapper.this.mFragmentTransaction.commit();
                    }
                    ActionBarWrapper.this.mFragmentTransaction = null;
                }
            }
        }

        public void onTabUnselected(ActionBar.Tab tab, android.app.FragmentTransaction ft) {
            if (this.mListener != null) {
                FragmentTransaction trans = null;
                if (ActionBarWrapper.this.mActivity instanceof FragmentActivity) {
                    trans = ((FragmentActivity)ActionBarWrapper.this.mActivity).getSupportFragmentManager().beginTransaction().disallowAddToBackStack();
                    ActionBarWrapper.this.mFragmentTransaction = trans;
                }
                this.mListener.onTabUnselected(this, trans);
            }
        }
    }
}

