/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.internal.nineoldandroids.animation;

import android.view.animation.Interpolator;
import com.actionbarsherlock.internal.nineoldandroids.animation.Keyframe;
import com.actionbarsherlock.internal.nineoldandroids.animation.KeyframeSet;
import java.util.ArrayList;

class FloatKeyframeSet
extends KeyframeSet {
    private float firstValue;
    private float lastValue;
    private float deltaValue;
    private boolean firstTime = true;

    public FloatKeyframeSet(Keyframe.FloatKeyframe ... keyframes) {
        super(keyframes);
    }

    @Override
    public Object getValue(float fraction) {
        return Float.valueOf(this.getFloatValue(fraction));
    }

    @Override
    public FloatKeyframeSet clone() {
        ArrayList keyframes = this.mKeyframes;
        int numKeyframes = this.mKeyframes.size();
        Keyframe.FloatKeyframe[] newKeyframes = new Keyframe.FloatKeyframe[numKeyframes];
        int i = 0;
        while (i < numKeyframes) {
            newKeyframes[i] = (Keyframe.FloatKeyframe)((Keyframe)keyframes.get(i)).clone();
            ++i;
        }
        FloatKeyframeSet newSet = new FloatKeyframeSet(newKeyframes);
        return newSet;
    }

    public float getFloatValue(float fraction) {
        if (this.mNumKeyframes == 2) {
            if (this.firstTime) {
                this.firstTime = false;
                this.firstValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(0)).getFloatValue();
                this.lastValue = ((Keyframe.FloatKeyframe)this.mKeyframes.get(1)).getFloatValue();
                this.deltaValue = this.lastValue - this.firstValue;
            }
            if (this.mInterpolator != null) {
                fraction = this.mInterpolator.getInterpolation(fraction);
            }
            if (this.mEvaluator == null) {
                return this.firstValue + fraction * this.deltaValue;
            }
            return ((Number)this.mEvaluator.evaluate(fraction, Float.valueOf(this.firstValue), Float.valueOf(this.lastValue))).floatValue();
        }
        if (fraction <= 0.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(1);
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
        }
        if (fraction >= 1.0f) {
            Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 2);
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(this.mNumKeyframes - 1);
            float prevValue = prevKeyframe.getFloatValue();
            float nextValue = nextKeyframe.getFloatValue();
            float prevFraction = prevKeyframe.getFraction();
            float nextFraction = nextKeyframe.getFraction();
            Interpolator interpolator = nextKeyframe.getInterpolator();
            if (interpolator != null) {
                fraction = interpolator.getInterpolation(fraction);
            }
            float intervalFraction = (fraction - prevFraction) / (nextFraction - prevFraction);
            return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
        }
        Keyframe.FloatKeyframe prevKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(0);
        int i = 1;
        while (i < this.mNumKeyframes) {
            Keyframe.FloatKeyframe nextKeyframe = (Keyframe.FloatKeyframe)this.mKeyframes.get(i);
            if (fraction < nextKeyframe.getFraction()) {
                Interpolator interpolator = nextKeyframe.getInterpolator();
                if (interpolator != null) {
                    fraction = interpolator.getInterpolation(fraction);
                }
                float intervalFraction = (fraction - prevKeyframe.getFraction()) / (nextKeyframe.getFraction() - prevKeyframe.getFraction());
                float prevValue = prevKeyframe.getFloatValue();
                float nextValue = nextKeyframe.getFloatValue();
                return this.mEvaluator == null ? prevValue + intervalFraction * (nextValue - prevValue) : ((Number)this.mEvaluator.evaluate(intervalFraction, Float.valueOf(prevValue), Float.valueOf(nextValue))).floatValue();
            }
            prevKeyframe = nextKeyframe;
            ++i;
        }
        return ((Number)((Keyframe)this.mKeyframes.get(this.mNumKeyframes - 1)).getValue()).floatValue();
    }
}

