/*
 * Decompiled with CFR 0.152.
 */
package com.actionbarsherlock.widget;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.database.DataSetObservable;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.util.Xml;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class ActivityChooserModel
extends DataSetObservable {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = ActivityChooserModel.class.getSimpleName();
    private static final String TAG_HISTORICAL_RECORDS = "historical-records";
    private static final String TAG_HISTORICAL_RECORD = "historical-record";
    private static final String ATTRIBUTE_ACTIVITY = "activity";
    private static final String ATTRIBUTE_TIME = "time";
    private static final String ATTRIBUTE_WEIGHT = "weight";
    public static final String DEFAULT_HISTORY_FILE_NAME = "activity_choser_model_history.xml";
    public static final int DEFAULT_HISTORY_MAX_LENGTH = 50;
    private static final int DEFAULT_ACTIVITY_INFLATION = 5;
    private static final float DEFAULT_HISTORICAL_RECORD_WEIGHT = 1.0f;
    private static final String HISTORY_FILE_EXTENSION = ".xml";
    private static final int INVALID_INDEX = -1;
    private static final Object sRegistryLock = new Object();
    private static final Map<String, ActivityChooserModel> sDataModelRegistry = new HashMap<String, ActivityChooserModel>();
    private final Object mInstanceLock = new Object();
    private final List<ActivityResolveInfo> mActivites = new ArrayList<ActivityResolveInfo>();
    private final List<HistoricalRecord> mHistoricalRecords = new ArrayList<HistoricalRecord>();
    private final Context mContext;
    private final String mHistoryFileName;
    private Intent mIntent;
    private ActivitySorter mActivitySorter = new DefaultSorter();
    private int mHistoryMaxSize = 50;
    private boolean mCanReadHistoricalData = true;
    private boolean mReadShareHistoryCalled = false;
    private boolean mHistoricalRecordsChanged = true;
    private final Handler mHandler = new Handler();
    private OnChooseActivityListener mActivityChoserModelPolicy;
    private static final Executor SERIAL_EXECUTOR = Executors.newSingleThreadExecutor();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ActivityChooserModel get(Context context, String historyFileName) {
        Object object = sRegistryLock;
        synchronized (object) {
            ActivityChooserModel dataModel = sDataModelRegistry.get(historyFileName);
            if (dataModel == null) {
                dataModel = new ActivityChooserModel(context, historyFileName);
                sDataModelRegistry.put(historyFileName, dataModel);
            }
            dataModel.readHistoricalData();
            return dataModel;
        }
    }

    private ActivityChooserModel(Context context, String historyFileName) {
        this.mContext = context.getApplicationContext();
        this.mHistoryFileName = !TextUtils.isEmpty((CharSequence)historyFileName) && !historyFileName.endsWith(HISTORY_FILE_EXTENSION) ? String.valueOf(historyFileName) + HISTORY_FILE_EXTENSION : historyFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntent(Intent intent) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mIntent == intent) {
                return;
            }
            this.mIntent = intent;
            this.loadActivitiesLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Intent getIntent() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mIntent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivityCount() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mActivites.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getActivity(int index) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mActivites.get((int)index).resolveInfo;
        }
    }

    public int getActivityIndex(ResolveInfo activity) {
        List<ActivityResolveInfo> activities = this.mActivites;
        int activityCount = activities.size();
        int i = 0;
        while (i < activityCount) {
            ActivityResolveInfo currentActivity = activities.get(i);
            if (currentActivity.resolveInfo == activity) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Intent chooseActivity(int index) {
        Intent choiceIntentCopy;
        boolean handled;
        ActivityResolveInfo chosenActivity = this.mActivites.get(index);
        ComponentName chosenName = new ComponentName(chosenActivity.resolveInfo.activityInfo.packageName, chosenActivity.resolveInfo.activityInfo.name);
        Intent choiceIntent = new Intent(this.mIntent);
        choiceIntent.setComponent(chosenName);
        if (this.mActivityChoserModelPolicy != null && (handled = this.mActivityChoserModelPolicy.onChooseActivity(this, choiceIntentCopy = new Intent(choiceIntent)))) {
            return null;
        }
        HistoricalRecord historicalRecord = new HistoricalRecord(chosenName, System.currentTimeMillis(), 1.0f);
        this.addHisoricalRecord(historicalRecord);
        return choiceIntent;
    }

    public void setOnChooseActivityListener(OnChooseActivityListener listener) {
        this.mActivityChoserModelPolicy = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveInfo getDefaultActivity() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mActivites.isEmpty()) {
                return this.mActivites.get((int)0).resolveInfo;
            }
        }
        return null;
    }

    public void setDefaultActivity(int index) {
        ActivityResolveInfo newDefaultActivity = this.mActivites.get(index);
        ActivityResolveInfo oldDefaultActivity = this.mActivites.get(0);
        float weight = oldDefaultActivity != null ? oldDefaultActivity.weight - newDefaultActivity.weight + 5.0f : 1.0f;
        ComponentName defaultName = new ComponentName(newDefaultActivity.resolveInfo.activityInfo.packageName, newDefaultActivity.resolveInfo.activityInfo.name);
        HistoricalRecord historicalRecord = new HistoricalRecord(defaultName, System.currentTimeMillis(), weight);
        this.addHisoricalRecord(historicalRecord);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistoricalData() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mCanReadHistoricalData || !this.mHistoricalRecordsChanged) {
                return;
            }
            this.mCanReadHistoricalData = false;
            this.mReadShareHistoryCalled = true;
            if (!TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
                SERIAL_EXECUTOR.execute(new HistoryLoader());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistHistoricalData() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (!this.mReadShareHistoryCalled) {
                throw new IllegalStateException("No preceding call to #readHistoricalData");
            }
            if (!this.mHistoricalRecordsChanged) {
                return;
            }
            this.mHistoricalRecordsChanged = false;
            this.mCanReadHistoricalData = true;
            if (!TextUtils.isEmpty((CharSequence)this.mHistoryFileName)) {
                SERIAL_EXECUTOR.execute(new HistoryPersister());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setActivitySorter(ActivitySorter activitySorter) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter == activitySorter) {
                return;
            }
            this.mActivitySorter = activitySorter;
            this.sortActivities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortActivities() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mActivitySorter != null && !this.mActivites.isEmpty()) {
                this.mActivitySorter.sort(this.mIntent, this.mActivites, Collections.unmodifiableList(this.mHistoricalRecords));
                this.notifyChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryMaxSize(int historyMaxSize) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (this.mHistoryMaxSize == historyMaxSize) {
                return;
            }
            this.mHistoryMaxSize = historyMaxSize;
            this.pruneExcessiveHistoricalRecordsLocked();
            this.sortActivities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistoryMaxSize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoryMaxSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getHistorySize() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            return this.mHistoricalRecords.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addHisoricalRecord(HistoricalRecord historicalRecord) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean added = this.mHistoricalRecords.add(historicalRecord);
            if (added) {
                this.mHistoricalRecordsChanged = true;
                this.pruneExcessiveHistoricalRecordsLocked();
                this.persistHistoricalData();
                this.sortActivities();
            }
            return added;
        }
    }

    private void pruneExcessiveHistoricalRecordsLocked() {
        List<HistoricalRecord> choiceRecords = this.mHistoricalRecords;
        int pruneCount = choiceRecords.size() - this.mHistoryMaxSize;
        if (pruneCount <= 0) {
            return;
        }
        this.mHistoricalRecordsChanged = true;
        int i = 0;
        while (i < pruneCount) {
            HistoricalRecord historicalRecord = choiceRecords.remove(0);
            ++i;
        }
    }

    private void loadActivitiesLocked() {
        this.mActivites.clear();
        if (this.mIntent != null) {
            List resolveInfos = this.mContext.getPackageManager().queryIntentActivities(this.mIntent, 0);
            int resolveInfoCount = resolveInfos.size();
            int i = 0;
            while (i < resolveInfoCount) {
                ResolveInfo resolveInfo = (ResolveInfo)resolveInfos.get(i);
                this.mActivites.add(new ActivityResolveInfo(resolveInfo));
                ++i;
            }
            this.sortActivities();
        } else {
            this.notifyChanged();
        }
    }

    public static interface ActivityChooserModelClient {
        public void setActivityChooserModel(ActivityChooserModel var1);
    }

    public final class ActivityResolveInfo
    implements Comparable<ActivityResolveInfo> {
        public final ResolveInfo resolveInfo;
        public float weight;

        public ActivityResolveInfo(ResolveInfo resolveInfo) {
            this.resolveInfo = resolveInfo;
        }

        public int hashCode() {
            return 31 + Float.floatToIntBits(this.weight);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ActivityResolveInfo other = (ActivityResolveInfo)obj;
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        @Override
        public int compareTo(ActivityResolveInfo another) {
            return Float.floatToIntBits(another.weight) - Float.floatToIntBits(this.weight);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("resolveInfo:").append(this.resolveInfo.toString());
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }
    }

    public static interface ActivitySorter {
        public void sort(Intent var1, List<ActivityResolveInfo> var2, List<HistoricalRecord> var3);
    }

    private final class DefaultSorter
    implements ActivitySorter {
        private static final float WEIGHT_DECAY_COEFFICIENT = 0.95f;
        private final Map<String, ActivityResolveInfo> mPackageNameToActivityMap = new HashMap<String, ActivityResolveInfo>();

        private DefaultSorter() {
        }

        @Override
        public void sort(Intent intent, List<ActivityResolveInfo> activities, List<HistoricalRecord> historicalRecords) {
            Map<String, ActivityResolveInfo> packageNameToActivityMap = this.mPackageNameToActivityMap;
            packageNameToActivityMap.clear();
            int activityCount = activities.size();
            int i = 0;
            while (i < activityCount) {
                ActivityResolveInfo activity = activities.get(i);
                activity.weight = 0.0f;
                String packageName = activity.resolveInfo.activityInfo.packageName;
                packageNameToActivityMap.put(packageName, activity);
                ++i;
            }
            int lastShareIndex = historicalRecords.size() - 1;
            float nextRecordWeight = 1.0f;
            int i2 = lastShareIndex;
            while (i2 >= 0) {
                HistoricalRecord historicalRecord = historicalRecords.get(i2);
                String packageName = historicalRecord.activity.getPackageName();
                ActivityResolveInfo activity = packageNameToActivityMap.get(packageName);
                if (activity != null) {
                    activity.weight += historicalRecord.weight * nextRecordWeight;
                    nextRecordWeight *= 0.95f;
                }
                --i2;
            }
            Collections.sort(activities);
        }
    }

    public static final class HistoricalRecord {
        public final ComponentName activity;
        public final long time;
        public final float weight;

        public HistoricalRecord(String activityName, long time, float weight) {
            this(ComponentName.unflattenFromString((String)activityName), time, weight);
        }

        public HistoricalRecord(ComponentName activityName, long time, float weight) {
            this.activity = activityName;
            this.time = time;
            this.weight = weight;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.activity == null ? 0 : this.activity.hashCode());
            result = 31 * result + (int)(this.time ^ this.time >>> 32);
            result = 31 * result + Float.floatToIntBits(this.weight);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HistoricalRecord other = (HistoricalRecord)obj;
            if (this.activity == null ? other.activity != null : !this.activity.equals((Object)other.activity)) {
                return false;
            }
            if (this.time != other.time) {
                return false;
            }
            return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append("; activity:").append(this.activity);
            builder.append("; time:").append(this.time);
            builder.append("; weight:").append(new BigDecimal(this.weight));
            builder.append("]");
            return builder.toString();
        }
    }

    private final class HistoryLoader
    implements Runnable {
        private HistoryLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            FileInputStream fis = null;
            try {
                fis = ActivityChooserModel.this.mContext.openFileInput(ActivityChooserModel.this.mHistoryFileName);
            }
            catch (FileNotFoundException fnfe) {
                return;
            }
            try {
                XmlPullParser parser = Xml.newPullParser();
                parser.setInput((InputStream)fis, null);
                int type = 0;
                while (type != 1 && type != 2) {
                    type = parser.next();
                }
                if (!ActivityChooserModel.TAG_HISTORICAL_RECORDS.equals(parser.getName())) {
                    throw new XmlPullParserException("Share records file does not start with historical-records tag.");
                }
                ArrayList<HistoricalRecord> readRecords = new ArrayList<HistoricalRecord>();
                while ((type = parser.next()) != 1) {
                    if (type == 3 || type == 4) continue;
                    String nodeName = parser.getName();
                    if (!ActivityChooserModel.TAG_HISTORICAL_RECORD.equals(nodeName)) {
                        throw new XmlPullParserException("Share records file not well-formed.");
                    }
                    String activity = parser.getAttributeValue(null, ActivityChooserModel.ATTRIBUTE_ACTIVITY);
                    long time = Long.parseLong(parser.getAttributeValue(null, ActivityChooserModel.ATTRIBUTE_TIME));
                    float weight = Float.parseFloat(parser.getAttributeValue(null, ActivityChooserModel.ATTRIBUTE_WEIGHT));
                    HistoricalRecord readRecord = new HistoricalRecord(activity, time, weight);
                    readRecords.add(readRecord);
                }
                Object object = ActivityChooserModel.this.mInstanceLock;
                synchronized (object) {
                    List historicalRecords;
                    LinkedHashSet<HistoricalRecord> uniqueShareRecords;
                    block30: {
                        uniqueShareRecords = new LinkedHashSet<HistoricalRecord>(readRecords);
                        historicalRecords = ActivityChooserModel.this.mHistoricalRecords;
                        int historicalRecordsCount = historicalRecords.size();
                        int i = historicalRecordsCount - 1;
                        while (i >= 0) {
                            HistoricalRecord historicalRecord = (HistoricalRecord)historicalRecords.get(i);
                            uniqueShareRecords.add(historicalRecord);
                            --i;
                        }
                        if (historicalRecords.size() != uniqueShareRecords.size()) break block30;
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    try {
                        historicalRecords.clear();
                        historicalRecords.addAll(uniqueShareRecords);
                        ActivityChooserModel.this.mHistoricalRecordsChanged = true;
                        ActivityChooserModel.this.mHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                ActivityChooserModel.this.pruneExcessiveHistoricalRecordsLocked();
                                ActivityChooserModel.this.sortActivities();
                            }
                        });
                    }
                    catch (XmlPullParserException xppe) {
                        Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)xppe);
                    }
                    catch (IOException ioe) {
                        Log.e((String)LOG_TAG, (String)("Error reading historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)ioe);
                    }
                }
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            {
                return;
            }
        }
    }

    private final class HistoryPersister
    implements Runnable {
        private HistoryPersister() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            FileOutputStream fos = null;
            ArrayList records = null;
            Object object = ActivityChooserModel.this.mInstanceLock;
            synchronized (object) {
                records = new ArrayList(ActivityChooserModel.this.mHistoricalRecords);
            }
            try {
                fos = ActivityChooserModel.this.mContext.openFileOutput(ActivityChooserModel.this.mHistoryFileName, 0);
            }
            catch (FileNotFoundException fnfe) {
                Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)fnfe);
                return;
            }
            XmlSerializer serializer = Xml.newSerializer();
            try {
                try {
                    serializer.setOutput((OutputStream)fos, null);
                    serializer.startDocument("UTF-8", Boolean.valueOf(true));
                    serializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                    int recordCount = records.size();
                    int i = 0;
                    while (i < recordCount) {
                        HistoricalRecord record = (HistoricalRecord)records.remove(0);
                        serializer.startTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                        serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_ACTIVITY, record.activity.flattenToString());
                        serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_TIME, String.valueOf(record.time));
                        serializer.attribute(null, ActivityChooserModel.ATTRIBUTE_WEIGHT, String.valueOf(record.weight));
                        serializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORD);
                        ++i;
                    }
                    serializer.endTag(null, ActivityChooserModel.TAG_HISTORICAL_RECORDS);
                    serializer.endDocument();
                    return;
                }
                catch (IllegalArgumentException iae) {
                    Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)iae);
                    if (fos == null) return;
                    try {
                        fos.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                catch (IllegalStateException ise) {
                    Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)ise);
                    if (fos == null) return;
                    try {
                        fos.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
                catch (IOException ioe) {
                    Log.e((String)LOG_TAG, (String)("Error writing historical recrod file: " + ActivityChooserModel.this.mHistoryFileName), (Throwable)ioe);
                    if (fos == null) return;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    try {
                        fos.close();
                        return;
                    }
                    catch (IOException iOException) {}
                    return;
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static interface OnChooseActivityListener {
        public boolean onChooseActivity(ActivityChooserModel var1, Intent var2);
    }
}

