package jp.sourceforge.fosj.loan;

import jp.sourceforge.fosj.loan.export.ExportDialog;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.v4.app.FragmentTransaction;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Spinner;

//public class ResultActivity extends TabSwipeActivity {
public class ResultActivity extends AppCompatActivity {
    MenuItem addToCompareMenuItem;
    MenuItem openCompareMenuItem;
    MenuItem exportMenuItem;

    ResultFragment resultFragment = new ResultFragment();
    ScheduleFragment scheduleFragment = new ScheduleFragment();
    ChartFragment chartFragment = new ChartFragment();

    @Override
    public void onCreate(Bundle savedInstanceState) {
        setTheme(ThemeResolver.getActivityTheme(this));
        super.onCreate(savedInstanceState);
        setContentView(R.layout.result_activity);
        setTitle(getResources().getStringArray(R.array.shorttypes)[StartActivity.loan.getLoanType()]);
        Toolbar toolbar = (Toolbar) findViewById(R.id.result_toolbar);
        setSupportActionBar(toolbar);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        getSupportActionBar().setHomeButtonEnabled(true);

//        addTab(getString(R.string.tabResult), ResultFragment.class, new Bundle());
//        addTab(getString(R.string.tabSchedule), ScheduleFragment.class, new Bundle());
//        addTab(getString(R.string.tabChart), ChartFragment.class, new Bundle());

        FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
        transaction.add(R.id.container, resultFragment);
        transaction.commit();

        Spinner spinner = (Spinner) toolbar.findViewById(R.id.spinner_result);
        spinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                if (position == 0) {
                    FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
                    transaction.replace(R.id.container, resultFragment);
                    transaction.commit();
                } else if (position == 1) {
                    FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
                    transaction.replace(R.id.container, chartFragment);
                    transaction.commit();
                } else if (position == 2) {
                    FragmentTransaction transaction = getSupportFragmentManager().beginTransaction();
                    transaction.replace(R.id.container, scheduleFragment);
                    transaction.commit();
                }
            }

            @Override
            public void onNothingSelected(AdapterView<?> parent) {
            }
        });

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {

        int orientation = getResources().getConfiguration().orientation;
        addToCompareMenuItem = menu.add(R.string.addToCompare);
        addToCompareMenuItem
                .setIcon(ThemeResolver.getAddToCompareIcon(this))
                .setShowAsAction( orientation == Configuration.ORIENTATION_PORTRAIT ?  MenuItem.SHOW_AS_ACTION_IF_ROOM : MenuItem.SHOW_AS_ACTION_NEVER );

        openCompareMenuItem = menu.add(R.string.viewCompare);
        openCompareMenuItem
                .setIcon(R.drawable.ic_action_compare);

        exportMenuItem = menu.add(R.string.exportToEmail);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case android.R.id.home:
                finish();
                return (true);

        }

        if(item == addToCompareMenuItem){
            StartActivity.storeManager.addLoan( StartActivity.loan);
            Intent myIntent = new Intent(this, CompareActivity.class);
            startActivity(myIntent);
            return true;
        }
        if(item == openCompareMenuItem){
            Intent myIntent = new Intent(this, CompareActivity.class);
            startActivity(myIntent);
            return true;
        }
        if(item == exportMenuItem){
            ExportDialog dialog = new ExportDialog(this, ThemeResolver.getDialogTheme(this));
            dialog.show();
            return true;
        }
        return false;
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        switch(newConfig.orientation) {
            case Configuration.ORIENTATION_PORTRAIT:
                addToCompareMenuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_IF_ROOM | MenuItem.SHOW_AS_ACTION_WITH_TEXT);
                break;
            case Configuration.ORIENTATION_LANDSCAPE:
                addToCompareMenuItem.setShowAsAction(MenuItem.SHOW_AS_ACTION_NEVER);
                break;
        }
    }
}
