/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

document.addEventListener("deviceready", onDeviceReady, false);
//Fix :active state on device
document.addEventListener("touchstart", function() {}, false);
//when return to home
document.addEventListener("pause", onPause, false);
document.addEventListener("oncompletion", onCompletion, false);

var mediaPlayer;

function onDeviceReady() {
//    navigator.splashscreen.hide();
	mediaPlayer = new MediaPlayer();
	mediaPlayer.run();
	addOptionsMenu();
	addBanner();
}

function onPause() {
	mediaPlayer._stop();
}

function onCompletion() {
	mediaPlayer._stop();
}

function MediaPlayer() {
}

MediaPlayer.prototype = {
	mediaContent : null,
	isPlaying : false,
	    
	run: function() {
		var that = this,
		            src = "file:///android_asset/www/river-4.mp3";
	
		var playAudioButton = document.getElementById("buttonPlayAudio"),
		    stopAudioButton = document.getElementById("buttonStopAudio");
//		    pauseAudioButton = document.getElementById("buttonPauseAudio");
	
		playAudioButton.addEventListener("click",
			function() {
				that._play.apply(that, arguments)
			});
		
		stopAudioButton.addEventListener("click",
			function() {
				that._stop.apply(that, arguments)
			});
		
//		pauseAudioButton.addEventListener("click",
//			function() {
//				that._pause.apply(that, arguments)
//			});
		        
		that.mediaContent = new Media(src,
			function() {
				that._onMediaSuccess.apply(that, arguments);
			},
			function() {
				that._onError.apply(that, arguments);
			},
	        function() {
	            that._onMediaStatusChanged.apply(that, arguments);
	        });
	},
	    
	_onMediaSuccess: function() {
		console.log("mediaSuccess");
	},
	    
	_onError: function(error) {
		var errorMessage;

		if(typeof error === "string") {
			errorMessage = error;
		} else {
			errorMessage = "code: " + error.code + "\n" +
			"message: " + error.message + "\n";
		}

		this._showMessage(errorMessage);
		this.isPlaying = false;
	},
	    
	_onMediaStatusChanged: function(status) {
		console.log("Media status: " + status);
		if(status === 4) {
			this._showMessage('');
		}
	},
	    
	_play: function() {
	    if(this.isPlaying === false) {
	        this.mediaContent.play();
			this._showMessage('Playing...');
			this.isPlaying = true;
	    }
	},
	    
	_pause: function () {
		if(this.isPlaying === true) {
	        this.mediaContent.pause();
	        this._showMessage('Paused');
	        this.isPlaying = false;
	    }
	},
	    
	_stop: function () {
	    this.mediaContent.stop();
		this._showMessage('');
		this.isPlaying = false;
	},
	    
	_showMessage: function(text) {
		var statusBox = document.getElementById('result');
		statusBox.innerText = text;
	}
}

function addBanner() {
    var admob_ios_key = 'ca-app-pub-6869992474017983/4806197152';
    var admob_android_key = 'ca-app-pub-9209419102968336/5983763208';
    var adId = (/(android)/i.test(navigator.userAgent)) ? admob_android_key : admob_ios_key;

    if( window.plugins && window.plugins.AdMob ) {
        var am = window.plugins.AdMob;
        am.createBannerView( 
            {
            'publisherId': adId,
            'adSize': am.AD_SIZE.BANNER,
            'bannerAtTop': false, // set to true, to make banner at top
            'overlap': false,  // set to true, to allow banner view overlap web content instead of push up/down
            'offsetTopBar': false // set to true, to avoid ios 7 status bar overlap
            }, 
            function() {
                am.requestAd( { 'isTesting':false }, // set to false, for production purpose 
                    function(){}, 
                    function(){ alert('failed to request ad'); }
                    );
            }, 
            function(){ alert('failed to create banner view'); }
        );
        am.createInterstitialView(
            {
                'publisherId': adId
            },
            function() {
                am.requestInterstitialAd( { 'isTesting':false }, // set to false, for production purpose
            function() {}, 
            function() { alert('failed to request ad'); }
            );
            },
            function() {
                alert("Interstitial failed");
            }
        );

        // more callback to handle Ad events
        document.addEventListener('onReceiveAd', function(){
            window.plugins.AdMob.showAd( true );
        });
        document.addEventListener('onFailedToReceiveAd', function(data){
            // alert( data.error );
        });
        document.addEventListener('onPresentAd', function(){
        });
        document.addEventListener('onDismissAd', function(){
        });
        document.addEventListener('onLeaveToAd', function(){
        });   

	    document.addEventListener('onReceiveInterstitialAd', function(){
	        window.plugins.AdMob.showInterstitialAd();
	    });
	    document.addEventListener('onPresentInterstitialAd', function(){
	    });

    } else {
        alert('AdMob plugin not available/ready.');
    }

}

function addOptionsMenu() {
	var onHelp = function() {
		console.log("help" + document.location.href);
		if (document.location.href.substr(-13, 13)=='index_ja.html') {
			document.location.href='help_ja.html';
		} else {
			document.location.href='help.html';
		}
	};
		 
	var optionsmenu = new OptionsMenu({
		id: "optionsmenu",
		items: [
		[ {
			label: LocaleLang.about,
			image: "img/ic_menu_help.png",
			action: onHelp
		} ]
		]
	});
}
