/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.prettytime;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.ocpsoft.prettytime.Duration;
import org.ocpsoft.prettytime.LocaleAware;
import org.ocpsoft.prettytime.TimeFormat;
import org.ocpsoft.prettytime.TimeUnit;
import org.ocpsoft.prettytime.impl.DurationImpl;
import org.ocpsoft.prettytime.impl.ResourcesTimeFormat;
import org.ocpsoft.prettytime.impl.ResourcesTimeUnit;
import org.ocpsoft.prettytime.units.Century;
import org.ocpsoft.prettytime.units.Day;
import org.ocpsoft.prettytime.units.Decade;
import org.ocpsoft.prettytime.units.Hour;
import org.ocpsoft.prettytime.units.JustNow;
import org.ocpsoft.prettytime.units.Millennium;
import org.ocpsoft.prettytime.units.Millisecond;
import org.ocpsoft.prettytime.units.Minute;
import org.ocpsoft.prettytime.units.Month;
import org.ocpsoft.prettytime.units.Second;
import org.ocpsoft.prettytime.units.TimeUnitComparator;
import org.ocpsoft.prettytime.units.Week;
import org.ocpsoft.prettytime.units.Year;

public class PrettyTime {
    private volatile Date reference;
    private volatile Locale locale = Locale.getDefault();
    private volatile Map<TimeUnit, TimeFormat> units = new LinkedHashMap<TimeUnit, TimeFormat>();

    public PrettyTime() {
        this.initTimeUnits();
    }

    public PrettyTime(Date reference) {
        this();
        this.setReference(reference);
    }

    public PrettyTime(Locale locale) {
        this.setLocale(locale);
        this.initTimeUnits();
    }

    public PrettyTime(Date reference, Locale locale) {
        this(locale);
        this.setReference(reference);
    }

    public Duration approximateDuration(Date then) {
        if (then == null) {
            throw new IllegalArgumentException("Date to approximate must not be null.");
        }
        Date ref = this.reference;
        if (null == ref) {
            ref = new Date();
        }
        long difference = then.getTime() - ref.getTime();
        return this.calculateDuration(difference);
    }

    private void initTimeUnits() {
        this.addUnit(new JustNow());
        this.addUnit(new Millisecond());
        this.addUnit(new Second());
        this.addUnit(new Minute());
        this.addUnit(new Hour());
        this.addUnit(new Day());
        this.addUnit(new Week());
        this.addUnit(new Month());
        this.addUnit(new Year());
        this.addUnit(new Decade());
        this.addUnit(new Century());
        this.addUnit(new Millennium());
    }

    private void addUnit(ResourcesTimeUnit unit) {
        this.registerUnit(unit, new ResourcesTimeFormat(unit));
    }

    private Duration calculateDuration(long difference) {
        long absoluteDifference = Math.abs(difference);
        ArrayList<TimeUnit> units = new ArrayList<TimeUnit>(this.getUnits().size());
        units.addAll(this.getUnits());
        DurationImpl result = new DurationImpl();
        for (int i = 0; i < units.size(); ++i) {
            boolean isLastUnit;
            TimeUnit unit = (TimeUnit)units.get(i);
            long millisPerUnit = Math.abs(unit.getMillisPerUnit());
            long quantity = Math.abs(unit.getMaxQuantity());
            boolean bl = isLastUnit = i == units.size() - 1;
            if (0L == quantity && !isLastUnit) {
                quantity = ((TimeUnit)units.get(i + 1)).getMillisPerUnit() / unit.getMillisPerUnit();
            }
            if (millisPerUnit * quantity <= absoluteDifference && !isLastUnit) continue;
            result.setUnit(unit);
            if (millisPerUnit > absoluteDifference) {
                result.setQuantity(this.getSign(difference));
                result.setDelta(0L);
                break;
            }
            result.setQuantity(difference / millisPerUnit);
            result.setDelta(difference - result.getQuantity() * millisPerUnit);
            break;
        }
        return result;
    }

    private long getSign(long difference) {
        if (0L > difference) {
            return -1L;
        }
        return 1L;
    }

    public List<Duration> calculatePreciseDuration(Date then) {
        if (then == null) {
            throw new IllegalArgumentException("Date to calculate must not be null.");
        }
        if (null == this.reference) {
            this.reference = new Date();
        }
        ArrayList<Duration> result = new ArrayList<Duration>();
        long difference = then.getTime() - this.reference.getTime();
        Duration duration = this.calculateDuration(difference);
        result.add(duration);
        while (0L != duration.getDelta()) {
            duration = this.calculateDuration(duration.getDelta());
            result.add(duration);
        }
        return result;
    }

    public String format(Date then) {
        if (then == null) {
            throw new IllegalArgumentException("Date to format must not be null.");
        }
        Duration d = this.approximateDuration(then);
        return this.format(d);
    }

    public String format(Calendar then) {
        if (then == null) {
            throw new IllegalArgumentException("Provided Calendar must not be null.");
        }
        return this.format(then.getTime());
    }

    public String formatUnrounded(Date then) {
        if (then == null) {
            throw new IllegalArgumentException("Date to format must not be null.");
        }
        Duration d = this.approximateDuration(then);
        return this.formatUnrounded(d);
    }

    public String format(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Duration to format must not be null.");
        }
        TimeFormat format = this.getFormat(duration.getUnit());
        String time = format.format(duration);
        return format.decorate(duration, time);
    }

    public String formatUnrounded(Duration duration) {
        if (duration == null) {
            throw new IllegalArgumentException("Duration to format must not be null.");
        }
        TimeFormat format = this.getFormat(duration.getUnit());
        String time = format.formatUnrounded(duration);
        return format.decorateUnrounded(duration, time);
    }

    public String format(List<Duration> durations) {
        if (durations == null) {
            throw new IllegalArgumentException("Duration list must not be null.");
        }
        String result = null;
        if (durations != null) {
            StringBuilder builder = new StringBuilder();
            Duration duration = null;
            TimeFormat format = null;
            for (int i = 0; i < durations.size(); ++i) {
                boolean isLast;
                duration = durations.get(i);
                format = this.getFormat(duration.getUnit());
                boolean bl = isLast = i == durations.size() - 1;
                if (!isLast) {
                    builder.append(format.formatUnrounded(duration));
                    builder.append(" ");
                    continue;
                }
                builder.append(format.format(duration));
            }
            result = format.decorateUnrounded(duration, builder.toString());
        }
        return result;
    }

    public String formatApproximateDuration(Date date) {
        Duration duration = this.approximateDuration(date);
        return this.formatDuration(duration);
    }

    public String formatDuration(Duration duration) {
        TimeFormat timeFormat = this.getFormat(duration.getUnit());
        return timeFormat.format(duration);
    }

    public TimeFormat getFormat(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        if (this.units.get(unit) != null) {
            return this.units.get(unit);
        }
        return null;
    }

    public Date getReference() {
        return this.reference;
    }

    public PrettyTime setReference(Date timestamp) {
        this.reference = timestamp;
        return this;
    }

    public List<TimeUnit> getUnits() {
        ArrayList<TimeUnit> result = new ArrayList<TimeUnit>(this.units.keySet());
        Collections.sort(result, new TimeUnitComparator());
        return Collections.unmodifiableList(result);
    }

    public <UNIT extends TimeUnit> UNIT getUnit(Class<UNIT> unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Unit type to get must not be null.");
        }
        for (TimeUnit unit : this.units.keySet()) {
            if (!unitType.isAssignableFrom(unit.getClass())) continue;
            return (UNIT)unit;
        }
        return null;
    }

    public PrettyTime registerUnit(TimeUnit unit, TimeFormat format) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit to register must not be null.");
        }
        if (format == null) {
            throw new IllegalArgumentException("Format to register must not be null.");
        }
        this.units.put(unit, format);
        if (unit instanceof LocaleAware) {
            ((LocaleAware)((Object)unit)).setLocale(this.locale);
        }
        if (format instanceof LocaleAware) {
            ((LocaleAware)((Object)format)).setLocale(this.locale);
        }
        return this;
    }

    public <UNIT extends TimeUnit> TimeFormat removeUnit(Class<UNIT> unitType) {
        if (unitType == null) {
            throw new IllegalArgumentException("Unit type to remove must not be null.");
        }
        for (TimeUnit unit : this.units.keySet()) {
            if (!unitType.isAssignableFrom(unit.getClass())) continue;
            return this.units.remove(unit);
        }
        return null;
    }

    public TimeFormat removeUnit(TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit to remove must not be null.");
        }
        return this.units.remove(unit);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PrettyTime setLocale(Locale locale) {
        this.locale = locale;
        for (TimeUnit unit : this.units.keySet()) {
            if (!(unit instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)unit)).setLocale(locale);
        }
        for (TimeFormat format : this.units.values()) {
            if (!(format instanceof LocaleAware)) continue;
            ((LocaleAware)((Object)format)).setLocale(locale);
        }
        return this;
    }

    public String toString() {
        return "PrettyTime [reference=" + this.reference + ", locale=" + this.locale + "]";
    }

    public List<TimeUnit> clearUnits() {
        List<TimeUnit> result = this.getUnits();
        this.units.clear();
        return result;
    }
}

