/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations;

import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.AnimateAdditionAdapter;
import com.nhaarman.listviewanimations.widget.DynamicListView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class ArrayAdapter<T>
extends BaseAdapter
implements List<T>,
DynamicListView.Swappable,
AnimateAdditionAdapter.Insertable<T> {
    protected List<T> mItems;
    private BaseAdapter mDataSetChangedSlavedAdapter;

    public ArrayAdapter() {
        this(null);
    }

    public ArrayAdapter(List<T> objects) {
        this(objects, false);
    }

    public ArrayAdapter(List<T> objects, boolean copyList) {
        this.mItems = objects != null ? (copyList ? new ArrayList<T>(objects) : objects) : new ArrayList<T>();
    }

    public int getCount() {
        return this.mItems.size();
    }

    public T getItem(int location) {
        return this.mItems.get(location);
    }

    public long getItemId(int location) {
        return location;
    }

    @Override
    public boolean add(T object) {
        boolean result = this.mItems.add(object);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public void add(int location, T object) {
        this.mItems.add(location, object);
        this.notifyDataSetChanged();
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        boolean result = this.mItems.addAll(collection);
        this.notifyDataSetChanged();
        return result;
    }

    public boolean addAll(T ... objects) {
        boolean result = Collections.addAll(this.mItems, objects);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean addAll(int location, Collection<? extends T> objects) {
        boolean result = this.mItems.addAll(location, objects);
        this.notifyDataSetChanged();
        return result;
    }

    public void addAll(int location, T ... objects) {
        for (int i = location; i < objects.length + location; ++i) {
            this.mItems.add(i, objects[i]);
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void clear() {
        this.mItems.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public boolean contains(Object object) {
        return this.mItems.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.mItems.containsAll(collection);
    }

    @Override
    public T get(int location) {
        return this.mItems.get(location);
    }

    @Override
    public T set(int location, T object) {
        T result = this.mItems.set(location, object);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public int size() {
        return this.mItems.size();
    }

    @Override
    public List<T> subList(int start, int end) {
        return this.mItems.subList(start, end);
    }

    @Override
    public Object[] toArray() {
        return this.mItems.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] array) {
        return this.mItems.toArray(array);
    }

    @Override
    public boolean remove(Object object) {
        boolean result = this.mItems.remove(object);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public T remove(int location) {
        T result = this.mItems.remove(location);
        this.notifyDataSetChanged();
        return result;
    }

    public Collection<T> removePositions(Collection<Integer> locations) {
        ArrayList<T> removedItems = new ArrayList<T>();
        ArrayList<Integer> locationsList = new ArrayList<Integer>(locations);
        Collections.sort(locationsList);
        Collections.reverse(locationsList);
        for (int location : locationsList) {
            removedItems.add(this.mItems.remove(location));
        }
        this.notifyDataSetChanged();
        return removedItems;
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean result = this.mItems.removeAll(objects);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        boolean result = this.mItems.retainAll(objects);
        this.notifyDataSetChanged();
        return result;
    }

    @Override
    public int indexOf(Object object) {
        return this.mItems.indexOf(object);
    }

    @Override
    public Iterator<T> iterator() {
        return this.mItems.iterator();
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.mItems.lastIndexOf(object);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.mItems.listIterator();
    }

    @Override
    public ListIterator<T> listIterator(int location) {
        return this.mItems.listIterator(location);
    }

    @Override
    public void swapItems(int locationOne, int locationTwo) {
        T temp = this.getItem(locationOne);
        this.set(locationOne, this.getItem(locationTwo));
        this.set(locationTwo, temp);
    }

    public void propagateNotifyDataSetChanged(BaseAdapter slavedAdapter) {
        this.mDataSetChangedSlavedAdapter = slavedAdapter;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        if (this.mDataSetChangedSlavedAdapter != null) {
            this.mDataSetChangedSlavedAdapter.notifyDataSetChanged();
        }
    }
}

