/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation;

import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.InsertQueue;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class AnimateAdditionAdapter<T>
extends BaseAdapterDecorator {
    private static final long DEFAULT_SCROLLDOWN_ANIMATION_MS = 300L;
    private static final long DEFAULT_INSERTION_ANIMATION_MS = 300L;
    private static final String ALPHA = "alpha";
    private final Insertable<T> mInsertable;
    private final InsertQueue<T> mInsertQueue;
    private boolean mShouldAnimateDown = true;
    private long mInsertionAnimationDurationMs = 300L;
    private long mScrolldownAnimationDurationMs = 300L;

    public AnimateAdditionAdapter(BaseAdapter baseAdapter) {
        super(baseAdapter);
        BaseAdapter rootAdapter = this.getRootAdapter();
        if (!(rootAdapter instanceof Insertable)) {
            throw new IllegalArgumentException("BaseAdapter should implement Insertable!");
        }
        this.mInsertable = (Insertable)rootAdapter;
        this.mInsertQueue = new InsertQueue<T>(this.mInsertable);
    }

    private BaseAdapter getRootAdapter() {
        BaseAdapter adapter = this.getDecoratedBaseAdapter();
        while (adapter instanceof BaseAdapterDecorator) {
            adapter = ((BaseAdapterDecorator)adapter).getDecoratedBaseAdapter();
        }
        return adapter;
    }

    @Override
    @Deprecated
    public void setAbsListView(AbsListView listView) {
        if (!(listView instanceof ListView)) {
            throw new IllegalArgumentException("AnimateAdditionAdapter requires a ListView instance!");
        }
        super.setAbsListView(listView);
    }

    public void setListView(ListView listView) {
        super.setAbsListView((AbsListView)listView);
    }

    public void setShouldAnimateDown(boolean shouldAnimateDown) {
        this.mShouldAnimateDown = shouldAnimateDown;
    }

    public void setScrolldownAnimationDuration(long scrolldownAnimationDurationMs) {
        this.mScrolldownAnimationDurationMs = scrolldownAnimationDurationMs;
    }

    public void setInsertionAnimationDuration(long insertionAnimationDurationMs) {
        this.mInsertionAnimationDurationMs = insertionAnimationDurationMs;
    }

    public void insert(int index, T item) {
        this.insert(new Pair((Object)index, item));
    }

    public void insert(Pair<Integer, T> ... indexItemPairs) {
        this.insert(Arrays.asList(indexItemPairs));
    }

    public void insert(List<Pair<Integer, T>> indexItemPairs) {
        ArrayList visibleViews = new ArrayList();
        ArrayList<Integer> insertedPositions = new ArrayList<Integer>();
        ArrayList<Integer> insertedBelowPositions = new ArrayList<Integer>();
        int scrollDistance = 0;
        int numInsertedAbove = 0;
        for (Pair<Integer, T> pair : indexItemPairs) {
            int insertedPosition;
            Iterator i$;
            int index;
            if (this.getAbsListView().getFirstVisiblePosition() > (Integer)pair.first) {
                index = (Integer)pair.first;
                i$ = insertedPositions.iterator();
                while (i$.hasNext()) {
                    insertedPosition = (Integer)i$.next();
                    if (index < insertedPosition) continue;
                    ++index;
                }
                this.mInsertable.add(index, pair.second);
                insertedPositions.add(index);
                ++numInsertedAbove;
                if (!this.mShouldAnimateDown) continue;
                View view = this.getView((Integer)pair.first, null, (ViewGroup)this.getAbsListView());
                view.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
                scrollDistance -= view.getMeasuredHeight();
                continue;
            }
            if (this.getAbsListView().getLastVisiblePosition() >= (Integer)pair.first) {
                index = (Integer)pair.first;
                i$ = insertedPositions.iterator();
                while (i$.hasNext()) {
                    insertedPosition = (Integer)i$.next();
                    if (index < insertedPosition) continue;
                    ++index;
                }
                Pair newPair = new Pair((Object)index, pair.second);
                visibleViews.add(newPair);
                continue;
            }
            index = (Integer)pair.first;
            i$ = insertedPositions.iterator();
            while (i$.hasNext()) {
                insertedPosition = (Integer)i$.next();
                if (index < insertedPosition) continue;
                ++index;
            }
            i$ = insertedBelowPositions.iterator();
            while (i$.hasNext()) {
                int queuedPosition = (Integer)i$.next();
                if (index < queuedPosition) continue;
                ++index;
            }
            insertedBelowPositions.add(index);
            this.mInsertable.add(index, pair.second);
        }
        if (this.mShouldAnimateDown) {
            this.getAbsListView().smoothScrollBy(scrollDistance, (int)(this.mScrolldownAnimationDurationMs * (long)numInsertedAbove));
        }
        this.mInsertQueue.insert(visibleViews);
        ((ListView)this.getAbsListView()).setSelectionFromTop(this.getAbsListView().getFirstVisiblePosition() + numInsertedAbove, this.getAbsListView().getChildAt(0).getTop());
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        final View view = super.getView(position, convertView, parent);
        if (this.mInsertQueue.getActiveIndexes().contains(position)) {
            int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-1, (int)Integer.MIN_VALUE);
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)-2, (int)Integer.MIN_VALUE);
            view.measure(widthMeasureSpec, heightMeasureSpec);
            int originalHeight = view.getMeasuredHeight();
            ValueAnimator heightAnimator = ValueAnimator.ofInt((int[])new int[]{1, originalHeight});
            heightAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    layoutParams.height = (Integer)animation.getAnimatedValue();
                    view.setLayoutParams(layoutParams);
                }
            });
            ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
            AnimatorSet animatorSet = new AnimatorSet();
            Animator[] customAnimators = this.getAdditionalAnimators(view, parent);
            Animator[] animators = new Animator[customAnimators.length + 2];
            animators[0] = heightAnimator;
            animators[1] = alphaAnimator;
            System.arraycopy(customAnimators, 0, animators, 2, customAnimators.length);
            animatorSet.playTogether(animators);
            animatorSet.setDuration(this.mInsertionAnimationDurationMs);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    AnimateAdditionAdapter.this.mInsertQueue.removeActiveIndex(position);
                }
            });
            animatorSet.start();
        }
        return view;
    }

    protected Animator[] getAdditionalAnimators(View view, ViewGroup parent) {
        return new Animator[0];
    }

    public static interface Insertable<T> {
        public void add(int var1, T var2);
    }
}

