/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.OnDismissCallback;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class AnimateDismissAdapter
extends BaseAdapterDecorator {
    private final OnDismissCallback mCallback;

    public AnimateDismissAdapter(BaseAdapter baseAdapter, OnDismissCallback callback) {
        super(baseAdapter);
        this.mCallback = callback;
    }

    public void animateDismiss(int position) {
        this.animateDismiss(Arrays.asList(position));
    }

    public void animateDismiss(Collection<Integer> positions) {
        final ArrayList<Integer> positionsCopy = new ArrayList<Integer>(positions);
        if (this.getAbsListView() == null) {
            throw new IllegalStateException("Call setAbsListView() on this AnimateDismissAdapter before calling setAdapter()!");
        }
        List<View> views = this.getVisibleViewsForPositions(positionsCopy);
        if (!views.isEmpty()) {
            ArrayList<Animator> animators = new ArrayList<Animator>();
            for (View view : views) {
                animators.add(this.createAnimatorForView(view));
            }
            AnimatorSet animatorSet = new AnimatorSet();
            Animator[] animatorsArray = new Animator[animators.size()];
            for (int i = 0; i < animatorsArray.length; ++i) {
                animatorsArray[i] = (Animator)animators.get(i);
            }
            animatorSet.playTogether(animatorsArray);
            animatorSet.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    AnimateDismissAdapter.this.invokeCallback(positionsCopy);
                }
            });
            animatorSet.start();
        } else {
            this.invokeCallback(positionsCopy);
        }
    }

    private void invokeCallback(Collection<Integer> positions) {
        ArrayList<Integer> positionsList = new ArrayList<Integer>(positions);
        Collections.sort(positionsList);
        int[] dismissPositions = new int[positionsList.size()];
        for (int i = 0; i < positionsList.size(); ++i) {
            dismissPositions[i] = positionsList.get(positionsList.size() - 1 - i);
        }
        this.mCallback.onDismiss(this.getAbsListView(), dismissPositions);
    }

    private List<View> getVisibleViewsForPositions(Collection<Integer> positions) {
        ArrayList<View> views = new ArrayList<View>();
        for (int i = 0; i < this.getAbsListView().getChildCount(); ++i) {
            View child = this.getAbsListView().getChildAt(i);
            if (!positions.contains(AdapterViewUtil.getPositionForView(this.getAbsListView(), child))) continue;
            views.add(child);
        }
        return views;
    }

    private Animator createAnimatorForView(final View view) {
        final ViewGroup.LayoutParams lp = view.getLayoutParams();
        int originalHeight = view.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 0});
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                lp.height = 0;
                view.setLayoutParams(lp);
            }
        });
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                view.setLayoutParams(lp);
            }
        });
        return animator;
    }
}

