/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.nhaarman.listviewanimations.ArrayAdapter;
import com.nhaarman.listviewanimations.ListViewSetter;
import com.nhaarman.listviewanimations.itemmanipulation.ExpandCollapseListener;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class ExpandableListItemAdapter<T>
extends ArrayAdapter<T>
implements ListViewSetter {
    private static final int DEFAULTTITLEPARENTRESID = 10000;
    private static final int DEFAULTCONTENTPARENTRESID = 10001;
    private final Context mContext;
    private int mViewLayoutResId;
    private final int mTitleParentResId;
    private final int mContentParentResId;
    private int mActionViewResId;
    private final List<Long> mExpandedIds;
    private int mLimit;
    private AbsListView mAbsListView;
    private ExpandCollapseListener mExpandCollapseListener;

    public ExpandableListItemAdapter(Context context) {
        this(context, null);
    }

    public ExpandableListItemAdapter(Context context, List<T> items) {
        super(items);
        this.mContext = context;
        this.mTitleParentResId = 10000;
        this.mContentParentResId = 10001;
        this.mExpandedIds = new ArrayList<Long>();
    }

    public ExpandableListItemAdapter(Context context, int layoutResId, int titleParentResId, int contentParentResId) {
        this(context, layoutResId, titleParentResId, contentParentResId, null);
    }

    public ExpandableListItemAdapter(Context context, int layoutResId, int titleParentResId, int contentParentResId, List<T> items) {
        super(items);
        this.mContext = context;
        this.mViewLayoutResId = layoutResId;
        this.mTitleParentResId = titleParentResId;
        this.mContentParentResId = contentParentResId;
        this.mExpandedIds = new ArrayList<Long>();
    }

    @Override
    public void setAbsListView(AbsListView listView) {
        this.mAbsListView = listView;
    }

    public void setActionViewResId(int resId) {
        this.mActionViewResId = resId;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
        this.mExpandedIds.clear();
        this.notifyDataSetChanged();
    }

    public void setExpandCollapseListener(ExpandCollapseListener expandCollapseListener) {
        this.mExpandCollapseListener = expandCollapseListener;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        ViewGroup view = (ViewGroup)convertView;
        if (view == null) {
            view = this.createView(parent);
            viewHolder = new ViewHolder();
            viewHolder.titleParent = (ViewGroup)view.findViewById(this.mTitleParentResId);
            viewHolder.contentParent = (ViewGroup)view.findViewById(this.mContentParentResId);
            view.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)view.getTag();
        }
        View titleView = this.getTitleView(position, viewHolder.titleView, viewHolder.titleParent);
        if (titleView != viewHolder.titleView) {
            viewHolder.titleParent.removeAllViews();
            viewHolder.titleParent.addView(titleView);
            if (this.mActionViewResId == 0) {
                view.setOnClickListener((View.OnClickListener)new TitleViewOnClickListener((View)viewHolder.contentParent));
            } else {
                view.findViewById(this.mActionViewResId).setOnClickListener((View.OnClickListener)new TitleViewOnClickListener((View)viewHolder.contentParent));
            }
        }
        viewHolder.titleView = titleView;
        View contentView = this.getContentView(position, viewHolder.contentView, viewHolder.contentParent);
        if (contentView != viewHolder.contentView) {
            viewHolder.contentParent.removeAllViews();
            viewHolder.contentParent.addView(contentView);
        }
        viewHolder.contentView = contentView;
        viewHolder.contentParent.setVisibility(this.mExpandedIds.contains(this.getItemId(position)) ? 0 : 8);
        viewHolder.contentParent.setTag((Object)this.getItemId(position));
        ViewGroup.LayoutParams layoutParams = viewHolder.contentParent.getLayoutParams();
        layoutParams.height = -2;
        viewHolder.contentParent.setLayoutParams(layoutParams);
        return view;
    }

    private ViewGroup createView(ViewGroup parent) {
        RootView view = this.mViewLayoutResId == 0 ? new RootView(this.mContext) : (ViewGroup)LayoutInflater.from((Context)this.mContext).inflate(this.mViewLayoutResId, parent, false);
        return view;
    }

    public abstract View getTitleView(int var1, View var2, ViewGroup var3);

    public abstract View getContentView(int var1, View var2, ViewGroup var3);

    public boolean isExpanded(int position) {
        long itemId = this.getItemId(position);
        return this.mExpandedIds.contains(itemId);
    }

    public View getTitleView(int position) {
        View titleView = null;
        View parentView = this.findViewForPosition(position);
        Object tag = parentView.getTag();
        if (tag instanceof ViewHolder) {
            titleView = ((ViewHolder)tag).titleView;
        }
        return titleView;
    }

    public View getContentView(int position) {
        Object tag;
        View contentView = null;
        View parentView = this.findViewForPosition(position);
        if (parentView != null && (tag = parentView.getTag()) instanceof ViewHolder) {
            contentView = ((ViewHolder)tag).contentView;
        }
        return contentView;
    }

    @Override
    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        HashSet<Long> removedIds = new HashSet<Long>(this.mExpandedIds);
        for (int i = 0; i < this.getCount(); ++i) {
            long id = this.getItemId(i);
            removedIds.remove(id);
        }
        this.mExpandedIds.removeAll(removedIds);
    }

    private View getContentParent(int position) {
        Object tag;
        ViewGroup contentParent = null;
        View parentView = this.findViewForPosition(position);
        if (parentView != null && (tag = parentView.getTag()) instanceof ViewHolder) {
            contentParent = ((ViewHolder)tag).contentParent;
        }
        return contentParent;
    }

    public void expand(int position) {
        long itemId = this.getItemId(position);
        if (this.mExpandedIds.contains(itemId)) {
            return;
        }
        this.toggle(position);
    }

    public void collapse(int position) {
        long itemId = this.getItemId(position);
        if (!this.mExpandedIds.contains(itemId)) {
            return;
        }
        this.toggle(position);
    }

    private View findViewForPosition(int position) {
        View result = null;
        for (int i = 0; i < this.mAbsListView.getChildCount() && result == null; ++i) {
            View childView = this.mAbsListView.getChildAt(i);
            if (AdapterViewUtil.getPositionForView(this.mAbsListView, childView) != position) continue;
            result = childView;
        }
        return result;
    }

    private int findPositionForId(long id) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.getItemId(i) != id) continue;
            return i;
        }
        return -1;
    }

    public void toggle(int position) {
        long itemId = this.getItemId(position);
        boolean isExpanded = this.mExpandedIds.contains(itemId);
        View contentParent = this.getContentParent(position);
        if (contentParent != null) {
            this.toggle(contentParent);
        }
        if (contentParent == null && isExpanded) {
            this.mExpandedIds.remove(itemId);
        } else if (contentParent == null && !isExpanded) {
            this.mExpandedIds.add(itemId);
        }
    }

    private void toggle(View contentParent) {
        boolean shouldCollapseOther;
        boolean isVisible = contentParent.getVisibility() == 0;
        boolean bl = shouldCollapseOther = !isVisible && this.mLimit > 0 && this.mExpandedIds.size() >= this.mLimit;
        if (shouldCollapseOther) {
            Long firstId = this.mExpandedIds.get(0);
            int firstPosition = this.findPositionForId(firstId);
            View firstEV = this.getContentParent(firstPosition);
            if (firstEV != null) {
                ExpandCollapseHelper.animateCollapsing(firstEV);
            }
            this.mExpandedIds.remove(firstId);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemCollapsed(firstPosition);
            }
        }
        Long id = (Long)contentParent.getTag();
        int position = this.findPositionForId(id);
        if (isVisible) {
            ExpandCollapseHelper.animateCollapsing(contentParent);
            this.mExpandedIds.remove(id);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemCollapsed(position);
            }
        } else {
            ExpandCollapseHelper.animateExpanding(contentParent, this.mAbsListView);
            this.mExpandedIds.add(id);
            if (this.mExpandCollapseListener != null) {
                this.mExpandCollapseListener.onItemExpanded(position);
            }
        }
    }

    private static class ExpandCollapseHelper {
        private ExpandCollapseHelper() {
        }

        public static void animateCollapsing(final View view) {
            int origHeight = view.getHeight();
            ValueAnimator animator = ExpandCollapseHelper.createHeightAnimator(view, origHeight, 0);
            animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    view.setVisibility(8);
                }
            });
            animator.start();
        }

        public static void animateExpanding(final View view, final AbsListView listView) {
            view.setVisibility(0);
            View parent = (View)view.getParent();
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(parent.getMeasuredWidth() - parent.getPaddingLeft() - parent.getPaddingRight()), (int)Integer.MIN_VALUE);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            view.measure(widthSpec, heightSpec);
            ValueAnimator animator = ExpandCollapseHelper.createHeightAnimator(view, 0, view.getMeasuredHeight());
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){
                final int listViewHeight;
                final int listViewBottomPadding;
                final View v;
                {
                    this.listViewHeight = listView.getHeight();
                    this.listViewBottomPadding = listView.getPaddingBottom();
                    this.v = ExpandCollapseHelper.findDirectChild(view, listView);
                }

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    int top;
                    int bottom = this.v.getBottom();
                    if (bottom > this.listViewHeight && (top = this.v.getTop()) > 0) {
                        listView.smoothScrollBy(Math.min(bottom - this.listViewHeight + this.listViewBottomPadding, top), 0);
                    }
                }
            });
            animator.start();
        }

        private static View findDirectChild(View view, AbsListView listView) {
            View result = view;
            View parent = (View)result.getParent();
            while (parent != listView) {
                result = parent;
                parent = (View)result.getParent();
            }
            return result;
        }

        public static ValueAnimator createHeightAnimator(final View view, int start, int end) {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{start, end});
            animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    int value = (Integer)valueAnimator.getAnimatedValue();
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    layoutParams.height = value;
                    view.setLayoutParams(layoutParams);
                }
            });
            return animator;
        }
    }

    private static class ViewHolder {
        ViewGroup titleParent;
        ViewGroup contentParent;
        View titleView;
        View contentView;

        private ViewHolder() {
        }
    }

    private static class RootView
    extends LinearLayout {
        private ViewGroup mTitleViewGroup;
        private ViewGroup mContentViewGroup;

        public RootView(Context context) {
            super(context);
            this.init();
        }

        private void init() {
            this.setOrientation(1);
            this.mTitleViewGroup = new FrameLayout(this.getContext());
            this.mTitleViewGroup.setId(10000);
            this.addView((View)this.mTitleViewGroup);
            this.mContentViewGroup = new FrameLayout(this.getContext());
            this.mContentViewGroup.setId(10001);
            this.addView((View)this.mContentViewGroup);
        }
    }

    private class TitleViewOnClickListener
    implements View.OnClickListener {
        private final View mContentParent;

        private TitleViewOnClickListener(View contentParent) {
            this.mContentParent = contentParent;
        }

        public void onClick(View view) {
            ExpandableListItemAdapter.this.toggle(this.mContentParent);
        }
    }
}

