/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation;

import android.util.Pair;
import com.nhaarman.listviewanimations.itemmanipulation.AnimateAdditionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class InsertQueue<T> {
    private final AnimateAdditionAdapter.Insertable<T> mInsertable;
    private final Set<AtomicInteger> mActiveIndexes = new HashSet<AtomicInteger>();
    private final List<Pair<Integer, T>> mPendingItemsToInsert = new ArrayList<Pair<Integer, T>>();

    public InsertQueue(AnimateAdditionAdapter.Insertable<T> insertable) {
        this.mInsertable = insertable;
    }

    public void insert(int index, T item) {
        if (this.mActiveIndexes.isEmpty() && this.mPendingItemsToInsert.isEmpty()) {
            this.mActiveIndexes.add(new AtomicInteger(index));
            this.mInsertable.add(index, item);
        } else {
            this.mPendingItemsToInsert.add(new Pair((Object)index, item));
        }
    }

    public void insert(Pair<Integer, T> ... indexItemPair) {
        this.insert(Arrays.asList(indexItemPair));
    }

    public void insert(List<Pair<Integer, T>> indexItemPairs) {
        if (this.mActiveIndexes.isEmpty() && this.mPendingItemsToInsert.isEmpty()) {
            for (Pair<Integer, T> pair : indexItemPairs) {
                for (AtomicInteger existing : this.mActiveIndexes) {
                    if (existing.intValue() < (Integer)pair.first) continue;
                    existing.incrementAndGet();
                }
                this.mActiveIndexes.add(new AtomicInteger((Integer)pair.first));
                this.mInsertable.add((Integer)pair.first, pair.second);
            }
        } else {
            this.mPendingItemsToInsert.addAll(indexItemPairs);
        }
    }

    public void clearActive() {
        this.mActiveIndexes.clear();
        this.insertPending();
    }

    public void removeActiveIndex(int index) {
        boolean found = false;
        Iterator<AtomicInteger> iterator = this.mActiveIndexes.iterator();
        while (iterator.hasNext() && !found) {
            if (iterator.next().get() != index) continue;
            iterator.remove();
            found = true;
        }
        if (this.mActiveIndexes.isEmpty()) {
            this.insertPending();
        }
    }

    private void insertPending() {
        for (Pair<Integer, T> pi : this.mPendingItemsToInsert) {
            for (AtomicInteger existing : this.mActiveIndexes) {
                if (existing.intValue() < (Integer)pi.first) continue;
                existing.incrementAndGet();
            }
            this.mActiveIndexes.add(new AtomicInteger((Integer)pi.first));
            this.mInsertable.add((Integer)pi.first, pi.second);
        }
        this.mPendingItemsToInsert.clear();
    }

    public Collection<Integer> getActiveIndexes() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (AtomicInteger i : this.mActiveIndexes) {
            result.add(i.get());
        }
        return result;
    }

    public List<Pair<Integer, T>> getPendingItemsToInsert() {
        return this.mPendingItemsToInsert;
    }
}

