/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.OnDismissCallback;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeOnScrollListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeOnTouchListener;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@SuppressLint(value={"Recycle"})
public class SwipeDismissListViewTouchListener
implements SwipeOnTouchListener {
    private static final int MIN_FLING_VELOCITY_FACTOR = 16;
    private final int mSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    protected long mAnimationTime;
    private final AbsListView mListView;
    private final OnDismissCallback mCallback;
    private int mViewWidth = 1;
    protected List<PendingDismissData> mPendingDismisses = new ArrayList<PendingDismissData>();
    private int mDismissAnimationRefCount = 0;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private VelocityTracker mVelocityTracker;
    private PendingDismissData mCurrentDismissData;
    private int mVirtualListCount = -1;
    private boolean mDisallowSwipe;
    private boolean mIsParentHorizontalScrollContainer;
    private int mResIdOfTouchChild;
    private boolean mTouchChildTouched;
    private DismissableManager mDismissableManager;

    public SwipeDismissListViewTouchListener(AbsListView listView, OnDismissCallback callback, SwipeOnScrollListener onScroll) {
        ViewConfiguration vc = ViewConfiguration.get((Context)listView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity() * 16;
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listView.getContext().getResources().getInteger(0x10E0000);
        this.mListView = listView;
        this.mCallback = callback;
        onScroll.setTouchListener(this);
        this.mListView.setOnScrollListener((AbsListView.OnScrollListener)onScroll);
    }

    public void disallowSwipe() {
        this.mDisallowSwipe = true;
    }

    public void allowSwipe() {
        this.mDisallowSwipe = false;
    }

    public void setDismissableManager(DismissableManager dismissableManager) {
        this.mDismissableManager = dismissableManager;
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        if (this.mVirtualListCount == -1) {
            this.mVirtualListCount = ((ListAdapter)this.mListView.getAdapter()).getCount();
        }
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                this.mDisallowSwipe = false;
                view.onTouchEvent(motionEvent);
                return this.handleDownEvent(motionEvent);
            }
            case 2: {
                return this.handleMoveEvent(motionEvent);
            }
            case 3: {
                return this.handleCancelEvent(motionEvent);
            }
            case 1: {
                this.mDisallowSwipe = false;
                this.mTouchChildTouched = false;
                return this.handleUpEvent(motionEvent);
            }
        }
        return false;
    }

    @Override
    public boolean isSwiping() {
        return this.mSwiping;
    }

    protected PendingDismissData createPendingDismissData(int position, View view) {
        return new PendingDismissData(position, view);
    }

    private boolean handleDownEvent(MotionEvent motionEvent) {
        Rect rect = new Rect();
        int childCount = this.mListView.getChildCount();
        int[] listViewCoords = new int[2];
        this.mListView.getLocationOnScreen(listViewCoords);
        int x = (int)motionEvent.getRawX() - listViewCoords[0];
        int y = (int)motionEvent.getRawY() - listViewCoords[1];
        View downView = null;
        for (int i = 0; i < childCount && downView == null; ++i) {
            View child = this.mListView.getChildAt(i);
            child.getHitRect(rect);
            if (!rect.contains(x, y)) continue;
            downView = child;
        }
        if (downView != null) {
            long downId;
            this.mDownX = motionEvent.getRawX();
            this.mDownY = motionEvent.getRawY();
            int downPosition = AdapterViewUtil.getPositionForView(this.mListView, downView);
            if (this.mDismissableManager != null && !this.mDismissableManager.isDismissable(downId = ((ListAdapter)this.mListView.getAdapter()).getItemId(downPosition), downPosition)) {
                return false;
            }
            this.mCurrentDismissData = this.createPendingDismissData(downPosition, downView);
            if (this.mPendingDismisses.contains(this.mCurrentDismissData) || downPosition >= this.mVirtualListCount) {
                this.mCurrentDismissData = null;
                return false;
            }
            boolean bl = this.mTouchChildTouched = !this.mIsParentHorizontalScrollContainer && this.mResIdOfTouchChild == 0;
            if (this.mResIdOfTouchChild != 0) {
                Rect childRect;
                this.mIsParentHorizontalScrollContainer = false;
                View childView = downView.findViewById(this.mResIdOfTouchChild);
                if (childView != null && (childRect = this.getChildViewRect((View)this.mListView, childView)).contains((int)motionEvent.getX(), (int)motionEvent.getY())) {
                    this.mTouchChildTouched = true;
                    this.mListView.requestDisallowInterceptTouchEvent(true);
                }
            }
            if (this.mIsParentHorizontalScrollContainer) {
                this.mTouchChildTouched = true;
                this.mListView.requestDisallowInterceptTouchEvent(true);
            }
            this.mVelocityTracker = VelocityTracker.obtain();
            this.mVelocityTracker.addMovement(motionEvent);
        }
        return true;
    }

    private Rect getChildViewRect(View parentView, View childView) {
        ViewGroup parent;
        Rect childRect = new Rect(childView.getLeft(), childView.getTop(), childView.getRight(), childView.getBottom());
        if (parentView == childView) {
            return childRect;
        }
        while ((parent = (ViewGroup)childView.getParent()) != parentView) {
            childRect.offset(parent.getLeft(), parent.getTop());
            childView = parent;
        }
        return childRect;
    }

    private boolean handleMoveEvent(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            return false;
        }
        this.mVelocityTracker.addMovement(motionEvent);
        float deltaX = motionEvent.getRawX() - this.mDownX;
        float deltaY = motionEvent.getRawY() - this.mDownY;
        if (this.mTouchChildTouched && !this.mDisallowSwipe && Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaX) > Math.abs(deltaY)) {
            this.mSwiping = true;
            this.mListView.requestDisallowInterceptTouchEvent(true);
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
            this.mListView.onTouchEvent(cancelEvent);
        }
        if (this.mSwiping) {
            ViewHelper.setTranslationX((View)this.mCurrentDismissData.view, (float)deltaX);
            ViewHelper.setAlpha((View)this.mCurrentDismissData.view, (float)Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
            return true;
        }
        return false;
    }

    private boolean handleCancelEvent(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            return false;
        }
        if (this.mCurrentDismissData != null && this.mSwiping) {
            ViewPropertyAnimator.animate((View)this.mCurrentDismissData.view).translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
        }
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mCurrentDismissData = null;
        this.mSwiping = false;
        return false;
    }

    private boolean handleUpEvent(MotionEvent motionEvent) {
        if (this.mVelocityTracker == null) {
            return false;
        }
        float deltaX = motionEvent.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(motionEvent);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float velocityX = Math.abs(this.mVelocityTracker.getXVelocity());
        float velocityY = Math.abs(this.mVelocityTracker.getYVelocity());
        boolean dismiss = false;
        boolean dismissRight = false;
        if (Math.abs(deltaX) > (float)(this.mViewWidth / 2)) {
            dismiss = true;
            dismissRight = deltaX > 0.0f;
        } else if ((float)this.mMinFlingVelocity <= velocityX && velocityX <= (float)this.mMaxFlingVelocity && velocityY < velocityX) {
            dismiss = true;
            boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
        }
        if (this.mSwiping) {
            if (dismiss) {
                final PendingDismissData pendingDismissData = this.mCurrentDismissData;
                ++this.mDismissAnimationRefCount;
                ViewPropertyAnimator.animate((View)this.mCurrentDismissData.view).translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        SwipeDismissListViewTouchListener.this.onDismiss(pendingDismissData);
                    }
                });
                --this.mVirtualListCount;
                this.mPendingDismisses.add(this.mCurrentDismissData);
            } else {
                ViewPropertyAnimator.animate((View)this.mCurrentDismissData.view).translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
            }
        }
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mDownY = 0.0f;
        this.mCurrentDismissData = null;
        this.mSwiping = false;
        return false;
    }

    protected void onDismiss(PendingDismissData data) {
        this.performDismiss(data);
    }

    protected void performDismiss(final PendingDismissData data) {
        final ViewGroup.LayoutParams lp = data.view.getLayoutParams();
        int originalHeight = data.view.getHeight();
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{originalHeight, 1}).setDuration(this.mAnimationTime);
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                lp.height = (Integer)valueAnimator.getAnimatedValue();
                data.view.setLayoutParams(lp);
            }
        });
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                SwipeDismissListViewTouchListener.this.finalizeDismiss();
            }
        });
        animator.start();
    }

    protected void recycleDismissedViewsItems(List<PendingDismissData> pendingDismisses) {
        for (PendingDismissData pendingDismiss : pendingDismisses) {
            ViewHelper.setAlpha((View)pendingDismiss.view, (float)1.0f);
            ViewHelper.setTranslationX((View)pendingDismiss.view, (float)0.0f);
            ViewGroup.LayoutParams lp = pendingDismiss.view.getLayoutParams();
            lp.height = 0;
            pendingDismiss.view.setLayoutParams(lp);
        }
    }

    protected void finalizeDismiss() {
        --this.mDismissAnimationRefCount;
        if (this.mDismissAnimationRefCount == 0) {
            Collections.sort(this.mPendingDismisses);
            int[] dismissPositions = new int[this.mPendingDismisses.size()];
            for (int i = this.mPendingDismisses.size() - 1; i >= 0; --i) {
                dismissPositions[i] = this.mPendingDismisses.get((int)i).position;
            }
            this.mCallback.onDismiss(this.mListView, dismissPositions);
            this.recycleDismissedViewsItems(this.mPendingDismisses);
            this.mPendingDismisses.clear();
        }
    }

    void setIsParentHorizontalScrollContainer(boolean isParentHorizontalScrollContainer) {
        this.mIsParentHorizontalScrollContainer = this.mResIdOfTouchChild == 0 && isParentHorizontalScrollContainer;
    }

    void setTouchChild(int childResId) {
        this.mResIdOfTouchChild = childResId;
        if (childResId != 0) {
            this.setIsParentHorizontalScrollContainer(false);
        }
    }

    public void notifyDataSetChanged() {
        this.mVirtualListCount = ((ListAdapter)this.mListView.getAdapter()).getCount();
    }

    protected class PendingDismissData
    implements Comparable<PendingDismissData> {
        public final int position;
        public final View view;

        public PendingDismissData(int position, View view) {
            this.position = position;
            this.view = view;
        }

        @Override
        public int compareTo(PendingDismissData other) {
            return other.position - this.position;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.position;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PendingDismissData other = (PendingDismissData)obj;
            return this.position == other.position;
        }
    }
}

