/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo;

import android.os.Bundle;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo.ContextualUndoListViewTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo.ContextualUndoView;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;

public class ContextualUndoAdapter
extends BaseAdapterDecorator
implements ContextualUndoListViewTouchListener.Callback {
    private static final int ANIMATION_DURATION = 150;
    private static final String EXTRA_ACTIVE_REMOVED_ID = "removedId";
    private static final String X = "x";
    private final int mUndoLayoutId;
    private final int mUndoActionId;
    private final int mCountDownTextViewResId;
    private final int mAutoDeleteDelayMillis;
    private long mDismissStartMillis;
    private ContextualUndoView mCurrentRemovedView;
    private long mCurrentRemovedId;
    private final Handler mHandler = new Handler();
    private final CountDownRunnable mCountDownRunnable = new CountDownRunnable();
    private final DeleteItemCallback mDeleteItemCallback;
    private final CountDownFormatter mCountDownFormatter;
    private ContextualUndoListViewTouchListener mContextualUndoListViewTouchListener;

    public ContextualUndoAdapter(BaseAdapter baseAdapter, int undoLayoutId, int undoActionId, DeleteItemCallback deleteItemCallback) {
        this(baseAdapter, undoLayoutId, undoActionId, -1, -1, deleteItemCallback, null);
    }

    public ContextualUndoAdapter(BaseAdapter baseAdapter, int undoLayoutResId, int undoActionResId, int autoDeleteTimeMillis, DeleteItemCallback deleteItemCallback) {
        this(baseAdapter, undoLayoutResId, undoActionResId, autoDeleteTimeMillis, -1, deleteItemCallback, null);
    }

    public ContextualUndoAdapter(BaseAdapter baseAdapter, int undoLayoutResId, int undoActionResId, int autoDeleteTime, int countDownTextViewResId, DeleteItemCallback deleteItemCallback, CountDownFormatter countDownFormatter) {
        super(baseAdapter);
        this.mUndoLayoutId = undoLayoutResId;
        this.mUndoActionId = undoActionResId;
        this.mCurrentRemovedId = -1L;
        this.mAutoDeleteDelayMillis = autoDeleteTime;
        this.mCountDownTextViewResId = countDownTextViewResId;
        this.mDeleteItemCallback = deleteItemCallback;
        this.mCountDownFormatter = countDownFormatter;
    }

    @Override
    public final View getView(int position, View convertView, ViewGroup parent) {
        long itemId;
        ViewHolder vh;
        ContextualUndoView contextualUndoView = (ContextualUndoView)convertView;
        if (contextualUndoView == null) {
            contextualUndoView = new ContextualUndoView(parent.getContext(), this.mUndoLayoutId, this.mCountDownTextViewResId);
            contextualUndoView.findViewById(this.mUndoActionId).setOnClickListener((View.OnClickListener)new UndoListener(contextualUndoView));
            vh = new ViewHolder(contextualUndoView);
        } else {
            vh = ViewHolder.getViewHolder((View)contextualUndoView);
        }
        View contentView = super.getView(position, contextualUndoView.getContentView(), (ViewGroup)contextualUndoView);
        contextualUndoView.updateContentView(contentView);
        vh.mItemId = itemId = this.getItemId(position);
        if (itemId == this.mCurrentRemovedId) {
            contextualUndoView.displayUndo();
            long millisLeft = (long)this.mAutoDeleteDelayMillis - (System.currentTimeMillis() - this.mDismissStartMillis);
            if (this.mCountDownFormatter != null) {
                contextualUndoView.updateCountDownTimer(this.mCountDownFormatter.getCountDownString(millisLeft));
            }
        } else {
            contextualUndoView.displayContentView();
        }
        contextualUndoView.setItemId(itemId);
        return contextualUndoView;
    }

    @Override
    public void setAbsListView(AbsListView listView) {
        super.setAbsListView(listView);
        this.mContextualUndoListViewTouchListener = new ContextualUndoListViewTouchListener(listView, this);
        this.mContextualUndoListViewTouchListener.setIsParentHorizontalScrollContainer(this.isParentHorizontalScrollContainer());
        this.mContextualUndoListViewTouchListener.setTouchChild(this.getTouchChild());
        listView.setOnTouchListener((View.OnTouchListener)this.mContextualUndoListViewTouchListener);
        listView.setOnScrollListener(this.mContextualUndoListViewTouchListener.makeScrollListener());
        listView.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new HierarchyChangeListener());
    }

    @Override
    public void onViewSwiped(long dismissViewItemId, int dismissPosition) {
        ContextualUndoView contextualUndoView = this.getContextualUndoView(dismissViewItemId);
        if (contextualUndoView == null) {
            this.removePreviousContextualUndoIfPresent();
            this.mCurrentRemovedView = null;
            this.mCurrentRemovedId = dismissViewItemId;
        } else if (contextualUndoView.isContentDisplayed()) {
            this.restoreViewPosition((View)contextualUndoView);
            contextualUndoView.displayUndo();
            this.removePreviousContextualUndoIfPresent();
            this.setCurrentRemovedView(contextualUndoView);
            if (this.mAutoDeleteDelayMillis > 0) {
                this.startAutoDeleteTimer();
            }
        } else {
            this.performRemovalIfNecessary();
        }
    }

    private ContextualUndoView getContextualUndoView(long dismissViewItemId) {
        ContextualUndoView contextualUndoView = null;
        AbsListView listView = this.getAbsListView();
        int childCount = listView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ContextualUndoView listItem;
            View child = listView.getChildAt(i);
            if (!(child instanceof ContextualUndoView) || (listItem = (ContextualUndoView)child).getItemId() != dismissViewItemId) continue;
            contextualUndoView = listItem;
        }
        return contextualUndoView;
    }

    private void startAutoDeleteTimer() {
        this.mHandler.removeCallbacks((Runnable)this.mCountDownRunnable);
        if (this.mCountDownFormatter != null) {
            this.mCurrentRemovedView.updateCountDownTimer(this.mCountDownFormatter.getCountDownString(this.mAutoDeleteDelayMillis));
        }
        this.mDismissStartMillis = System.currentTimeMillis();
        this.mHandler.postDelayed((Runnable)this.mCountDownRunnable, (long)Math.min(1000, this.mAutoDeleteDelayMillis));
    }

    private void restoreViewPosition(View view) {
        ViewHelper.setAlpha((View)view, (float)1.0f);
        ViewHelper.setTranslationX((View)view, (float)0.0f);
    }

    private void removePreviousContextualUndoIfPresent() {
        if (this.mCurrentRemovedView != null) {
            this.performRemovalIfNecessary();
        }
    }

    private void setCurrentRemovedView(ContextualUndoView currentRemovedView) {
        this.mCurrentRemovedView = currentRemovedView;
        this.mCurrentRemovedId = currentRemovedView.getItemId();
    }

    private void clearCurrentRemovedView() {
        this.mCurrentRemovedView = null;
        this.mCurrentRemovedId = -1L;
        this.mHandler.removeCallbacks((Runnable)this.mCountDownRunnable);
    }

    @Override
    public void onListScrolled() {
        this.performRemovalIfNecessary();
    }

    private void performRemovalIfNecessary() {
        if (this.mCurrentRemovedId == -1L) {
            return;
        }
        ContextualUndoView currentRemovedView = this.getCurrentRemovedView(this.mCurrentRemovedView, this.mCurrentRemovedId);
        if (currentRemovedView != null) {
            ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{currentRemovedView.getHeight(), 1}).setDuration(150L);
            RemoveViewAnimatorListenerAdapter listener = new RemoveViewAnimatorListenerAdapter(currentRemovedView, this.mCurrentRemovedId);
            RemoveViewAnimatorUpdateListener updateListener = new RemoveViewAnimatorUpdateListener(listener);
            animator.addListener((Animator.AnimatorListener)listener);
            animator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)updateListener);
            animator.start();
        } else {
            this.deleteItemGivenId(this.mCurrentRemovedId);
        }
        this.clearCurrentRemovedView();
    }

    private void deleteItemGivenId(long deleteItemId) {
        int position = -1;
        int numItems = this.getCount();
        for (int i = 0; i < numItems; ++i) {
            long itemId = this.getItemId(i);
            if (itemId != deleteItemId) continue;
            position = i;
            break;
        }
        if (position >= 0) {
            this.mDeleteItemCallback.deleteItem(position);
        }
    }

    private ContextualUndoView getCurrentRemovedView(ContextualUndoView currentRemovedView, long itemId) {
        ContextualUndoView result = currentRemovedView;
        if (result == null || result.getParent() == null || result.getItemId() != itemId || AdapterViewUtil.getPositionForView(this.getAbsListView(), (View)result) < 0) {
            result = this.getContextualUndoView(itemId);
        }
        return result;
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putLong(EXTRA_ACTIVE_REMOVED_ID, this.mCurrentRemovedId);
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null) {
            this.mCurrentRemovedId = savedInstanceState.getLong(EXTRA_ACTIVE_REMOVED_ID, -1L);
        }
    }

    public void swipeViewAtPosition(int position) {
        this.mCurrentRemovedId = this.getItemId(position);
        for (int i = 0; i < this.getAbsListView().getChildCount(); ++i) {
            View childView;
            AbsListView absListView = this.getAbsListView();
            int positionForView = AdapterViewUtil.getPositionForView(absListView, childView = absListView.getChildAt(i));
            if (positionForView != position) continue;
            this.swipeView(childView, positionForView);
        }
    }

    private void swipeView(final View view, final int dismissPosition) {
        ObjectAnimator animator = ObjectAnimator.ofFloat((Object)view, (String)X, (float[])new float[]{view.getMeasuredWidth()});
        animator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator) {
                ContextualUndoAdapter.this.onViewSwiped(((ContextualUndoView)view).getItemId(), dismissPosition);
            }
        });
        animator.start();
    }

    @Override
    public void setIsParentHorizontalScrollContainer(boolean isParentHorizontalScrollContainer) {
        super.setIsParentHorizontalScrollContainer(isParentHorizontalScrollContainer);
        if (this.mContextualUndoListViewTouchListener != null) {
            this.mContextualUndoListViewTouchListener.setIsParentHorizontalScrollContainer(isParentHorizontalScrollContainer);
        }
    }

    @Override
    public void setTouchChild(int childResId) {
        super.setTouchChild(childResId);
        if (this.mContextualUndoListViewTouchListener != null) {
            this.mContextualUndoListViewTouchListener.setTouchChild(childResId);
        }
    }

    @Deprecated
    public void removePendingItem(boolean animate) {
        if (animate) {
            this.animateRemovePendingItem();
        } else {
            this.removePendingItem();
        }
    }

    public void removePendingItem() {
        if (this.mCurrentRemovedView != null || this.mCurrentRemovedId >= 0L) {
            new RemoveViewAnimatorListenerAdapter(this.mCurrentRemovedView, this.mCurrentRemovedId).onAnimationEnd(null);
            this.clearCurrentRemovedView();
        }
    }

    public void animateRemovePendingItem() {
        this.removePreviousContextualUndoIfPresent();
    }

    public void cancelCountDown() {
        this.mHandler.removeCallbacks((Runnable)this.mCountDownRunnable);
    }

    private static class ViewHolder {
        final ContextualUndoView mContextualUndoView;
        long mItemId;

        static ViewHolder getViewHolder(View view) {
            return (ViewHolder)view.getTag();
        }

        ViewHolder(ContextualUndoView contextualUndoView) {
            this.mContextualUndoView = contextualUndoView;
            this.mContextualUndoView.setTag(this);
        }
    }

    private class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private HierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            ViewHolder vh = ViewHolder.getViewHolder(child);
            if (vh != null && ContextualUndoAdapter.this.mCurrentRemovedId > 0L && vh.mItemId == ContextualUndoAdapter.this.mCurrentRemovedId) {
                ContextualUndoAdapter.this.mCurrentRemovedView = (ContextualUndoView)child;
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            ViewHolder vh = ViewHolder.getViewHolder(child);
            if (vh != null && ContextualUndoAdapter.this.mCurrentRemovedId > 0L && vh.mItemId == ContextualUndoAdapter.this.mCurrentRemovedId) {
                ContextualUndoAdapter.this.mCurrentRemovedView = null;
            }
        }
    }

    private class UndoListener
    implements View.OnClickListener {
        private final ContextualUndoView mContextualUndoView;

        public UndoListener(ContextualUndoView contextualUndoView) {
            this.mContextualUndoView = contextualUndoView;
        }

        public void onClick(View v) {
            ContextualUndoAdapter.this.clearCurrentRemovedView();
            this.mContextualUndoView.displayContentView();
            this.moveViewOffScreen();
            this.animateViewComingBack();
        }

        private void moveViewOffScreen() {
            ViewHelper.setTranslationX((View)this.mContextualUndoView, (float)this.mContextualUndoView.getWidth());
        }

        private void animateViewComingBack() {
            ViewPropertyAnimator.animate((View)this.mContextualUndoView).translationX(0.0f).setDuration(150L).setListener(null);
        }
    }

    private class RemoveViewAnimatorUpdateListener
    implements ValueAnimator.AnimatorUpdateListener {
        final RemoveViewAnimatorListenerAdapter mParentAdapter;
        private final ViewGroup.LayoutParams mLayoutParams;

        public RemoveViewAnimatorUpdateListener(RemoveViewAnimatorListenerAdapter parentAdapter) {
            this.mParentAdapter = parentAdapter;
            this.mLayoutParams = parentAdapter.mDismissView.getLayoutParams();
        }

        public void onAnimationUpdate(ValueAnimator valueAnimator) {
            ContextualUndoView dismissView = this.mParentAdapter.getViewBeingAnimated();
            if (dismissView != null) {
                this.mLayoutParams.height = (Integer)valueAnimator.getAnimatedValue();
                dismissView.setLayoutParams(this.mLayoutParams);
            }
        }
    }

    private class RemoveViewAnimatorListenerAdapter
    extends AnimatorListenerAdapter {
        private ContextualUndoView mDismissView;
        private final long mDismissViewId;
        private final int mOriginalHeight;

        public RemoveViewAnimatorListenerAdapter(ContextualUndoView dismissView, long dismissViewId) {
            this.mDismissView = dismissView;
            this.mDismissViewId = dismissViewId;
            this.mOriginalHeight = dismissView.getHeight();
        }

        public void onAnimationEnd(Animator animation) {
            this.mDismissView = this.getViewBeingAnimated();
            if (this.mDismissView == null) {
                ContextualUndoAdapter.this.deleteItemGivenId(this.mDismissViewId);
                return;
            }
            ContextualUndoAdapter.this.restoreViewPosition((View)this.mDismissView);
            this.restoreViewDimension((View)this.mDismissView);
            this.deleteCurrentItem((View)this.mDismissView);
        }

        private void restoreViewDimension(View view) {
            ViewGroup.LayoutParams lp = view.getLayoutParams();
            lp.height = this.mOriginalHeight;
            view.setLayoutParams(lp);
        }

        private void deleteCurrentItem(View view) {
            int position = AdapterViewUtil.getPositionForView(ContextualUndoAdapter.this.getAbsListView(), view);
            ContextualUndoAdapter.this.mDeleteItemCallback.deleteItem(position);
        }

        private ContextualUndoView getViewBeingAnimated() {
            ContextualUndoView newDismissView = ContextualUndoAdapter.this.getCurrentRemovedView(this.mDismissView, this.mDismissViewId);
            if (newDismissView != this.mDismissView) {
                ContextualUndoAdapter.this.restoreViewPosition((View)this.mDismissView);
                this.restoreViewDimension((View)this.mDismissView);
                this.mDismissView = newDismissView;
            }
            return this.mDismissView;
        }
    }

    private class CountDownRunnable
    implements Runnable {
        private CountDownRunnable() {
        }

        @Override
        public void run() {
            long millisRemaining = (long)ContextualUndoAdapter.this.mAutoDeleteDelayMillis - (System.currentTimeMillis() - ContextualUndoAdapter.this.mDismissStartMillis);
            if (ContextualUndoAdapter.this.mCountDownFormatter != null) {
                ContextualUndoAdapter.this.mCurrentRemovedView.updateCountDownTimer(ContextualUndoAdapter.this.mCountDownFormatter.getCountDownString(millisRemaining));
            }
            if (millisRemaining <= 0L) {
                ContextualUndoAdapter.this.performRemovalIfNecessary();
            } else {
                ContextualUndoAdapter.this.mHandler.postDelayed((Runnable)this, Math.min(millisRemaining, 1000L));
            }
        }
    }

    public static interface CountDownFormatter {
        public String getCountDownString(long var1);
    }

    public static interface DeleteItemCallback {
        public void deleteItem(int var1);
    }
}

