/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo;

import android.content.Context;
import android.graphics.Rect;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListAdapter;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.DismissableManager;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeOnTouchListener;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo.ContextualUndoView;
import com.nhaarman.listviewanimations.util.AdapterViewUtil;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.view.ViewHelper;
import com.nineoldandroids.view.ViewPropertyAnimator;

public class ContextualUndoListViewTouchListener
implements SwipeOnTouchListener {
    private final int mSlop;
    private final int mMinFlingVelocity;
    private final int mMaxFlingVelocity;
    private final long mAnimationTime;
    private final AbsListView mListView;
    private final Callback mCallback;
    private int mViewWidth = 1;
    private float mDownX;
    private float mDownY;
    private boolean mSwiping;
    private VelocityTracker mVelocityTracker;
    private int mDownPosition;
    private View mDownView;
    private boolean mPaused;
    private boolean mDisallowSwipe;
    private boolean mIsParentHorizontalScrollContainer;
    private int mResIdOfTouchChild;
    private boolean mTouchChildTouched;
    private DismissableManager mDismissableManager;

    public ContextualUndoListViewTouchListener(AbsListView listView, Callback callback) {
        ViewConfiguration vc = ViewConfiguration.get((Context)listView.getContext());
        this.mSlop = vc.getScaledTouchSlop();
        this.mMinFlingVelocity = vc.getScaledMinimumFlingVelocity();
        this.mMaxFlingVelocity = vc.getScaledMaximumFlingVelocity();
        this.mAnimationTime = listView.getContext().getResources().getInteger(0x10E0000);
        this.mListView = listView;
        this.mCallback = callback;
    }

    public void setEnabled(boolean enabled) {
        this.mPaused = !enabled;
    }

    public void setDismissableManager(DismissableManager dismissableManager) {
        this.mDismissableManager = dismissableManager;
    }

    public AbsListView.OnScrollListener makeScrollListener() {
        return new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                ContextualUndoListViewTouchListener.this.setEnabled(scrollState != 1);
                if (ContextualUndoListViewTouchListener.this.mPaused) {
                    ContextualUndoListViewTouchListener.this.mCallback.onListScrolled();
                }
                if (scrollState != 0) {
                    ContextualUndoListViewTouchListener.this.mDisallowSwipe = true;
                }
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        };
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        boolean result;
        if (this.mViewWidth < 2) {
            this.mViewWidth = this.mListView.getWidth();
        }
        switch (motionEvent.getActionMasked()) {
            case 0: {
                result = this.handleDownEvent(view, motionEvent);
                break;
            }
            case 2: {
                result = this.handleMoveEvent(view, motionEvent);
                break;
            }
            case 1: 
            case 3: {
                result = this.handleUpCancelEvent(view, motionEvent);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean handleDownEvent(View view, MotionEvent motionEvent) {
        this.mDisallowSwipe = false;
        if (this.mPaused) {
            return false;
        }
        Rect rect = new Rect();
        int childCount = this.mListView.getChildCount();
        int[] listViewCoords = new int[2];
        this.mListView.getLocationOnScreen(listViewCoords);
        int x = (int)motionEvent.getRawX() - listViewCoords[0];
        int y = (int)motionEvent.getRawY() - listViewCoords[1];
        for (int i = 0; i < childCount; ++i) {
            View child = this.mListView.getChildAt(i);
            child.getHitRect(rect);
            if (!rect.contains(x, y)) continue;
            this.mDownView = child;
            break;
        }
        if (this.mDownView != null && this.mDownView instanceof ContextualUndoView) {
            long downId;
            this.mDownX = motionEvent.getRawX();
            this.mDownY = motionEvent.getRawY();
            int downPosition = AdapterViewUtil.getPositionForView(this.mListView, this.mDownView);
            if (this.mDismissableManager != null && !this.mDismissableManager.isDismissable(downId = ((ListAdapter)this.mListView.getAdapter()).getItemId(downPosition), downPosition)) {
                return false;
            }
            boolean bl = this.mTouchChildTouched = !this.mIsParentHorizontalScrollContainer && this.mResIdOfTouchChild == 0;
            if (this.mResIdOfTouchChild != 0) {
                Rect childRect;
                this.mIsParentHorizontalScrollContainer = false;
                View childView = this.mDownView.findViewById(this.mResIdOfTouchChild);
                if (childView != null && (childRect = this.getChildViewRect((View)this.mListView, childView)).contains((int)motionEvent.getX(), (int)motionEvent.getY())) {
                    this.mTouchChildTouched = true;
                    this.mListView.requestDisallowInterceptTouchEvent(true);
                }
            }
            if (this.mIsParentHorizontalScrollContainer) {
                this.mTouchChildTouched = true;
                this.mListView.requestDisallowInterceptTouchEvent(true);
            }
            this.mDownY = motionEvent.getRawY();
            this.mDownPosition = AdapterViewUtil.getPositionForView(this.mListView, this.mDownView);
            if (this.mTouchChildTouched) {
                this.mVelocityTracker = VelocityTracker.obtain();
                this.mVelocityTracker.addMovement(motionEvent);
            } else {
                this.mVelocityTracker = null;
            }
        }
        view.onTouchEvent(motionEvent);
        return true;
    }

    private boolean handleMoveEvent(View view, MotionEvent motionEvent) {
        if (this.mVelocityTracker == null || this.mPaused) {
            return false;
        }
        this.mVelocityTracker.addMovement(motionEvent);
        float deltaX = motionEvent.getRawX() - this.mDownX;
        float deltaY = motionEvent.getRawY() - this.mDownY;
        if (this.mTouchChildTouched && !this.mDisallowSwipe && Math.abs(deltaX) > (float)this.mSlop && Math.abs(deltaX) > Math.abs(deltaY)) {
            this.mSwiping = true;
            this.mListView.requestDisallowInterceptTouchEvent(true);
            MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)motionEvent);
            cancelEvent.setAction(3 | motionEvent.getActionIndex() << 8);
            this.mListView.onTouchEvent(cancelEvent);
            cancelEvent.recycle();
        }
        if (this.mSwiping) {
            ViewHelper.setTranslationX((View)this.mDownView, (float)deltaX);
            ViewHelper.setAlpha((View)this.mDownView, (float)Math.max(0.0f, Math.min(1.0f, 1.0f - 2.0f * Math.abs(deltaX) / (float)this.mViewWidth)));
            return true;
        }
        return false;
    }

    private boolean handleUpCancelEvent(View view, MotionEvent motionEvent) {
        this.mDisallowSwipe = false;
        if (this.mVelocityTracker == null) {
            return false;
        }
        float deltaX = motionEvent.getRawX() - this.mDownX;
        this.mVelocityTracker.addMovement(motionEvent);
        this.mVelocityTracker.computeCurrentVelocity(1000);
        float velocityX = Math.abs(this.mVelocityTracker.getXVelocity());
        float velocityY = Math.abs(this.mVelocityTracker.getYVelocity());
        boolean dismiss = false;
        boolean dismissRight = false;
        float absDeltaX = Math.abs(deltaX);
        if (absDeltaX > (float)(this.mViewWidth / 2)) {
            dismiss = true;
            dismissRight = deltaX > 0.0f;
        } else if ((float)this.mMinFlingVelocity <= velocityX && velocityX <= (float)this.mMaxFlingVelocity && velocityY < velocityX && absDeltaX > (float)this.mSlop) {
            dismiss = true;
            boolean bl = dismissRight = this.mVelocityTracker.getXVelocity() > 0.0f;
        }
        if (dismiss) {
            final long itemId = ((ContextualUndoView)this.mDownView).getItemId();
            final int downPosition = this.mDownPosition;
            ViewPropertyAnimator.animate((View)this.mDownView).translationX(dismissRight ? (float)this.mViewWidth : (float)(-this.mViewWidth)).alpha(0.0f).setDuration(this.mAnimationTime).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    ContextualUndoListViewTouchListener.this.mCallback.onViewSwiped(itemId, downPosition);
                }
            });
        } else {
            ViewPropertyAnimator.animate((View)this.mDownView).translationX(0.0f).alpha(1.0f).setDuration(this.mAnimationTime).setListener(null);
        }
        this.mVelocityTracker.recycle();
        this.mVelocityTracker = null;
        this.mDownX = 0.0f;
        this.mDownView = null;
        this.mDownPosition = -1;
        this.mSwiping = false;
        return false;
    }

    @Override
    public boolean isSwiping() {
        return this.mSwiping;
    }

    private Rect getChildViewRect(View parentView, View childView) {
        ViewGroup parent;
        Rect childRect = new Rect(childView.getLeft(), childView.getTop(), childView.getRight(), childView.getBottom());
        if (parentView == childView) {
            return childRect;
        }
        while ((parent = (ViewGroup)childView.getParent()) != parentView) {
            childRect.offset(parent.getLeft(), parent.getTop());
            childView = parent;
        }
        return childRect;
    }

    void setIsParentHorizontalScrollContainer(boolean isParentHorizontalScrollContainer) {
        this.mIsParentHorizontalScrollContainer = this.mResIdOfTouchChild == 0 && isParentHorizontalScrollContainer;
    }

    void setTouchChild(int childResId) {
        this.mResIdOfTouchChild = childResId;
        if (childResId != 0) {
            this.setIsParentHorizontalScrollContainer(false);
        }
    }

    public static interface Callback {
        public void onViewSwiped(long var1, int var3);

        public void onListScrolled();
    }
}

