/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.contextualundo;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

@SuppressLint(value={"ViewConstructor"})
public class ContextualUndoView
extends FrameLayout {
    private View mUndoView;
    private View mContentView;
    private TextView mCountDownTV;
    private long mItemId;

    public ContextualUndoView(Context context, int undoLayoutResId, int countDownTextViewResId) {
        super(context);
        this.initUndo(undoLayoutResId, countDownTextViewResId);
    }

    private void initUndo(int undoLayoutResId, int countDownTextViewResId) {
        this.mUndoView = View.inflate((Context)this.getContext(), (int)undoLayoutResId, null);
        this.addView(this.mUndoView);
        if (countDownTextViewResId != -1) {
            this.mCountDownTV = (TextView)this.mUndoView.findViewById(countDownTextViewResId);
        }
    }

    public void updateCountDownTimer(String timerText) {
        if (this.mCountDownTV != null) {
            this.mCountDownTV.setText((CharSequence)timerText);
        }
    }

    public void updateContentView(View contentView) {
        if (this.mContentView == null) {
            this.addView(contentView);
        }
        this.mContentView = contentView;
    }

    public View getContentView() {
        return this.mContentView;
    }

    public void setItemId(long itemId) {
        this.mItemId = itemId;
    }

    public long getItemId() {
        return this.mItemId;
    }

    public boolean isContentDisplayed() {
        return this.mContentView.getVisibility() == 0;
    }

    public void displayUndo() {
        this.updateCountDownTimer("");
        this.mContentView.setVisibility(4);
        this.mUndoView.setVisibility(0);
    }

    public void displayContentView() {
        this.mContentView.setVisibility(0);
        this.mUndoView.setVisibility(4);
    }
}

