/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.swinginadapters;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.GridView;
import com.nhaarman.listviewanimations.BaseAdapterDecorator;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorSet;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.view.ViewHelper;

public abstract class AnimationAdapter
extends BaseAdapterDecorator {
    protected static final long DEFAULTANIMATIONDELAYMILLIS = 100L;
    protected static final long DEFAULTANIMATIONDURATIONMILLIS = 300L;
    private static final long INITIALDELAYMILLIS = 150L;
    private static final String ALPHA = "alpha";
    private final SparseArray<Animator> mAnimators = new SparseArray();
    private long mAnimationStartMillis = -1L;
    private int mFirstAnimatedPosition = -1;
    private int mLastAnimatedPosition = -1;
    private boolean mHasParentAnimationAdapter;
    private boolean mShouldAnimate = true;
    private long mInitialDelayMillis = 150L;
    private long mAnimationDelayMillis = 100L;
    private long mAnimationDurationMillis = 300L;

    public AnimationAdapter(BaseAdapter baseAdapter) {
        super(baseAdapter);
        if (baseAdapter instanceof AnimationAdapter) {
            ((AnimationAdapter)baseAdapter).setHasParentAnimationAdapter(true);
        }
    }

    public void reset() {
        this.mAnimators.clear();
        this.mFirstAnimatedPosition = -1;
        this.mLastAnimatedPosition = -1;
        this.mAnimationStartMillis = -1L;
        this.mShouldAnimate = true;
        if (this.getDecoratedBaseAdapter() instanceof AnimationAdapter) {
            ((AnimationAdapter)this.getDecoratedBaseAdapter()).reset();
        }
    }

    public void setShouldAnimate(boolean shouldAnimate) {
        this.mShouldAnimate = shouldAnimate;
    }

    public void setShouldAnimateFromPosition(int position) {
        this.mShouldAnimate = true;
        this.mFirstAnimatedPosition = position - 1;
        this.mLastAnimatedPosition = position - 1;
    }

    public void setShouldAnimateNotVisible() {
        if (this.getAbsListView() == null) {
            throw new IllegalStateException("Call setListView() on this AnimationAdapter before setShouldAnimateNotVisible()!");
        }
        this.mShouldAnimate = true;
        this.mFirstAnimatedPosition = this.getAbsListView().getLastVisiblePosition();
        this.mLastAnimatedPosition = this.getAbsListView().getLastVisiblePosition();
    }

    @Override
    public final View getView(int position, View convertView, ViewGroup parent) {
        if (!this.mHasParentAnimationAdapter) {
            if (this.getAbsListView() == null) {
                throw new IllegalStateException("Call setListView() on this AnimationAdapter before setAdapter()!");
            }
            if (convertView != null) {
                this.cancelExistingAnimation(convertView);
            }
        }
        View itemView = super.getView(position, convertView, parent);
        if (!this.mHasParentAnimationAdapter) {
            this.animateViewIfNecessary(position, itemView, parent);
        }
        return itemView;
    }

    private void cancelExistingAnimation(View convertView) {
        int hashCode = convertView.hashCode();
        Animator animator = (Animator)this.mAnimators.get(hashCode);
        if (animator != null) {
            animator.end();
            this.mAnimators.remove(hashCode);
        }
    }

    private void animateViewIfNecessary(int position, View view, ViewGroup parent) {
        boolean isMeasuringGridViewItem;
        boolean bl = isMeasuringGridViewItem = this.getAbsListView() instanceof GridView && parent.getHeight() == 0;
        if (position > this.mLastAnimatedPosition && this.mShouldAnimate && !isMeasuringGridViewItem) {
            if (this.mFirstAnimatedPosition == -1) {
                this.mFirstAnimatedPosition = position;
            }
            this.animateView(parent, view);
            this.mLastAnimatedPosition = position;
        }
    }

    private void animateView(ViewGroup parent, View view) {
        if (this.mAnimationStartMillis == -1L) {
            this.mAnimationStartMillis = System.currentTimeMillis();
        }
        ViewHelper.setAlpha((View)view, (float)0.0f);
        Animator[] childAnimators = this.mDecoratedBaseAdapter instanceof AnimationAdapter ? ((AnimationAdapter)this.mDecoratedBaseAdapter).getAnimators(parent, view) : new Animator[]{};
        Animator[] animators = this.getAnimators(parent, view);
        ObjectAnimator alphaAnimator = ObjectAnimator.ofFloat((Object)view, (String)ALPHA, (float[])new float[]{0.0f, 1.0f});
        AnimatorSet set = new AnimatorSet();
        set.playTogether(this.concatAnimators(childAnimators, animators, (Animator)alphaAnimator));
        set.setStartDelay(this.calculateAnimationDelay());
        set.setDuration(this.getAnimationDurationMillis());
        set.start();
        this.mAnimators.put(view.hashCode(), (Object)set);
    }

    private Animator[] concatAnimators(Animator[] childAnimators, Animator[] animators, Animator alphaAnimator) {
        int i;
        Animator[] allAnimators = new Animator[childAnimators.length + animators.length + 1];
        for (i = 0; i < animators.length; ++i) {
            allAnimators[i] = animators[i];
        }
        Animator[] arr$ = childAnimators;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Animator childAnimator;
            allAnimators[i] = childAnimator = arr$[i$];
            ++i;
        }
        allAnimators[allAnimators.length - 1] = alphaAnimator;
        return allAnimators;
    }

    @SuppressLint(value={"NewApi"})
    private long calculateAnimationDelay() {
        long delay;
        int numberOfAnimatedItems;
        int firstVisiblePosition;
        int lastVisiblePosition = this.getAbsListView().getLastVisiblePosition();
        int numberOfItemsOnScreen = lastVisiblePosition - (firstVisiblePosition = this.getAbsListView().getFirstVisiblePosition());
        if (numberOfItemsOnScreen + 1 < (numberOfAnimatedItems = this.mLastAnimatedPosition - this.mFirstAnimatedPosition)) {
            delay = this.getAnimationDelayMillis();
            if (this.getAbsListView() instanceof GridView && Build.VERSION.SDK_INT >= 11) {
                delay += this.getAnimationDelayMillis() * (long)((this.mLastAnimatedPosition + 1) % ((GridView)this.getAbsListView()).getNumColumns());
            }
        } else {
            long delaySinceStart = (long)(this.mLastAnimatedPosition - this.mFirstAnimatedPosition + 1) * this.getAnimationDelayMillis();
            delay = this.mAnimationStartMillis + this.getInitialDelayMillis() + delaySinceStart - System.currentTimeMillis();
        }
        return Math.max(0L, delay);
    }

    public void setHasParentAnimationAdapter(boolean hasParentAnimationAdapter) {
        this.mHasParentAnimationAdapter = hasParentAnimationAdapter;
    }

    protected long getInitialDelayMillis() {
        return this.mInitialDelayMillis;
    }

    public void setInitialDelayMillis(long delayMillis) {
        this.mInitialDelayMillis = delayMillis;
    }

    protected long getAnimationDelayMillis() {
        return this.mAnimationDelayMillis;
    }

    public void setAnimationDelayMillis(long delayMillis) {
        this.mAnimationDelayMillis = delayMillis;
    }

    protected long getAnimationDurationMillis() {
        return this.mAnimationDurationMillis;
    }

    public void setAnimationDurationMillis(long durationMillis) {
        this.mAnimationDurationMillis = durationMillis;
    }

    public abstract Animator[] getAnimators(ViewGroup var1, View var2);
}

