/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.swinginadapters.prepared;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import com.nhaarman.listviewanimations.swinginadapters.AnimationAdapter;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.ObjectAnimator;

public class ScaleInAnimationAdapter
extends AnimationAdapter {
    private static final float DEFAULTSCALEFROM = 0.8f;
    private static final String SCALE_X = "scaleX";
    private static final String SCALE_Y = "scaleY";
    private final float mScaleFrom;
    private final long mAnimationDelayMillis;
    private final long mAnimationDurationMillis;

    public ScaleInAnimationAdapter(BaseAdapter baseAdapter) {
        this(baseAdapter, 0.8f);
    }

    public ScaleInAnimationAdapter(BaseAdapter baseAdapter, float scaleFrom) {
        this(baseAdapter, scaleFrom, 100L, 300L);
    }

    public ScaleInAnimationAdapter(BaseAdapter baseAdapter, float scaleFrom, long animationDelayMillis, long animationDurationMillis) {
        super(baseAdapter);
        this.mScaleFrom = scaleFrom;
        this.mAnimationDelayMillis = animationDelayMillis;
        this.mAnimationDurationMillis = animationDurationMillis;
    }

    @Override
    protected long getAnimationDelayMillis() {
        return this.mAnimationDelayMillis;
    }

    @Override
    protected long getAnimationDurationMillis() {
        return this.mAnimationDurationMillis;
    }

    @Override
    public Animator[] getAnimators(ViewGroup parent, View view) {
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)view, (String)SCALE_X, (float[])new float[]{this.mScaleFrom, 1.0f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)view, (String)SCALE_Y, (float[])new float[]{this.mScaleFrom, 1.0f});
        return new ObjectAnimator[]{scaleX, scaleY};
    }
}

