/*
 * Decompiled with CFR 0.152.
 */
package com.nhaarman.listviewanimations.widget;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.nhaarman.listviewanimations.itemmanipulation.swipedismiss.SwipeOnTouchListener;
import com.nineoldandroids.animation.Animator;
import com.nineoldandroids.animation.AnimatorListenerAdapter;
import com.nineoldandroids.animation.ObjectAnimator;
import com.nineoldandroids.animation.TypeEvaluator;
import com.nineoldandroids.animation.ValueAnimator;
import com.nineoldandroids.view.ViewHelper;

public class DynamicListView
extends ListView {
    private int mOriginalTranscriptMode;
    private final int SMOOTH_SCROLL_AMOUNT_AT_EDGE = 15;
    private final int MOVE_DURATION = 150;
    private int mLastEventY = -1;
    private int mLastEventX = -1;
    private int mDownY = -1;
    private int mDownX = -1;
    private int mTotalOffset = 0;
    private boolean mCellIsMobile = false;
    private boolean mIsMobileScrolling = false;
    private int mSmoothScrollAmountAtEdge = 0;
    private final int INVALID_ID = -1;
    private long mAboveItemId = -1L;
    private long mMobileItemId = -1L;
    private long mBelowItemId = -1L;
    private Drawable mHoverCell;
    private Rect mHoverCellCurrentBounds;
    private Rect mHoverCellOriginalBounds;
    private final int INVALID_POINTER_ID = -1;
    private int mActivePointerId = -1;
    private boolean mIsWaitingForScrollFinish = false;
    private int mScrollState = 0;
    private View.OnTouchListener mOnTouchListener;
    private boolean mIsParentHorizontalScrollContainer;
    private int mResIdOfDynamicTouchChild;
    private boolean mDynamicTouchChildTouched;
    private int mSlop;
    private boolean mSkipCallingOnTouchListener;
    private OnHoverCellListener mOnHoverCellListener;
    private OnItemMovedListener mOnItemMovedListener;
    private int mLastMovedToIndex;
    private AdapterView.OnItemLongClickListener mOnItemLongClickListener = new AdapterView.OnItemLongClickListener(){

        public boolean onItemLongClick(AdapterView<?> arg0, View arg1, int pos, long id) {
            if (DynamicListView.this.mResIdOfDynamicTouchChild == 0) {
                DynamicListView.this.mDynamicTouchChildTouched = true;
                DynamicListView.this.makeCellMobile();
                return true;
            }
            return false;
        }
    };
    private static final TypeEvaluator<Rect> sBoundEvaluator = new TypeEvaluator<Rect>(){

        public Rect evaluate(float fraction, Rect startValue, Rect endValue) {
            return new Rect(this.interpolate(startValue.left, endValue.left, fraction), this.interpolate(startValue.top, endValue.top, fraction), this.interpolate(startValue.right, endValue.right, fraction), this.interpolate(startValue.bottom, endValue.bottom, fraction));
        }

        public int interpolate(int start, int end, float fraction) {
            return (int)((float)start + fraction * (float)(end - start));
        }
    };
    private AbsListView.OnScrollListener mScrollListener = new AbsListView.OnScrollListener(){
        private int mPreviousFirstVisibleItem = -1;
        private int mPreviousVisibleItemCount = -1;
        private int mCurrentFirstVisibleItem;
        private int mCurrentVisibleItemCount;
        private int mCurrentScrollState;

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            this.mCurrentFirstVisibleItem = firstVisibleItem;
            this.mCurrentVisibleItemCount = visibleItemCount;
            this.mPreviousFirstVisibleItem = this.mPreviousFirstVisibleItem == -1 ? this.mCurrentFirstVisibleItem : this.mPreviousFirstVisibleItem;
            this.mPreviousVisibleItemCount = this.mPreviousVisibleItemCount == -1 ? this.mCurrentVisibleItemCount : this.mPreviousVisibleItemCount;
            this.checkAndHandleFirstVisibleCellChange();
            this.checkAndHandleLastVisibleCellChange();
            this.mPreviousFirstVisibleItem = this.mCurrentFirstVisibleItem;
            this.mPreviousVisibleItemCount = this.mCurrentVisibleItemCount;
        }

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            this.mCurrentScrollState = scrollState;
            DynamicListView.this.mScrollState = scrollState;
            this.isScrollCompleted();
        }

        private void isScrollCompleted() {
            if (this.mCurrentVisibleItemCount > 0 && this.mCurrentScrollState == 0) {
                if (DynamicListView.this.mCellIsMobile && DynamicListView.this.mIsMobileScrolling) {
                    DynamicListView.this.handleMobileCellScroll();
                } else if (DynamicListView.this.mIsWaitingForScrollFinish) {
                    DynamicListView.this.touchEventsEnded();
                }
            }
        }

        public void checkAndHandleFirstVisibleCellChange() {
            if (this.mCurrentFirstVisibleItem != this.mPreviousFirstVisibleItem && DynamicListView.this.mCellIsMobile && DynamicListView.this.mMobileItemId != -1L) {
                DynamicListView.this.updateNeighborViewsForId(DynamicListView.this.mMobileItemId);
                DynamicListView.this.handleCellSwitch();
            }
        }

        public void checkAndHandleLastVisibleCellChange() {
            int currentLastVisibleItem = this.mCurrentFirstVisibleItem + this.mCurrentVisibleItemCount;
            int previousLastVisibleItem = this.mPreviousFirstVisibleItem + this.mPreviousVisibleItemCount;
            if (currentLastVisibleItem != previousLastVisibleItem && DynamicListView.this.mCellIsMobile && DynamicListView.this.mMobileItemId != -1L) {
                DynamicListView.this.updateNeighborViewsForId(DynamicListView.this.mMobileItemId);
                DynamicListView.this.handleCellSwitch();
            }
        }
    };

    public DynamicListView(Context context) {
        super(context);
        this.init(context);
    }

    public DynamicListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    public DynamicListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public void init(Context context) {
        this.setOnItemLongClickListener(this.mOnItemLongClickListener);
        this.setOnScrollListener(this.mScrollListener);
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        this.mSmoothScrollAmountAtEdge = (int)(15.0f / metrics.density);
        ViewConfiguration vc = ViewConfiguration.get((Context)this.getContext());
        this.mSlop = vc.getScaledTouchSlop();
    }

    public void setAdapter(BaseAdapter adapter) {
        super.setAdapter((ListAdapter)adapter);
    }

    @Deprecated
    public void setAdapter(ListAdapter adapter) {
        if (!(adapter instanceof BaseAdapter)) {
            throw new IllegalArgumentException("DynamicListView needs a BaseAdapter!");
        }
        super.setAdapter(adapter);
    }

    private void makeCellMobile() {
        int position = this.pointToPosition(this.mDownX, this.mDownY);
        int itemNum = position - this.getFirstVisiblePosition();
        View selectedView = this.getChildAt(itemNum);
        if (selectedView == null || position < this.getHeaderViewsCount() || position >= this.getAdapter().getCount() - this.getHeaderViewsCount()) {
            return;
        }
        this.mOriginalTranscriptMode = this.getTranscriptMode();
        this.setTranscriptMode(1);
        this.mTotalOffset = 0;
        this.mMobileItemId = this.getAdapter().getItemId(position);
        this.mHoverCell = this.getAndAddHoverView(selectedView);
        if (this.mOnHoverCellListener != null) {
            this.mHoverCell = this.mOnHoverCellListener.onHoverCellCreated(this.mHoverCell);
        }
        selectedView.setVisibility(4);
        this.mCellIsMobile = true;
        this.getParent().requestDisallowInterceptTouchEvent(true);
        this.updateNeighborViewsForId(this.mMobileItemId);
    }

    private BitmapDrawable getAndAddHoverView(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        int top = v.getTop();
        int left = v.getLeft();
        Bitmap b = this.getBitmapFromView(v);
        BitmapDrawable drawable = new BitmapDrawable(this.getResources(), b);
        this.mHoverCellOriginalBounds = new Rect(left, top, left + w, top + h);
        this.mHoverCellCurrentBounds = new Rect(this.mHoverCellOriginalBounds);
        drawable.setBounds(this.mHoverCellCurrentBounds);
        return drawable;
    }

    private Bitmap getBitmapFromView(View v) {
        Bitmap bitmap = Bitmap.createBitmap((int)v.getWidth(), (int)v.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        v.draw(canvas);
        return bitmap;
    }

    private void updateNeighborViewsForId(long itemId) {
        int position = this.getPositionForId(itemId);
        ListAdapter adapter = this.getAdapter();
        if (!adapter.hasStableIds()) {
            throw new IllegalStateException("Adapter doesn't have stable ids! Make sure your adapter has stable ids, and override hasStableIds() to return true.");
        }
        this.mAboveItemId = position - 1 >= 0 ? adapter.getItemId(position - 1) : Long.MIN_VALUE;
        this.mBelowItemId = position + 1 < adapter.getCount() ? adapter.getItemId(position + 1) : Long.MIN_VALUE;
    }

    private View getViewForId(long itemId) {
        int firstVisiblePosition = this.getFirstVisiblePosition();
        ListAdapter adapter = this.getAdapter();
        if (!adapter.hasStableIds()) {
            throw new IllegalStateException("Adapter doesn't have stable ids! Make sure your adapter has stable ids, and override hasStableIds() to return true.");
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            View v = this.getChildAt(i);
            int position = firstVisiblePosition + i;
            long id = adapter.getItemId(position);
            if (id != itemId) continue;
            return v;
        }
        return null;
    }

    private int getPositionForId(long itemId) {
        View v = this.getViewForId(itemId);
        if (v == null) {
            return -1;
        }
        return this.getPositionForView(v);
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHoverCell != null) {
            this.mHoverCell.draw(canvas);
        }
    }

    public void setOnTouchListener(View.OnTouchListener l) {
        this.mOnTouchListener = l;
    }

    public void setOnHoverCellListener(OnHoverCellListener onHoverCellListener) {
        this.mOnHoverCellListener = onHoverCellListener;
    }

    private Rect getChildViewRect(View parentView, View childView) {
        ViewGroup parent;
        Rect childRect = new Rect(childView.getLeft(), childView.getTop(), childView.getRight(), childView.getBottom());
        if (parentView == childView) {
            return childRect;
        }
        while ((parent = (ViewGroup)childView.getParent()) != parentView) {
            childRect.offset(parent.getLeft(), parent.getTop());
            childView = parent;
        }
        return childRect;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mSkipCallingOnTouchListener) {
            return super.onTouchEvent(event);
        }
        if (this.mOnTouchListener instanceof SwipeOnTouchListener && ((SwipeOnTouchListener)this.mOnTouchListener).isSwiping()) {
            this.mSkipCallingOnTouchListener = true;
            boolean retVal = this.mOnTouchListener.onTouch((View)this, event);
            this.mSkipCallingOnTouchListener = false;
            return retVal || super.onTouchEvent(event);
        }
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.mDownX = (int)event.getX();
                this.mDownY = (int)event.getY();
                this.mActivePointerId = event.getPointerId(0);
                this.mDynamicTouchChildTouched = false;
                if (this.mResIdOfDynamicTouchChild != 0) {
                    Rect childRect;
                    View childView;
                    this.mIsParentHorizontalScrollContainer = false;
                    int position = this.pointToPosition(this.mDownX, this.mDownY);
                    int childNum = position != -1 ? position - this.getFirstVisiblePosition() : -1;
                    View itemView = childNum >= 0 ? this.getChildAt(childNum) : null;
                    View view = childView = itemView != null ? itemView.findViewById(this.mResIdOfDynamicTouchChild) : null;
                    if (childView != null && (childRect = this.getChildViewRect((View)this, childView)).contains(this.mDownX, this.mDownY)) {
                        this.mDynamicTouchChildTouched = true;
                        this.getParent().requestDisallowInterceptTouchEvent(true);
                    }
                }
                if (!this.mIsParentHorizontalScrollContainer) break;
                this.getParent().requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 2: {
                if (this.mActivePointerId == -1) break;
                int pointerIndex = event.findPointerIndex(this.mActivePointerId);
                this.mLastEventY = (int)event.getY(pointerIndex);
                this.mLastEventX = (int)event.getX(pointerIndex);
                int deltaY = this.mLastEventY - this.mDownY;
                int deltaX = this.mLastEventX - this.mDownX;
                if (!this.mCellIsMobile && this.mDynamicTouchChildTouched && Math.abs(deltaY) > this.mSlop && Math.abs(deltaY) > Math.abs(deltaX)) {
                    this.makeCellMobile();
                    MotionEvent cancelEvent = MotionEvent.obtain((MotionEvent)event);
                    cancelEvent.setAction(3 | event.getActionIndex() << 8);
                    super.onTouchEvent(cancelEvent);
                    cancelEvent.recycle();
                }
                if (!this.mCellIsMobile) break;
                this.mHoverCellCurrentBounds.offsetTo(this.mHoverCellOriginalBounds.left, this.mHoverCellOriginalBounds.top + deltaY + this.mTotalOffset);
                this.mHoverCell.setBounds(this.mHoverCellCurrentBounds);
                this.invalidate();
                this.handleCellSwitch();
                this.mIsMobileScrolling = false;
                this.handleMobileCellScroll();
                break;
            }
            case 1: {
                this.mDynamicTouchChildTouched = false;
                this.touchEventsEnded();
                break;
            }
            case 3: {
                this.mDynamicTouchChildTouched = false;
                this.touchEventsCancelled();
                break;
            }
            case 6: {
                int pointerIndex = (event.getAction() & 0xFF00) >> 8;
                int pointerId = event.getPointerId(pointerIndex);
                if (pointerId != this.mActivePointerId) break;
                this.mDynamicTouchChildTouched = false;
                this.touchEventsEnded();
                break;
            }
        }
        if (this.mCellIsMobile) {
            return false;
        }
        if (this.mOnTouchListener != null) {
            this.mSkipCallingOnTouchListener = true;
            boolean retVal = this.mOnTouchListener.onTouch((View)this, event);
            this.mSkipCallingOnTouchListener = false;
            if (retVal) {
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void handleCellSwitch() {
        boolean isAbove;
        final int deltaY = this.mLastEventY - this.mDownY;
        int deltaYTotal = this.mHoverCellOriginalBounds.top + this.mTotalOffset + deltaY;
        View belowView = this.getViewForId(this.mBelowItemId);
        View mobileView = this.getViewForId(this.mMobileItemId);
        View aboveView = this.getViewForId(this.mAboveItemId);
        boolean isBelow = belowView != null && deltaYTotal > belowView.getTop();
        boolean bl = isAbove = aboveView != null && deltaYTotal < aboveView.getTop();
        if (isBelow || isAbove) {
            final long switchItemId = isBelow ? this.mBelowItemId : this.mAboveItemId;
            View switchView = isBelow ? belowView : aboveView;
            int originalItem = this.getPositionForView(mobileView);
            if (switchView == null) {
                this.updateNeighborViewsForId(this.mMobileItemId);
                return;
            }
            if (this.getPositionForView(switchView) < this.getHeaderViewsCount()) {
                return;
            }
            this.swapElements(originalItem, this.getPositionForView(switchView));
            BaseAdapter adapter = this.getAdapter() instanceof HeaderViewListAdapter ? (BaseAdapter)((HeaderViewListAdapter)this.getAdapter()).getWrappedAdapter() : (BaseAdapter)this.getAdapter();
            adapter.notifyDataSetChanged();
            this.mDownY = this.mLastEventY;
            this.mDownX = this.mLastEventX;
            final int switchViewStartTop = switchView.getTop();
            mobileView.setVisibility(0);
            switchView.setVisibility(4);
            this.updateNeighborViewsForId(this.mMobileItemId);
            final ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    observer.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    View switchView = DynamicListView.this.getViewForId(switchItemId);
                    DynamicListView.this.mTotalOffset += deltaY;
                    int switchViewNewTop = switchView.getTop();
                    int delta = switchViewStartTop - switchViewNewTop;
                    ViewHelper.setTranslationY((View)switchView, (float)delta);
                    ObjectAnimator animator = ObjectAnimator.ofFloat((Object)switchView, (String)"translationY", (float[])new float[]{0.0f});
                    animator.setDuration(150L);
                    animator.start();
                    return true;
                }
            });
        }
    }

    private void swapElements(int indexOne, int indexTwo) {
        this.mLastMovedToIndex = indexTwo;
        ListAdapter adapter = this.getAdapter();
        if (adapter instanceof HeaderViewListAdapter) {
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        if (adapter instanceof Swappable) {
            ((Swappable)adapter).swapItems(indexOne - this.getHeaderViewsCount(), indexTwo - this.getHeaderViewsCount());
        }
    }

    private void touchEventsEnded() {
        final View mobileView = this.getViewForId(this.mMobileItemId);
        if (this.mCellIsMobile || this.mIsWaitingForScrollFinish) {
            this.mCellIsMobile = false;
            this.mIsWaitingForScrollFinish = false;
            this.mIsMobileScrolling = false;
            this.mActivePointerId = -1;
            this.setTranscriptMode(this.mOriginalTranscriptMode);
            if (this.mScrollState != 0) {
                this.mIsWaitingForScrollFinish = true;
                return;
            }
            this.mHoverCellCurrentBounds.offsetTo(this.mHoverCellOriginalBounds.left, mobileView.getTop());
            ObjectAnimator hoverViewAnimator = ObjectAnimator.ofObject((Object)this.mHoverCell, (String)"bounds", sBoundEvaluator, (Object[])new Object[]{this.mHoverCellCurrentBounds});
            hoverViewAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    DynamicListView.this.invalidate();
                }
            });
            hoverViewAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    DynamicListView.this.setEnabled(false);
                }

                public void onAnimationEnd(Animator animation) {
                    DynamicListView.this.mAboveItemId = -1L;
                    DynamicListView.this.mMobileItemId = -1L;
                    DynamicListView.this.mBelowItemId = -1L;
                    mobileView.setVisibility(0);
                    DynamicListView.this.mHoverCell = null;
                    DynamicListView.this.setEnabled(true);
                    DynamicListView.this.invalidate();
                    if (DynamicListView.this.mOnItemMovedListener != null) {
                        DynamicListView.this.mOnItemMovedListener.onItemMoved(DynamicListView.this.mLastMovedToIndex - DynamicListView.this.getHeaderViewsCount());
                    }
                }
            });
            hoverViewAnimator.start();
        } else {
            this.touchEventsCancelled();
        }
    }

    private void touchEventsCancelled() {
        View mobileView = this.getViewForId(this.mMobileItemId);
        if (this.mCellIsMobile) {
            this.mAboveItemId = -1L;
            this.mMobileItemId = -1L;
            this.mBelowItemId = -1L;
            mobileView.setVisibility(0);
            this.mHoverCell = null;
            this.invalidate();
        }
        this.mCellIsMobile = false;
        this.mIsMobileScrolling = false;
        this.mActivePointerId = -1;
    }

    private void handleMobileCellScroll() {
        this.mIsMobileScrolling = this.handleMobileCellScroll(this.mHoverCellCurrentBounds);
    }

    private boolean handleMobileCellScroll(Rect r) {
        int offset = this.computeVerticalScrollOffset();
        int height = this.getHeight();
        int extent = this.computeVerticalScrollExtent();
        int range = this.computeVerticalScrollRange();
        int hoverViewTop = r.top;
        int hoverHeight = r.height();
        if (hoverViewTop <= 0 && offset > 0) {
            this.smoothScrollBy(-this.mSmoothScrollAmountAtEdge, 0);
            return true;
        }
        if (hoverViewTop + hoverHeight >= height && offset + extent < range) {
            this.smoothScrollBy(this.mSmoothScrollAmountAtEdge, 0);
            return true;
        }
        return false;
    }

    public void setIsParentHorizontalScrollContainer(boolean isParentHorizontalScrollContainer) {
        this.mIsParentHorizontalScrollContainer = this.mResIdOfDynamicTouchChild == 0 && isParentHorizontalScrollContainer;
    }

    public boolean isParentHorizontalScrollContainer() {
        return this.mIsParentHorizontalScrollContainer;
    }

    public void setDynamicTouchChild(int childResId) {
        this.mResIdOfDynamicTouchChild = childResId;
        if (childResId != 0) {
            this.setIsParentHorizontalScrollContainer(false);
        }
    }

    public void setOnItemMovedListener(OnItemMovedListener onItemMovedListener) {
        this.mOnItemMovedListener = onItemMovedListener;
    }

    public static interface Swappable {
        public void swapItems(int var1, int var2);
    }

    public static interface OnItemMovedListener {
        public void onItemMoved(int var1);
    }

    public static interface OnHoverCellListener {
        public Drawable onHoverCellCreated(Drawable var1);
    }
}

