/*
 * Decompiled with CFR 0.152.
 */
package mf.javax.xml.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import mf.javax.xml.datatype.DatatypeConstants;
import mf.javax.xml.namespace.QName;

public abstract class Duration {
    private static final boolean DEBUG = true;

    public QName getXMLSchemaType() {
        boolean yearSet = this.isSet(DatatypeConstants.YEARS);
        boolean monthSet = this.isSet(DatatypeConstants.MONTHS);
        boolean daySet = this.isSet(DatatypeConstants.DAYS);
        boolean hourSet = this.isSet(DatatypeConstants.HOURS);
        boolean minuteSet = this.isSet(DatatypeConstants.MINUTES);
        boolean secondSet = this.isSet(DatatypeConstants.SECONDS);
        if (yearSet && monthSet && daySet && hourSet && minuteSet && secondSet) {
            return DatatypeConstants.DURATION;
        }
        if (!yearSet && !monthSet && daySet && hourSet && minuteSet && secondSet) {
            return DatatypeConstants.DURATION_DAYTIME;
        }
        if (yearSet && monthSet && !daySet && !hourSet && !minuteSet && !secondSet) {
            return DatatypeConstants.DURATION_YEARMONTH;
        }
        throw new IllegalStateException("javax.xml.datatype.Duration#getXMLSchemaType(): this Duration does not match one of the XML Schema date/time datatypes: year set = " + yearSet + " month set = " + monthSet + " day set = " + daySet + " hour set = " + hourSet + " minute set = " + minuteSet + " second set = " + secondSet);
    }

    public abstract int getSign();

    public int getYears() {
        return this.getField(DatatypeConstants.YEARS).intValue();
    }

    public int getMonths() {
        return this.getField(DatatypeConstants.MONTHS).intValue();
    }

    public int getDays() {
        return this.getField(DatatypeConstants.DAYS).intValue();
    }

    public int getHours() {
        return this.getField(DatatypeConstants.HOURS).intValue();
    }

    public int getMinutes() {
        return this.getField(DatatypeConstants.MINUTES).intValue();
    }

    public int getSeconds() {
        return this.getField(DatatypeConstants.SECONDS).intValue();
    }

    public long getTimeInMillis(Calendar startInstant) {
        Calendar cal = (Calendar)startInstant.clone();
        this.addTo(cal);
        return Duration.getCalendarTimeInMillis(cal) - Duration.getCalendarTimeInMillis(startInstant);
    }

    public long getTimeInMillis(Date startInstant) {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(startInstant);
        this.addTo(cal);
        return Duration.getCalendarTimeInMillis(cal) - startInstant.getTime();
    }

    public abstract Number getField(DatatypeConstants.Field var1);

    public abstract boolean isSet(DatatypeConstants.Field var1);

    public abstract Duration add(Duration var1);

    public abstract void addTo(Calendar var1);

    public void addTo(Date date) {
        if (date == null) {
            throw new NullPointerException("Cannot call " + this.getClass().getName() + "#addTo(Date date) with date == null.");
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        this.addTo(cal);
        date.setTime(Duration.getCalendarTimeInMillis(cal));
    }

    public Duration subtract(Duration rhs) {
        return this.add(rhs.negate());
    }

    public Duration multiply(int factor) {
        return this.multiply(new BigDecimal(String.valueOf(factor)));
    }

    public abstract Duration multiply(BigDecimal var1);

    public abstract Duration negate();

    public abstract Duration normalizeWith(Calendar var1);

    public abstract int compare(Duration var1);

    public boolean isLongerThan(Duration duration) {
        return this.compare(duration) == 1;
    }

    public boolean isShorterThan(Duration duration) {
        return this.compare(duration) == -1;
    }

    public boolean equals(Object duration) {
        if (duration == null || !(duration instanceof Duration)) {
            return false;
        }
        return this.compare((Duration)duration) == 0;
    }

    public abstract int hashCode();

    public String toString() {
        BigInteger days;
        BigInteger months;
        StringBuffer buf = new StringBuffer();
        if (this.getSign() < 0) {
            buf.append('-');
        }
        buf.append('P');
        BigInteger years = (BigInteger)this.getField(DatatypeConstants.YEARS);
        if (years != null) {
            buf.append(years + "Y");
        }
        if ((months = (BigInteger)this.getField(DatatypeConstants.MONTHS)) != null) {
            buf.append(months + "M");
        }
        if ((days = (BigInteger)this.getField(DatatypeConstants.DAYS)) != null) {
            buf.append(days + "D");
        }
        BigInteger hours = (BigInteger)this.getField(DatatypeConstants.HOURS);
        BigInteger minutes = (BigInteger)this.getField(DatatypeConstants.MINUTES);
        BigDecimal seconds = (BigDecimal)this.getField(DatatypeConstants.SECONDS);
        if (hours != null || minutes != null || seconds != null) {
            buf.append('T');
            if (hours != null) {
                buf.append(hours + "H");
            }
            if (minutes != null) {
                buf.append(minutes + "M");
            }
            if (seconds != null) {
                buf.append(String.valueOf(this.toString(seconds)) + "S");
            }
        }
        return buf.toString();
    }

    private String toString(BigDecimal bd) {
        StringBuffer buf;
        String intString = bd.unscaledValue().toString();
        int scale = bd.scale();
        if (scale == 0) {
            return intString;
        }
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return "0." + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append("0.");
            int i = 0;
            while (i < -insertionPoint) {
                buf.append('0');
                ++i;
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    private static long getCalendarTimeInMillis(Calendar cal) {
        return cal.getTime().getTime();
    }
}

