/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.dv.xs;

import mf.org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import mf.org.apache.xerces.impl.dv.ValidationContext;
import mf.org.apache.xerces.impl.dv.util.ByteListImpl;
import mf.org.apache.xerces.impl.dv.util.HexBin;
import mf.org.apache.xerces.impl.dv.xs.TypeValidator;

public class HexBinaryDV
extends TypeValidator {
    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context) throws InvalidDatatypeValueException {
        byte[] decoded = HexBin.decode(content);
        if (decoded == null) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "hexBinary"});
        }
        return new XHex(decoded);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XHex)value).getLength();
    }

    private static final class XHex
    extends ByteListImpl {
        public XHex(byte[] data) {
            super(data);
        }

        @Override
        public synchronized String toString() {
            if (this.canonical == null) {
                this.canonical = HexBin.encode(this.data);
            }
            return this.canonical;
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof XHex)) {
                return false;
            }
            int len = this.data.length;
            byte[] odata = ((XHex)obj).data;
            if (len != odata.length) {
                return false;
            }
            int i = 0;
            while (i < len) {
                if (this.data[i] != odata[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            int i = 0;
            while (i < this.data.length) {
                hash = hash * 37 + (this.data[i] & 0xFF);
                ++i;
            }
            return hash;
        }
    }
}

