/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xpath.regex;

final class CaseInsensitiveMap {
    private static int CHUNK_SHIFT = 10;
    private static int CHUNK_SIZE = 1 << CHUNK_SHIFT;
    private static int CHUNK_MASK = CHUNK_SIZE - 1;
    private static int INITIAL_CHUNK_COUNT = 64;
    private static int[][][] caseInsensitiveMap;
    private static int LOWER_CASE_MATCH;
    private static int UPPER_CASE_MATCH;

    static {
        LOWER_CASE_MATCH = 1;
        UPPER_CASE_MATCH = 2;
        CaseInsensitiveMap.buildCaseInsensitiveMap();
    }

    CaseInsensitiveMap() {
    }

    public static int[] get(int codePoint) {
        return codePoint < 65536 ? CaseInsensitiveMap.getMapping(codePoint) : null;
    }

    private static int[] getMapping(int codePoint) {
        int chunk = codePoint >>> CHUNK_SHIFT;
        int offset = codePoint & CHUNK_MASK;
        return caseInsensitiveMap[chunk][offset];
    }

    private static void buildCaseInsensitiveMap() {
        caseInsensitiveMap = new int[INITIAL_CHUNK_COUNT][CHUNK_SIZE][];
        int i = 0;
        while (i < 65536) {
            char uc;
            int lc = Character.toLowerCase((char)i);
            if (lc != (uc = Character.toUpperCase((char)i)) || lc != i) {
                int[] map = new int[2];
                int index = 0;
                if (lc != i) {
                    map[index++] = lc;
                    map[index++] = LOWER_CASE_MATCH;
                    int[] lcMap = CaseInsensitiveMap.getMapping(lc);
                    if (lcMap != null) {
                        map = CaseInsensitiveMap.updateMap(i, map, lc, lcMap, LOWER_CASE_MATCH);
                    }
                }
                if (uc != i) {
                    if (index == map.length) {
                        map = CaseInsensitiveMap.expandMap(map, 2);
                    }
                    map[index++] = uc;
                    map[index++] = UPPER_CASE_MATCH;
                    int[] ucMap = CaseInsensitiveMap.getMapping(uc);
                    if (ucMap != null) {
                        map = CaseInsensitiveMap.updateMap(i, map, uc, ucMap, UPPER_CASE_MATCH);
                    }
                }
                CaseInsensitiveMap.set(i, map);
            }
            ++i;
        }
    }

    private static int[] expandMap(int[] srcMap, int expandBy) {
        int oldLen = srcMap.length;
        int[] newMap = new int[oldLen + expandBy];
        System.arraycopy(srcMap, 0, newMap, 0, oldLen);
        return newMap;
    }

    private static void set(int codePoint, int[] map) {
        int chunk = codePoint >>> CHUNK_SHIFT;
        int offset = codePoint & CHUNK_MASK;
        CaseInsensitiveMap.caseInsensitiveMap[chunk][offset] = map;
    }

    private static int[] updateMap(int codePoint, int[] codePointMap, int ciCodePoint, int[] ciCodePointMap, int matchType) {
        int i = 0;
        while (i < ciCodePointMap.length) {
            int c = ciCodePointMap[i];
            int[] cMap = CaseInsensitiveMap.getMapping(c);
            if (cMap != null && CaseInsensitiveMap.contains(cMap, ciCodePoint, matchType)) {
                if (!CaseInsensitiveMap.contains(cMap, codePoint)) {
                    cMap = CaseInsensitiveMap.expandAndAdd(cMap, codePoint, matchType);
                    CaseInsensitiveMap.set(c, cMap);
                }
                if (!CaseInsensitiveMap.contains(codePointMap, c)) {
                    codePointMap = CaseInsensitiveMap.expandAndAdd(codePointMap, c, matchType);
                }
            }
            i += 2;
        }
        if (!CaseInsensitiveMap.contains(ciCodePointMap, codePoint)) {
            ciCodePointMap = CaseInsensitiveMap.expandAndAdd(ciCodePointMap, codePoint, matchType);
            CaseInsensitiveMap.set(ciCodePoint, ciCodePointMap);
        }
        return codePointMap;
    }

    private static boolean contains(int[] map, int codePoint) {
        int i = 0;
        while (i < map.length) {
            if (map[i] == codePoint) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private static boolean contains(int[] map, int codePoint, int matchType) {
        int i = 0;
        while (i < map.length) {
            if (map[i] == codePoint && map[i + 1] == matchType) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    private static int[] expandAndAdd(int[] srcMap, int codePoint, int matchType) {
        int oldLen = srcMap.length;
        int[] newMap = new int[oldLen + 2];
        System.arraycopy(srcMap, 0, newMap, 0, oldLen);
        newMap[oldLen] = codePoint;
        newMap[oldLen + 1] = matchType;
        return newMap;
    }
}

