/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs.models;

import java.util.HashMap;
import java.util.Vector;
import mf.org.apache.xerces.impl.dtd.models.CMNode;
import mf.org.apache.xerces.impl.dtd.models.CMStateSet;
import mf.org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import mf.org.apache.xerces.impl.xs.XMLSchemaException;
import mf.org.apache.xerces.impl.xs.XSConstraints;
import mf.org.apache.xerces.impl.xs.XSElementDecl;
import mf.org.apache.xerces.impl.xs.XSWildcardDecl;
import mf.org.apache.xerces.impl.xs.models.XSCMBinOp;
import mf.org.apache.xerces.impl.xs.models.XSCMLeaf;
import mf.org.apache.xerces.impl.xs.models.XSCMRepeatingLeaf;
import mf.org.apache.xerces.impl.xs.models.XSCMUniOp;
import mf.org.apache.xerces.impl.xs.models.XSCMValidator;
import mf.org.apache.xerces.xni.QName;

public class XSDFACM
implements XSCMValidator {
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VALIDATE_CONTENT = false;
    private Object[] fElemMap = null;
    private int[] fElemMapType = null;
    private int[] fElemMapId = null;
    private int fElemMapSize = 0;
    private boolean[] fFinalStateFlags = null;
    private CMStateSet[] fFollowList = null;
    private CMNode fHeadNode = null;
    private int fLeafCount = 0;
    private XSCMLeaf[] fLeafList = null;
    private int[] fLeafListType = null;
    private int[][] fTransTable = null;
    private Occurence[] fCountingStates = null;
    private int fTransTableSize = 0;
    private boolean fIsCompactedForUPA;
    private static long time = 0L;

    public XSDFACM(CMNode syntaxTree, int leafCount) {
        this.fLeafCount = leafCount;
        this.fIsCompactedForUPA = syntaxTree.isCompactedForUPA();
        this.buildDFA(syntaxTree);
    }

    public boolean isFinalState(int state) {
        return state < 0 ? false : this.fFinalStateFlags[state];
    }

    @Override
    public Object oneTransition(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler) {
        int curState = state[0];
        if (curState == -1 || curState == -2) {
            if (curState == -1) {
                state[0] = -2;
            }
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        int nextState = 0;
        int elemIndex = 0;
        Object matchingDecl = null;
        while (elemIndex < this.fElemMapSize) {
            nextState = this.fTransTable[curState][elemIndex];
            if (nextState != -1) {
                int type = this.fElemMapType[elemIndex];
                if (type == 1) {
                    matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                    if (matchingDecl != null) {
                        break;
                    }
                } else if (type == 2 && ((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) {
                    matchingDecl = this.fElemMap[elemIndex];
                    break;
                }
            }
            ++elemIndex;
        }
        if (elemIndex == this.fElemMapSize) {
            state[1] = state[0];
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        if (this.fCountingStates != null) {
            Occurence o = this.fCountingStates[curState];
            if (o != null) {
                if (curState == nextState) {
                    state[2] = state[2] + 1;
                    if (state[2] > o.maxOccurs && o.maxOccurs != -1) {
                        return this.findMatchingDecl(curElem, state, subGroupHandler, elemIndex);
                    }
                } else {
                    if (state[2] < o.minOccurs) {
                        state[1] = state[0];
                        state[0] = -1;
                        return this.findMatchingDecl(curElem, subGroupHandler);
                    }
                    o = this.fCountingStates[nextState];
                    if (o != null) {
                        state[2] = elemIndex == o.elemIndex ? 1 : 0;
                    }
                }
            } else {
                o = this.fCountingStates[nextState];
                if (o != null) {
                    state[2] = elemIndex == o.elemIndex ? 1 : 0;
                }
            }
        }
        state[0] = nextState;
        return matchingDecl;
    }

    Object findMatchingDecl(QName curElem, SubstitutionGroupHandler subGroupHandler) {
        XSElementDecl matchingDecl = null;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl != null) {
                    return matchingDecl;
                }
            } else if (type == 2 && ((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) {
                return this.fElemMap[elemIndex];
            }
            ++elemIndex;
        }
        return null;
    }

    Object findMatchingDecl(QName curElem, int[] state, SubstitutionGroupHandler subGroupHandler, int elemIndex) {
        int curState = state[0];
        int nextState = 0;
        Object matchingDecl = null;
        while (++elemIndex < this.fElemMapSize) {
            nextState = this.fTransTable[curState][elemIndex];
            if (nextState == -1) continue;
            int type = this.fElemMapType[elemIndex];
            if (type == 1) {
                matchingDecl = subGroupHandler.getMatchingElemDecl(curElem, (XSElementDecl)this.fElemMap[elemIndex]);
                if (matchingDecl == null) continue;
                break;
            }
            if (type != 2 || !((XSWildcardDecl)this.fElemMap[elemIndex]).allowNamespace(curElem.uri)) continue;
            matchingDecl = this.fElemMap[elemIndex];
            break;
        }
        if (elemIndex == this.fElemMapSize) {
            state[1] = state[0];
            state[0] = -1;
            return this.findMatchingDecl(curElem, subGroupHandler);
        }
        state[0] = nextState;
        Occurence o = this.fCountingStates[nextState];
        if (o != null) {
            state[2] = elemIndex == o.elemIndex ? 1 : 0;
        }
        return matchingDecl;
    }

    @Override
    public int[] startContentModel() {
        return new int[3];
    }

    @Override
    public boolean endContentModel(int[] state) {
        int curState = state[0];
        if (this.fFinalStateFlags[curState]) {
            Occurence o;
            return this.fCountingStates == null || (o = this.fCountingStates[curState]) == null || state[2] >= o.minOccurs;
        }
        return false;
    }

    private void buildDFA(CMNode syntaxTree) {
        int EOCPos = this.fLeafCount;
        XSCMLeaf nodeEOC = new XSCMLeaf(1, null, -1, this.fLeafCount++);
        this.fHeadNode = new XSCMBinOp(102, syntaxTree, nodeEOC);
        this.fLeafList = new XSCMLeaf[this.fLeafCount];
        this.fLeafListType = new int[this.fLeafCount];
        this.postTreeBuildInit(this.fHeadNode);
        this.fFollowList = new CMStateSet[this.fLeafCount];
        int index = 0;
        while (index < this.fLeafCount) {
            this.fFollowList[index] = new CMStateSet(this.fLeafCount);
            ++index;
        }
        this.calcFollowList(this.fHeadNode);
        this.fElemMap = new Object[this.fLeafCount];
        this.fElemMapType = new int[this.fLeafCount];
        this.fElemMapId = new int[this.fLeafCount];
        this.fElemMapSize = 0;
        Occurence[] elemOccurenceMap = null;
        int outIndex = 0;
        while (outIndex < this.fLeafCount) {
            this.fElemMap[outIndex] = null;
            int inIndex = 0;
            int id = this.fLeafList[outIndex].getParticleId();
            while (inIndex < this.fElemMapSize) {
                if (id == this.fElemMapId[inIndex]) break;
                ++inIndex;
            }
            if (inIndex == this.fElemMapSize) {
                XSCMLeaf leaf = this.fLeafList[outIndex];
                this.fElemMap[this.fElemMapSize] = leaf.getLeaf();
                if (leaf instanceof XSCMRepeatingLeaf) {
                    if (elemOccurenceMap == null) {
                        elemOccurenceMap = new Occurence[this.fLeafCount];
                    }
                    elemOccurenceMap[this.fElemMapSize] = new Occurence((XSCMRepeatingLeaf)leaf, this.fElemMapSize);
                }
                this.fElemMapType[this.fElemMapSize] = this.fLeafListType[outIndex];
                this.fElemMapId[this.fElemMapSize] = id;
                ++this.fElemMapSize;
            }
            ++outIndex;
        }
        --this.fElemMapSize;
        int[] fLeafSorter = new int[this.fLeafCount + this.fElemMapSize];
        int fSortCount = 0;
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int id = this.fElemMapId[elemIndex];
            int leafIndex = 0;
            while (leafIndex < this.fLeafCount) {
                if (id == this.fLeafList[leafIndex].getParticleId()) {
                    fLeafSorter[fSortCount++] = leafIndex;
                }
                ++leafIndex;
            }
            fLeafSorter[fSortCount++] = -1;
            ++elemIndex;
        }
        int curArraySize = this.fLeafCount * 4;
        CMStateSet[] statesToDo = new CMStateSet[curArraySize];
        this.fFinalStateFlags = new boolean[curArraySize];
        this.fTransTable = new int[curArraySize][];
        CMStateSet setT = this.fHeadNode.firstPos();
        int unmarkedState = 0;
        int curState = 0;
        this.fTransTable[curState] = this.makeDefStateList();
        statesToDo[curState] = setT;
        ++curState;
        HashMap<CMStateSet, Integer> stateTable = new HashMap<CMStateSet, Integer>();
        while (unmarkedState < curState) {
            setT = statesToDo[unmarkedState];
            int[] transEntry = this.fTransTable[unmarkedState];
            this.fFinalStateFlags[unmarkedState] = setT.getBit(EOCPos);
            ++unmarkedState;
            CMStateSet newSet = null;
            int sorterIndex = 0;
            int elemIndex2 = 0;
            while (elemIndex2 < this.fElemMapSize) {
                if (newSet == null) {
                    newSet = new CMStateSet(this.fLeafCount);
                } else {
                    newSet.zeroBits();
                }
                int leafIndex = fLeafSorter[sorterIndex++];
                while (leafIndex != -1) {
                    if (setT.getBit(leafIndex)) {
                        newSet.union(this.fFollowList[leafIndex]);
                    }
                    leafIndex = fLeafSorter[sorterIndex++];
                }
                if (!newSet.isEmpty()) {
                    int stateIndex;
                    Integer stateObj = (Integer)stateTable.get(newSet);
                    int n = stateIndex = stateObj == null ? curState : stateObj;
                    if (stateIndex == curState) {
                        statesToDo[curState] = newSet;
                        this.fTransTable[curState] = this.makeDefStateList();
                        stateTable.put(newSet, new Integer(curState));
                        ++curState;
                        newSet = null;
                    }
                    transEntry[elemIndex2] = stateIndex;
                    if (curState == curArraySize) {
                        int newSize = (int)((double)curArraySize * 1.5);
                        CMStateSet[] newToDo = new CMStateSet[newSize];
                        boolean[] newFinalFlags = new boolean[newSize];
                        int[][] newTransTable = new int[newSize][];
                        System.arraycopy(statesToDo, 0, newToDo, 0, curArraySize);
                        System.arraycopy(this.fFinalStateFlags, 0, newFinalFlags, 0, curArraySize);
                        System.arraycopy(this.fTransTable, 0, newTransTable, 0, curArraySize);
                        curArraySize = newSize;
                        statesToDo = newToDo;
                        this.fFinalStateFlags = newFinalFlags;
                        this.fTransTable = newTransTable;
                    }
                }
                ++elemIndex2;
            }
        }
        if (elemOccurenceMap != null) {
            this.fCountingStates = new Occurence[curState];
            int i = 0;
            while (i < curState) {
                int[] transitions = this.fTransTable[i];
                int j = 0;
                while (j < transitions.length) {
                    if (i == transitions[j]) {
                        this.fCountingStates[i] = elemOccurenceMap[j];
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.fHeadNode = null;
        this.fLeafList = null;
        this.fFollowList = null;
        this.fLeafListType = null;
        this.fElemMapId = null;
    }

    private void calcFollowList(CMNode nodeCur) {
        if (nodeCur.type() == 101) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 102) {
            this.calcFollowList(((XSCMBinOp)nodeCur).getLeft());
            this.calcFollowList(((XSCMBinOp)nodeCur).getRight());
            CMStateSet last = ((XSCMBinOp)nodeCur).getLeft().lastPos();
            CMStateSet first = ((XSCMBinOp)nodeCur).getRight().firstPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
            CMStateSet first = nodeCur.firstPos();
            CMStateSet last = nodeCur.lastPos();
            int index = 0;
            while (index < this.fLeafCount) {
                if (last.getBit(index)) {
                    this.fFollowList[index].union(first);
                }
                ++index;
            }
        } else if (nodeCur.type() == 5) {
            this.calcFollowList(((XSCMUniOp)nodeCur).getChild());
        }
    }

    private void dumpTree(CMNode nodeCur, int level) {
        int index = 0;
        while (index < level) {
            System.out.print("   ");
            ++index;
        }
        int type = nodeCur.type();
        switch (type) {
            case 101: 
            case 102: {
                if (type == 101) {
                    System.out.print("Choice Node ");
                } else {
                    System.out.print("Seq Node ");
                }
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMBinOp)nodeCur).getLeft(), level + 1);
                this.dumpTree(((XSCMBinOp)nodeCur).getRight(), level + 1);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                System.out.print("Rep Node ");
                if (nodeCur.isNullable()) {
                    System.out.print("Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                this.dumpTree(((XSCMUniOp)nodeCur).getChild(), level + 1);
                break;
            }
            case 1: {
                System.out.print("Leaf: (pos=" + ((XSCMLeaf)nodeCur).getPosition() + "), " + "(elemIndex=" + ((XSCMLeaf)nodeCur).getLeaf() + ") ");
                if (nodeCur.isNullable()) {
                    System.out.print(" Nullable ");
                }
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            case 2: {
                System.out.print("Any Node: ");
                System.out.print("firstPos=");
                System.out.print(nodeCur.firstPos().toString());
                System.out.print(" lastPos=");
                System.out.println(nodeCur.lastPos().toString());
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_NIICM");
            }
        }
    }

    private int[] makeDefStateList() {
        int[] retArray = new int[this.fElemMapSize];
        int index = 0;
        while (index < this.fElemMapSize) {
            retArray[index] = -1;
            ++index;
        }
        return retArray;
    }

    private void postTreeBuildInit(CMNode nodeCur) throws RuntimeException {
        nodeCur.setMaxStates(this.fLeafCount);
        XSCMLeaf leaf = null;
        int pos = 0;
        if (nodeCur.type() == 2) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 2;
        } else if (nodeCur.type() == 101 || nodeCur.type() == 102) {
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getLeft());
            this.postTreeBuildInit(((XSCMBinOp)nodeCur).getRight());
        } else if (nodeCur.type() == 4 || nodeCur.type() == 6 || nodeCur.type() == 5) {
            this.postTreeBuildInit(((XSCMUniOp)nodeCur).getChild());
        } else if (nodeCur.type() == 1) {
            leaf = (XSCMLeaf)nodeCur;
            pos = leaf.getPosition();
            this.fLeafList[pos] = leaf;
            this.fLeafListType[pos] = 1;
        } else {
            throw new RuntimeException("ImplementationMessages.VAL_NIICM");
        }
    }

    @Override
    public boolean checkUniqueParticleAttribution(SubstitutionGroupHandler subGroupHandler) throws XMLSchemaException {
        int j;
        byte[][] conflictTable = new byte[this.fElemMapSize][this.fElemMapSize];
        int i = 0;
        while (i < this.fTransTable.length && this.fTransTable[i] != null) {
            j = 0;
            while (j < this.fElemMapSize) {
                int k = j + 1;
                while (k < this.fElemMapSize) {
                    if (this.fTransTable[i][j] != -1 && this.fTransTable[i][k] != -1 && conflictTable[j][k] == 0) {
                        Occurence o;
                        conflictTable[j][k] = XSConstraints.overlapUPA(this.fElemMap[j], this.fElemMap[k], subGroupHandler) ? (this.fCountingStates != null && (o = this.fCountingStates[i]) != null && this.fTransTable[i][j] == i ^ this.fTransTable[i][k] == i && o.minOccurs == o.maxOccurs ? -1 : 1) : -1;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.fElemMapSize) {
            j = 0;
            while (j < this.fElemMapSize) {
                if (conflictTable[i][j] == 1) {
                    throw new XMLSchemaException("cos-nonambig", new Object[]{this.fElemMap[i].toString(), this.fElemMap[j].toString()});
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.fElemMapSize) {
            if (this.fElemMapType[i] == 2) {
                XSWildcardDecl wildcard = (XSWildcardDecl)this.fElemMap[i];
                if (wildcard.fType == 3 || wildcard.fType == 2) {
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    @Override
    public Vector whatCanGoHere(int[] state) {
        int curState = state[0];
        if (curState < 0) {
            curState = state[1];
        }
        Occurence o = this.fCountingStates != null ? this.fCountingStates[curState] : null;
        int count = state[2];
        Vector<Object> ret = new Vector<Object>();
        int elemIndex = 0;
        while (elemIndex < this.fElemMapSize) {
            int nextState = this.fTransTable[curState][elemIndex];
            if (!(nextState == -1 || o != null && (curState == nextState ? count >= o.maxOccurs && o.maxOccurs != -1 : count < o.minOccurs))) {
                ret.addElement(this.fElemMap[elemIndex]);
            }
            ++elemIndex;
        }
        return ret;
    }

    @Override
    public int[] occurenceInfo(int[] state) {
        if (this.fCountingStates != null) {
            Occurence o;
            int curState = state[0];
            if (curState < 0) {
                curState = state[1];
            }
            if ((o = this.fCountingStates[curState]) != null) {
                int[] occurenceInfo = new int[]{o.minOccurs, o.maxOccurs, state[2], o.elemIndex};
                return occurenceInfo;
            }
        }
        return null;
    }

    @Override
    public String getTermName(int termId) {
        Object term = this.fElemMap[termId];
        return term != null ? term.toString() : null;
    }

    @Override
    public boolean isCompactedForUPA() {
        return this.fIsCompactedForUPA;
    }

    static final class Occurence {
        final int minOccurs;
        final int maxOccurs;
        final int elemIndex;

        public Occurence(XSCMRepeatingLeaf leaf, int elemIndex) {
            this.minOccurs = leaf.getMinOccurs();
            this.maxOccurs = leaf.getMaxOccurs();
            this.elemIndex = elemIndex;
        }

        public String toString() {
            return "minOccurs=" + this.minOccurs + ";maxOccurs=" + (this.maxOccurs != -1 ? Integer.toString(this.maxOccurs) : "unbounded");
        }
    }
}

