/*
 * Decompiled with CFR 0.152.
 */
package mf.org.apache.xerces.impl.xs.opti;

import java.util.ArrayList;
import java.util.Enumeration;
import mf.org.apache.xerces.impl.xs.opti.AttrImpl;
import mf.org.apache.xerces.impl.xs.opti.DefaultDocument;
import mf.org.apache.xerces.impl.xs.opti.ElementImpl;
import mf.org.apache.xerces.impl.xs.opti.NodeImpl;
import mf.org.apache.xerces.impl.xs.opti.SchemaDOMImplementation;
import mf.org.apache.xerces.util.XMLSymbols;
import mf.org.apache.xerces.xni.NamespaceContext;
import mf.org.apache.xerces.xni.QName;
import mf.org.apache.xerces.xni.XMLAttributes;
import mf.org.apache.xerces.xni.XMLString;
import mf.org.w3c.dom.Attr;
import mf.org.w3c.dom.DOMImplementation;
import mf.org.w3c.dom.Element;
import mf.org.w3c.dom.NamedNodeMap;
import mf.org.w3c.dom.Node;

public class SchemaDOM
extends DefaultDocument {
    static final int relationsRowResizeFactor = 15;
    static final int relationsColResizeFactor = 10;
    NodeImpl[][] relations;
    ElementImpl parent;
    int currLoc;
    int nextFreeLoc;
    boolean hidden;
    boolean inCDATA;
    private StringBuffer fAnnotationBuffer = null;

    public SchemaDOM() {
        this.reset();
    }

    public ElementImpl startElement(QName element, XMLAttributes attributes, int line, int column, int offset) {
        ElementImpl node = new ElementImpl(line, column, offset);
        this.processElement(element, attributes, node);
        this.parent = node;
        return node;
    }

    public ElementImpl emptyElement(QName element, XMLAttributes attributes, int line, int column, int offset) {
        ElementImpl node = new ElementImpl(line, column, offset);
        this.processElement(element, attributes, node);
        return node;
    }

    public ElementImpl startElement(QName element, XMLAttributes attributes, int line, int column) {
        return this.startElement(element, attributes, line, column, -1);
    }

    public ElementImpl emptyElement(QName element, XMLAttributes attributes, int line, int column) {
        return this.emptyElement(element, attributes, line, column, -1);
    }

    private void processElement(QName element, XMLAttributes attributes, ElementImpl node) {
        node.prefix = element.prefix;
        node.localpart = element.localpart;
        node.rawname = element.rawname;
        node.uri = element.uri;
        node.schemaDOM = this;
        Attr[] attrs = new Attr[attributes.getLength()];
        int i = 0;
        while (i < attributes.getLength()) {
            attrs[i] = new AttrImpl(node, attributes.getPrefix(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getURI(i), attributes.getValue(i));
            ++i;
        }
        node.attrs = attrs;
        if (this.nextFreeLoc == this.relations.length) {
            this.resizeRelations();
        }
        if (this.relations[this.currLoc][0] != this.parent) {
            this.relations[this.nextFreeLoc][0] = this.parent;
            this.currLoc = this.nextFreeLoc++;
        }
        boolean foundPlace = false;
        int i2 = 1;
        i2 = 1;
        while (i2 < this.relations[this.currLoc].length) {
            if (this.relations[this.currLoc][i2] == null) {
                foundPlace = true;
                break;
            }
            ++i2;
        }
        if (!foundPlace) {
            this.resizeRelations(this.currLoc);
        }
        this.relations[this.currLoc][i2] = node;
        this.parent.parentRow = this.currLoc;
        node.row = this.currLoc;
        node.col = i2;
    }

    public void endElement() {
        this.currLoc = this.parent.row;
        this.parent = (ElementImpl)this.relations[this.currLoc][0];
    }

    void comment(XMLString text) {
        this.fAnnotationBuffer.append("<!--");
        if (text.length > 0) {
            this.fAnnotationBuffer.append(text.ch, text.offset, text.length);
        }
        this.fAnnotationBuffer.append("-->");
    }

    void processingInstruction(String target, XMLString data) {
        this.fAnnotationBuffer.append("<?").append(target);
        if (data.length > 0) {
            this.fAnnotationBuffer.append(' ').append(data.ch, data.offset, data.length);
        }
        this.fAnnotationBuffer.append("?>");
    }

    void characters(XMLString text) {
        if (!this.inCDATA) {
            StringBuffer annotationBuffer = this.fAnnotationBuffer;
            int i = text.offset;
            while (i < text.offset + text.length) {
                char ch = text.ch[i];
                if (ch == '&') {
                    annotationBuffer.append("&amp;");
                } else if (ch == '<') {
                    annotationBuffer.append("&lt;");
                } else if (ch == '>') {
                    annotationBuffer.append("&gt;");
                } else if (ch == '\r') {
                    annotationBuffer.append("&#xD;");
                } else {
                    annotationBuffer.append(ch);
                }
                ++i;
            }
        } else {
            this.fAnnotationBuffer.append(text.ch, text.offset, text.length);
        }
    }

    void charactersRaw(String text) {
        this.fAnnotationBuffer.append(text);
    }

    void endAnnotation(QName elemName, ElementImpl annotation) {
        this.fAnnotationBuffer.append("\n</").append(elemName.rawname).append(">");
        annotation.fAnnotation = this.fAnnotationBuffer.toString();
        this.fAnnotationBuffer = null;
    }

    void endAnnotationElement(QName elemName) {
        this.endAnnotationElement(elemName.rawname);
    }

    void endAnnotationElement(String elemRawName) {
        this.fAnnotationBuffer.append("</").append(elemRawName).append(">");
    }

    void endSyntheticAnnotationElement(QName elemName, boolean complete) {
        this.endSyntheticAnnotationElement(elemName.rawname, complete);
    }

    void endSyntheticAnnotationElement(String elemRawName, boolean complete) {
        if (complete) {
            this.fAnnotationBuffer.append("\n</").append(elemRawName).append(">");
            this.parent.fSyntheticAnnotation = this.fAnnotationBuffer.toString();
            this.fAnnotationBuffer = null;
        } else {
            this.fAnnotationBuffer.append("</").append(elemRawName).append(">");
        }
    }

    void startAnnotationCDATA() {
        this.inCDATA = true;
        this.fAnnotationBuffer.append("<![CDATA[");
    }

    void endAnnotationCDATA() {
        this.fAnnotationBuffer.append("]]>");
        this.inCDATA = false;
    }

    private void resizeRelations() {
        NodeImpl[][] temp = new NodeImpl[this.relations.length + 15][];
        System.arraycopy(this.relations, 0, temp, 0, this.relations.length);
        int i = this.relations.length;
        while (i < temp.length) {
            temp[i] = new NodeImpl[10];
            ++i;
        }
        this.relations = temp;
    }

    private void resizeRelations(int i) {
        NodeImpl[] temp = new NodeImpl[this.relations[i].length + 10];
        System.arraycopy(this.relations[i], 0, temp, 0, this.relations[i].length);
        this.relations[i] = temp;
    }

    public void reset() {
        int i;
        if (this.relations != null) {
            i = 0;
            while (i < this.relations.length) {
                int j = 0;
                while (j < this.relations[i].length) {
                    this.relations[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        this.relations = new NodeImpl[15][];
        this.parent = new ElementImpl(0, 0, 0);
        this.parent.rawname = "DOCUMENT_NODE";
        this.currLoc = 0;
        this.nextFreeLoc = 1;
        this.inCDATA = false;
        i = 0;
        while (i < 15) {
            this.relations[i] = new NodeImpl[10];
            ++i;
        }
        this.relations[this.currLoc][0] = this.parent;
    }

    public void printDOM() {
    }

    public static void traverse(Node node, int depth) {
        SchemaDOM.indent(depth);
        System.out.print("<" + node.getNodeName());
        if (node.hasAttributes()) {
            NamedNodeMap attrs = node.getAttributes();
            int i = 0;
            while (i < attrs.getLength()) {
                System.out.print("  " + ((Attr)attrs.item(i)).getName() + "=\"" + ((Attr)attrs.item(i)).getValue() + "\"");
                ++i;
            }
        }
        if (node.hasChildNodes()) {
            System.out.println(">");
            depth += 4;
            Node child = node.getFirstChild();
            while (child != null) {
                SchemaDOM.traverse(child, depth);
                child = child.getNextSibling();
            }
            SchemaDOM.indent(depth -= 4);
            System.out.println("</" + node.getNodeName() + ">");
        } else {
            System.out.println("/>");
        }
    }

    public static void indent(int amount) {
        int i = 0;
        while (i < amount) {
            System.out.print(' ');
            ++i;
        }
    }

    @Override
    public Element getDocumentElement() {
        return (ElementImpl)this.relations[0][1];
    }

    @Override
    public DOMImplementation getImplementation() {
        return SchemaDOMImplementation.getDOMImplementation();
    }

    void startAnnotation(QName elemName, XMLAttributes attributes, NamespaceContext namespaceContext) {
        this.startAnnotation(elemName.rawname, attributes, namespaceContext);
    }

    void startAnnotation(String elemRawName, XMLAttributes attributes, NamespaceContext namespaceContext) {
        if (this.fAnnotationBuffer == null) {
            this.fAnnotationBuffer = new StringBuffer(256);
        }
        this.fAnnotationBuffer.append("<").append(elemRawName).append(" ");
        ArrayList<String> namespaces = new ArrayList<String>();
        int i = 0;
        while (i < attributes.getLength()) {
            String aValue = attributes.getValue(i);
            String aPrefix = attributes.getPrefix(i);
            String aQName = attributes.getQName(i);
            if (aPrefix == XMLSymbols.PREFIX_XMLNS || aQName == XMLSymbols.PREFIX_XMLNS) {
                namespaces.add(aPrefix == XMLSymbols.PREFIX_XMLNS ? attributes.getLocalName(i) : XMLSymbols.EMPTY_STRING);
            }
            this.fAnnotationBuffer.append(aQName).append("=\"").append(SchemaDOM.processAttValue(aValue)).append("\" ");
            ++i;
        }
        Enumeration currPrefixes = namespaceContext.getAllPrefixes();
        while (currPrefixes.hasMoreElements()) {
            String prefix = (String)currPrefixes.nextElement();
            String uri = namespaceContext.getURI(prefix);
            if (uri == null) {
                uri = XMLSymbols.EMPTY_STRING;
            }
            if (namespaces.contains(prefix)) continue;
            if (prefix == XMLSymbols.EMPTY_STRING) {
                this.fAnnotationBuffer.append("xmlns").append("=\"").append(SchemaDOM.processAttValue(uri)).append("\" ");
                continue;
            }
            this.fAnnotationBuffer.append("xmlns:").append(prefix).append("=\"").append(SchemaDOM.processAttValue(uri)).append("\" ");
        }
        this.fAnnotationBuffer.append(">\n");
    }

    void startAnnotationElement(QName elemName, XMLAttributes attributes) {
        this.startAnnotationElement(elemName.rawname, attributes);
    }

    void startAnnotationElement(String elemRawName, XMLAttributes attributes) {
        this.fAnnotationBuffer.append("<").append(elemRawName);
        int i = 0;
        while (i < attributes.getLength()) {
            String aValue = attributes.getValue(i);
            this.fAnnotationBuffer.append(" ").append(attributes.getQName(i)).append("=\"").append(SchemaDOM.processAttValue(aValue)).append("\"");
            ++i;
        }
        this.fAnnotationBuffer.append(">");
    }

    private static String processAttValue(String original) {
        int length = original.length();
        int i = 0;
        while (i < length) {
            char currChar = original.charAt(i);
            if (currChar == '\"' || currChar == '<' || currChar == '&' || currChar == '\t' || currChar == '\n' || currChar == '\r') {
                return SchemaDOM.escapeAttValue(original, i);
            }
            ++i;
        }
        return original;
    }

    private static String escapeAttValue(String original, int from) {
        int length = original.length();
        StringBuffer newVal = new StringBuffer(length);
        newVal.append(original.substring(0, from));
        int i = from;
        while (i < length) {
            char currChar = original.charAt(i);
            if (currChar == '\"') {
                newVal.append("&quot;");
            } else if (currChar == '<') {
                newVal.append("&lt;");
            } else if (currChar == '&') {
                newVal.append("&amp;");
            } else if (currChar == '\t') {
                newVal.append("&#x9;");
            } else if (currChar == '\n') {
                newVal.append("&#xA;");
            } else if (currChar == '\r') {
                newVal.append("&#xD;");
            } else {
                newVal.append(currChar);
            }
            ++i;
        }
        return newVal.toString();
    }
}

