/* Copyright (c) 2010 Pierre LEVY androidsoft.org
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.androidsoft.games.utils.credits;

import android.graphics.Typeface;

/**
 *
 * @author Pierre Levy
 */
public class CreditsParams 
{

    private int appNameRes;
    private int appVersionRes;
    private int arrayCreditsRes;
    private int colorDefault;
    private int colorCategory;
    private int bitmapBackgroundRes;
    private int bitmapBackgroundLandscapeRes;
    private int spacingBeforeDefault;
    private int spacingAfterDefault;
    private int spacingBeforeCategory;
    private int spacingAfterCategory;
    private int textSizeDefault;
    private int textSizeCategory;
    private Typeface typefaceDefault;
    private Typeface typefaceCategory;

    /**
     * @return the appNameRes
     */
    public int getAppNameRes()
    {
        return appNameRes;
    }

    /**
     * @param appNameRes the appNameRes to set
     */
    public void setAppNameRes(int appNameRes)
    {
        this.appNameRes = appNameRes;
    }

    /**
     * @return the appVersionRes
     */
    public int getAppVersionRes()
    {
        return appVersionRes;
    }

    /**
     * @param appVersionRes the appVersionRes to set
     */
    public void setAppVersionRes(int appVersionRes)
    {
        this.appVersionRes = appVersionRes;
    }

    /**
     * @return the arrayCreditsRes
     */
    public int getArrayCreditsRes()
    {
        return arrayCreditsRes;
    }

    /**
     * @param arrayCreditsRes the arrayCreditsRes to set
     */
    public void setArrayCreditsRes(int arrayCreditsRes)
    {
        this.arrayCreditsRes = arrayCreditsRes;
    }

    /**
     * @return the colorDefault
     */
    public int getColorDefault()
    {
        return colorDefault;
    }

    /**
     * @param colorDefault the colorDefault to set
     */
    public void setColorDefault(int colorDefault)
    {
        this.colorDefault = colorDefault;
    }

    /**
     * @return the colorCategory
     */
    public int getColorCategory()
    {
        return colorCategory;
    }

    /**
     * @param colorCategory the colorCategory to set
     */
    public void setColorCategory(int colorCategory)
    {
        this.colorCategory = colorCategory;
    }

    /**
     * @return the bitmapBackgroundRes
     */
    public int getBitmapBackgroundRes()
    {
        return bitmapBackgroundRes;
    }

    /**
     * @param bitmapBackgroundRes the bitmapBackgroundRes to set
     */
    public void setBitmapBackgroundRes(int bitmapBackgroundRes)
    {
        this.bitmapBackgroundRes = bitmapBackgroundRes;
    }

    /**
     * @return the bitmapBackgroundLandscapeRes
     */
    public int getBitmapBackgroundLandscapeRes()
    {
        return bitmapBackgroundLandscapeRes;
    }

    /**
     * @param bitmapBackgroundLandscapeRes the bitmapBackgroundLandscapeRes to set
     */
    public void setBitmapBackgroundLandscapeRes(int bitmapBackgroundLandscapeRes)
    {
        this.bitmapBackgroundLandscapeRes = bitmapBackgroundLandscapeRes;
    }

    /**
     * @return the spacingBeforeDefault
     */
    public int getSpacingBeforeDefault()
    {
        return spacingBeforeDefault;
    }

    /**
     * @param spacingBeforeDefault the spacingBeforeDefault to set
     */
    public void setSpacingBeforeDefault(int spacingBeforeDefault)
    {
        this.spacingBeforeDefault = spacingBeforeDefault;
    }

    /**
     * @return the spacingAfterDefault
     */
    public int getSpacingAfterDefault()
    {
        return spacingAfterDefault;
    }

    /**
     * @param spacingAfterDefault the spacingAfterDefault to set
     */
    public void setSpacingAfterDefault(int spacingAfterDefault)
    {
        this.spacingAfterDefault = spacingAfterDefault;
    }

    /**
     * @return the spacingBeforeCategory
     */
    public int getSpacingBeforeCategory()
    {
        return spacingBeforeCategory;
    }

    /**
     * @param spacingBeforeCategory the spacingBeforeCategory to set
     */
    public void setSpacingBeforeCategory(int spacingBeforeCategory)
    {
        this.spacingBeforeCategory = spacingBeforeCategory;
    }

    /**
     * @return the spacingAfterCategory
     */
    public int getSpacingAfterCategory()
    {
        return spacingAfterCategory;
    }

    /**
     * @param spacingAfterCategory the spacingAfterCategory to set
     */
    public void setSpacingAfterCategory(int spacingAfterCategory)
    {
        this.spacingAfterCategory = spacingAfterCategory;
    }

    /**
     * @return the textSizeDefault
     */
    public int getTextSizeDefault()
    {
        return textSizeDefault;
    }

    /**
     * @param textSizeDefault the textSizeDefault to set
     */
    public void setTextSizeDefault(int textSizeDefault)
    {
        this.textSizeDefault = textSizeDefault;
    }

    /**
     * @return the textSizeCategory
     */
    public int getTextSizeCategory()
    {
        return textSizeCategory;
    }

    /**
     * @param textSizeCategory the textSizeCategory to set
     */
    public void setTextSizeCategory(int textSizeCategory)
    {
        this.textSizeCategory = textSizeCategory;
    }

    /**
     * @return the typefaceDefault
     */
    public Typeface getTypefaceDefault()
    {
        return typefaceDefault;
    }

    /**
     * @param typefaceDefault the typefaceDefault to set
     */
    public void setTypefaceDefault(Typeface typefaceDefault)
    {
        this.typefaceDefault = typefaceDefault;
    }

    /**
     * @return the typefaceCategory
     */
    public Typeface getTypefaceCategory()
    {
        return typefaceCategory;
    }

    /**
     * @param typefaceCategory the typefaceCategory to set
     */
    public void setTypefaceCategory(Typeface typefaceCategory)
    {
        this.typefaceCategory = typefaceCategory;
    }



}
