/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.util.Log;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.CrashMechanism;
import com.bugsense.trace.DefaultExceptionHandler;
import com.bugsense.trace.EventsMechanism;
import com.bugsense.trace.ExceptionCallback;
import com.bugsense.trace.G;
import com.bugsense.trace.PingsMechanism;
import com.bugsense.trace.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class BugSenseHandler {
    public static boolean I_WANT_TO_DEBUG = false;
    private static SharedPreferences preferences;
    private static SharedPreferences.Editor editor;
    private static ExceptionCallback exceptionCallback;
    private static boolean isSessionActive;
    static String locTicker;
    static String locTitle;
    static String locText;
    private static HashMap<String, String> crashExtraData;

    public static void initAndStartSession(final Context context, String string) {
        block9: {
            block8: {
                if (context == null) {
                    Log.e((String)G.TAG, (String)"Context is null!");
                    return;
                }
                if (string == null || string.length() < 8 || string.length() > 14) {
                    throw new IllegalArgumentException("Your BugSense API Key is invalid!");
                }
                G.API_KEY = string;
                BugSenseHandler.installHandler();
                G.PHONE_MODEL = Build.MODEL;
                G.ANDROID_VERSION = Build.VERSION.RELEASE;
                try {
                    PackageManager packageManager = context.getPackageManager();
                    PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
                    G.APP_VERSION = packageInfo.versionName;
                    G.APP_VERSIONCODE = String.valueOf(packageInfo.versionCode);
                    G.APP_PACKAGE = packageInfo.packageName;
                }
                catch (Exception exception) {
                    Log.e((String)G.TAG, (String)"Error collecting information about the package!");
                    if (!I_WANT_TO_DEBUG) break block8;
                    exception.printStackTrace();
                }
            }
            Utils.setProperties(context);
            try {
                G.FILES_PATH = context.getFilesDir().getAbsolutePath();
            }
            catch (Exception exception) {
                if (!I_WANT_TO_DEBUG) break block9;
                exception.printStackTrace();
            }
        }
        if (G.FILES_PATH == null) {
            Log.e((String)G.TAG, (String)"G.FILES_PATH GOT NULL!");
            return;
        }
        if (I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("Files Path set to: " + G.FILES_PATH));
        }
        G.HAS_ROOT = Utils.checkForRoot();
        new Thread(new Runnable(){

            @Override
            public void run() {
                block16: {
                    G.UID = Utils.manageUid(context);
                    if (!G.proxyEnabled) {
                        if (!G.ANALYTICS_URL.contains(G.API_KEY)) {
                            G.ANALYTICS_URL = G.ANALYTICS_URL + G.API_KEY + "/" + G.UID;
                        }
                    } else {
                        G.URL = "http://alt.bugsense.appspot.com/api/errors";
                        if (!G.ANALYTICS_URL.contains(G.API_KEY)) {
                            G.ANALYTICS_URL = "http://alt.bugsense.com/api/ticks/" + G.API_KEY + "/" + G.UID;
                        }
                    }
                    if (I_WANT_TO_DEBUG) {
                        Log.d((String)G.TAG, (String)("Crash     URL set to: " + G.URL));
                        Log.d((String)G.TAG, (String)("Analytics URL set to: " + G.ANALYTICS_URL));
                    }
                    PingsMechanism.transmitPingASync(0);
                    try {
                        preferences = context.getSharedPreferences(G.TAG, 0);
                        BugSenseHandler.editor = preferences.edit();
                        editor.putLong("lastping", System.currentTimeMillis()).commit();
                    }
                    catch (Exception exception) {
                        Log.e((String)G.TAG, (String)"Preferences are null!");
                        if (!I_WANT_TO_DEBUG) break block16;
                        exception.printStackTrace();
                    }
                }
                BugSenseHandler.flush(context);
                BugSenseHandler.startSession(context);
                File file = new File(G.FILES_PATH + "/" + "fixnotification");
                if (file != null && file.exists()) {
                    BufferedReader bufferedReader = null;
                    String string = "";
                    try {
                        bufferedReader = new BufferedReader(new FileReader(file.getAbsolutePath()));
                        if (bufferedReader != null) {
                            string = bufferedReader.readLine();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                    if (string != null && string.length() > 5) {
                        BugSense.showUpgradeNotification(context, string);
                    }
                }
            }
        }).start();
    }

    public static void sendDataOverWiFiOnly() {
        G.sendOnlyWiFi = true;
        if (I_WANT_TO_DEBUG) {
            Log.i((String)G.TAG, (String)"BugSense will send data only over WiFi. Please make sure you have the ACCESS_NETWORK_STATE permission.");
        }
    }

    public static int getTotalCrashesNum() {
        return Utils.getCrashCounter();
    }

    public static void clearTotalCrashesNum() {
        Utils.clearCrashCounter();
    }

    public static String getLastCrashID() {
        return Utils.getLastCrashID();
    }

    public static void setExceptionCallback(ExceptionCallback exceptionCallback) {
        BugSenseHandler.exceptionCallback = exceptionCallback;
    }

    protected static ExceptionCallback getCallback() {
        return exceptionCallback;
    }

    public static void startSession(Context context) {
        block4: {
            BugSenseHandler.installHandler();
            Utils.setProperties(context);
            if (!isSessionActive) {
                G.TIMESTAMP = System.currentTimeMillis();
                isSessionActive = true;
                try {
                    SharedPreferences sharedPreferences = context.getSharedPreferences(G.TAG, 0);
                    Long l = sharedPreferences.getLong("lastping", 0L);
                    if (l == 0L || System.currentTimeMillis() > l + 10000L) {
                        sharedPreferences.edit().putLong("lastping", System.currentTimeMillis()).commit();
                        PingsMechanism.savePing(0, "");
                    }
                }
                catch (NullPointerException nullPointerException) {
                    Log.e((String)G.TAG, (String)"StartSession Preferences are null!");
                    if (!I_WANT_TO_DEBUG) break block4;
                    nullPointerException.printStackTrace();
                }
            }
        }
    }

    public static void leaveBreadcrumb(String string) {
        if (G.breadcrumbs == null) {
            G.breadcrumbs = new ArrayList(16);
        }
        if (G.breadcrumbs.size() >= 16) {
            G.breadcrumbs.remove(0);
        }
        G.breadcrumbs.add(string);
        if (I_WANT_TO_DEBUG) {
            Log.i((String)G.TAG, (String)("BreadCrumb: " + string + " added."));
        }
    }

    public static void closeSession(Context context) {
        isSessionActive = false;
        PingsMechanism.savePing(1, "");
    }

    public static void sendEvent(String string) {
        EventsMechanism.saveEvent(string);
    }

    public static void setUserIdentifier(String string) {
        G.userIdentifier = string;
    }

    public static void flush(Context context) {
        if (G.sendOnlyWiFi) {
            if (G.IS_WIFI_ON == 1) {
                Log.i((String)G.TAG, (String)"Flushing...");
                PingsMechanism.getInstance().sendSavedPings();
                CrashMechanism.getInstance().sendSavedCrashes();
                EventsMechanism.getInstance().sendSavedEvents();
            }
        } else {
            Log.i((String)G.TAG, (String)"Flushing...");
            PingsMechanism.getInstance().sendSavedPings();
            CrashMechanism.getInstance().sendSavedCrashes();
            EventsMechanism.getInstance().sendSavedEvents();
        }
    }

    public static void sendExceptionMap(HashMap<String, String> hashMap, Exception exception) {
        block10: {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            if (G.API_KEY == null) {
                Log.e((String)G.TAG, (String)"Could not send: API Key is missing");
            } else {
                Log.i((String)G.TAG, (String)"Saving handled exception");
                exception.printStackTrace(printWriter);
                HashMap<String, String> hashMap2 = new HashMap<String, String>();
                if (hashMap != null) {
                    for (Map.Entry<String, String> entry : hashMap.entrySet()) {
                        hashMap2.put(entry.getKey(), Utils.exceedLimitString(entry.getValue()));
                    }
                }
                long l = 0L;
                try {
                    l = System.currentTimeMillis() - G.TIMESTAMP;
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    exception.printStackTrace(printWriter);
                    String string = "";
                    try {
                        string = CrashMechanism.createJSONFromCrash(((Object)stringWriter).toString(), G.IS_WIFI_ON, G.IS_MOBILENET_ON, G.IS_GPS_ON, G.SCREEN_PROPS, Utils.getTime(), BugSenseHandler.getCrashExtraData(), hashMap2, 0, l, null);
                    }
                    catch (Exception exception3) {
                        exception3.printStackTrace();
                    }
                    CrashMechanism.saveCrash(string, 0);
                }
                catch (Exception exception4) {
                    Log.e((String)G.TAG, (String)"Failed to save handled exception ");
                    if (!I_WANT_TO_DEBUG) break block10;
                    exception4.printStackTrace();
                }
            }
        }
    }

    public static void sendException(Exception exception) {
        HashMap<String, String> hashMap = new HashMap<String, String>(0);
        BugSenseHandler.sendExceptionMap(hashMap, exception);
    }

    public static void sendExceptionMessage(String string, String string2, Exception exception) {
        HashMap<String, String> hashMap = new HashMap<String, String>(1);
        if (string != null && string2 != null) {
            hashMap.put(string, Utils.exceedLimitString(string2));
        }
        BugSenseHandler.sendExceptionMap(hashMap, exception);
    }

    public static void setLogging(boolean bl) {
        G.SEND_LOG = bl;
    }

    public static void setLogging(int n) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
    }

    public static void setLogging(String string) {
        G.SEND_LOG = true;
        G.LOG_FILTER = string;
    }

    public static void setLogging(int n, String string) {
        G.SEND_LOG = true;
        G.LOG_LINES = n;
        G.LOG_FILTER = string;
    }

    private static void installHandler() {
        Log.i((String)G.TAG, (String)"Registering default exceptions handler");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (uncaughtExceptionHandler != null && I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("current handler class=" + uncaughtExceptionHandler.getClass().getName()));
        }
        if (!(uncaughtExceptionHandler instanceof DefaultExceptionHandler)) {
            Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler(uncaughtExceptionHandler));
        }
    }

    public static void setLocalizedNotification(String string, String string2, String string3) {
        locTicker = string;
        locTitle = string2;
        locText = string3;
    }

    public static HashMap<String, String> getCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        return crashExtraData;
    }

    public static void addCrashExtraData(String string, String string2) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.put(string, Utils.exceedLimitString(string2));
    }

    public static void addCrashExtraMap(HashMap<String, String> hashMap) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            crashExtraData.put(entry.getKey(), Utils.exceedLimitString(entry.getValue()));
        }
    }

    public static void removeCrashExtraData(String string) {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        }
        crashExtraData.remove(string);
    }

    public static void clearCrashExtraData() {
        if (crashExtraData == null) {
            crashExtraData = new HashMap();
        } else {
            crashExtraData.clear();
        }
    }

    public static void useProxy(boolean bl) {
        G.proxyEnabled = bl;
    }

    static {
        exceptionCallback = null;
        isSessionActive = false;
        locTicker = "";
        locTitle = "";
        locText = "";
        crashExtraData = new HashMap();
    }
}

