/*
 * Decompiled with CFR 0.152.
 */
package com.bugsense.trace;

import android.util.Log;
import com.bugsense.trace.BugSense;
import com.bugsense.trace.BugSenseHandler;
import com.bugsense.trace.G;
import com.bugsense.trace.Utils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.json.JSONException;
import org.json.JSONObject;

public final class CrashMechanism {
    private static final int MAX_CRASHES = 5;
    private static final int MAX_EXCEPTIONS = 8;
    public static final int HANDLEDEXCEPTION = 0;
    protected static final int CRASH = 1;
    static final String fixfilename = "fixnotification";
    private static volatile CrashMechanism instance;

    protected static CrashMechanism getInstance() {
        if (instance == null) {
            instance = new CrashMechanism();
        }
        return instance;
    }

    protected synchronized void sendSavedCrashes() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                File file;
                int n;
                int n2;
                File file2 = new File(G.FILES_PATH);
                if (!file2.exists()) {
                    file2.mkdir();
                }
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Crash_");
                    }
                };
                FilenameFilter filenameFilter2 = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return string.startsWith("Exception_");
                    }
                };
                String[] stringArray = file2.list(filenameFilter);
                String[] stringArray2 = file2.list(filenameFilter2);
                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                    Log.d((String)G.TAG, (String)("Crash List has: " + stringArray.length + " items"));
                    Log.d((String)G.TAG, (String)("HandledEx List has: " + stringArray2.length + " items"));
                }
                if ((n2 = 5) > stringArray.length) {
                    n2 = stringArray.length;
                }
                int n3 = 0;
                for (n3 = 0; n3 < n2 && CrashMechanism.transmitCrashSync(Utils.readFile(G.FILES_PATH + "/" + stringArray[n3]), 1); ++n3) {
                }
                if (n3 >= 1) {
                    for (n = 0; n < stringArray.length; ++n) {
                        try {
                            file = new File(G.FILES_PATH + "/" + stringArray[n]);
                            file.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray[n]), (Throwable)exception);
                        }
                    }
                }
                if ((n2 = 8) > stringArray2.length) {
                    n2 = stringArray2.length;
                }
                n3 = 0;
                for (n3 = 0; n3 < n2 && CrashMechanism.transmitCrashSync(Utils.readFile(G.FILES_PATH + "/" + stringArray2[n3]), 0); ++n3) {
                }
                if (n3 >= 1) {
                    for (n = 0; n < stringArray2.length; ++n) {
                        try {
                            file = new File(G.FILES_PATH + "/" + stringArray2[n]);
                            file.delete();
                            continue;
                        }
                        catch (Exception exception) {
                            Log.e((String)G.TAG, (String)("Error deleting trace file: " + G.FILES_PATH + "/" + stringArray2[n]), (Throwable)exception);
                        }
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    protected static String createJSONFromCrash(String string, int n, int n2, int n3, String[] stringArray, String string2, Map<String, String> map, Map<String, String> map2, int n4, long l, Map<String, String> map3) throws Exception {
        String string3;
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        JSONObject jSONObject4 = new JSONObject();
        JSONObject jSONObject5 = new JSONObject();
        JSONObject jSONObject6 = new JSONObject();
        JSONObject jSONObject7 = new JSONObject();
        if (G.userIdentifier != null) {
            jSONObject2.put("user_id", (Object)G.userIdentifier);
        }
        jSONObject.put("request", (Object)jSONObject2);
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        if (string2 == null) {
            jSONObject3.put("occured_at", (Object)bufferedReader.readLine());
        } else {
            jSONObject3.put("occured_at", (Object)string2);
        }
        jSONObject3.put("message", (Object)bufferedReader.readLine());
        String string4 = string3 = bufferedReader.readLine();
        try {
            string4 = string3.substring(string3.lastIndexOf("(") + 1, string3.lastIndexOf(")"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        jSONObject3.put("where", (Object)string4);
        jSONObject3.put("handled", n4);
        jSONObject3.put("klass", (Object)CrashMechanism.getClass(string));
        jSONObject3.put("backtrace", (Object)string);
        jSONObject3.put("breadcrumbs", (Object)CrashMechanism.getBreadcrumbsLine(G.breadcrumbs));
        jSONObject.put("exception", (Object)jSONObject3);
        bufferedReader.close();
        jSONObject5.put("uid", (Object)G.UID);
        jSONObject5.put("phone", (Object)G.PHONE_MODEL);
        jSONObject5.put("brand", (Object)G.PHONE_BRAND);
        jSONObject5.put("appver", (Object)G.APP_VERSION);
        jSONObject5.put("appname", (Object)G.APP_PACKAGE);
        jSONObject5.put("internal_version", (Object)G.APP_VERSIONCODE);
        jSONObject5.put("osver", (Object)G.ANDROID_VERSION);
        jSONObject5.put("wifi_on", n);
        jSONObject5.put("mobile_net_on", n2);
        jSONObject5.put("gps_on", n3);
        jSONObject5.put("screen:width", (Object)stringArray[0]);
        jSONObject5.put("screen:height", (Object)stringArray[1]);
        jSONObject5.put("screen:orientation", (Object)stringArray[2]);
        jSONObject5.put("screen_dpi(x:y)", (Object)(stringArray[3] + ":" + stringArray[4]));
        jSONObject5.put("locale", (Object)G.LOCALE);
        jSONObject5.put("apps_running", (Object)G.APPS_RUNNING);
        if (map2 != null) {
            map.putAll(map2);
        }
        if (G.SEND_LOG && n4 == 1) {
            map.put("log", Utils.readLogs());
        }
        map.put("rooted", String.valueOf(G.HAS_ROOT));
        map.put("ms_from_start", String.valueOf(l));
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                jSONObject4.put(entry.getKey(), (Object)entry.getValue());
            }
            jSONObject5.put("log_data", (Object)jSONObject4);
        }
        if (map3 != null && !map3.isEmpty()) {
            for (Map.Entry<String, String> entry : map3.entrySet()) {
                jSONObject6.put(entry.getKey(), (Object)entry.getValue());
            }
            jSONObject.put("performance", (Object)jSONObject6);
        }
        jSONObject.put("application_environment", (Object)jSONObject5);
        jSONObject7.put("version", (Object)"3.5");
        jSONObject7.put("name", (Object)"bugsense-android");
        jSONObject.put("client", (Object)jSONObject7);
        return jSONObject.toString();
    }

    protected static void transmitCrashASync(final String string, final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (G.sendOnlyWiFi) {
                    if (G.IS_WIFI_ON == 1) {
                        if (!CrashMechanism.transmitCrashSync(string, n)) {
                            CrashMechanism.saveCrash(string, n);
                        }
                    } else {
                        CrashMechanism.saveCrash(string, n);
                    }
                } else if (!CrashMechanism.transmitCrashSync(string, n)) {
                    CrashMechanism.saveCrash(string, n);
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    private static boolean transmitCrashSync(String string, int n) {
        if (BugSenseHandler.I_WANT_TO_DEBUG) {
            Log.d((String)G.TAG, (String)("Transmitting Crash, URL: " + G.URL + " APIKEY: " + G.API_KEY));
        }
        if (string.length() > 10) {
            ArrayList<BasicNameValuePair> arrayList = new ArrayList<BasicNameValuePair>();
            DefaultHttpClient defaultHttpClient = null;
            defaultHttpClient = new DefaultHttpClient();
            HttpParams httpParams = defaultHttpClient.getParams();
            HttpProtocolParams.setUseExpectContinue((HttpParams)httpParams, (boolean)false);
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)20000);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)20000);
            HttpPost httpPost = new HttpPost(G.URL);
            httpPost.addHeader("X-BugSense-Api-Key", G.API_KEY);
            try {
                String string2;
                block12: {
                    arrayList.add(new BasicNameValuePair("data", string));
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(arrayList, "UTF-8"));
                    HttpResponse httpResponse = defaultHttpClient.execute((HttpUriRequest)httpPost);
                    HttpEntity httpEntity = httpResponse.getEntity();
                    if (httpEntity == null) {
                        Log.w((String)G.TAG, (String)"It seems that there is no internet connectivity");
                        throw new Exception("no internet connection");
                    }
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpEntity.getContent()));
                    string2 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (BugSenseHandler.I_WANT_TO_DEBUG) {
                        Log.i((String)G.TAG, (String)("Crash Response: " + string2));
                    }
                    if (n == 1 && string2 != null && string2.contains("eid")) {
                        try {
                            int n2;
                            JSONObject jSONObject = new JSONObject(string2);
                            JSONObject jSONObject2 = new JSONObject(jSONObject.getString("data"));
                            if (jSONObject2 != null && (n2 = jSONObject2.getInt("eid")) != 0) {
                                Utils.saveLastCrashID(String.valueOf(n2));
                            }
                        }
                        catch (JSONException jSONException) {
                            if (!BugSenseHandler.I_WANT_TO_DEBUG) break block12;
                            jSONException.printStackTrace();
                        }
                    }
                }
                if (string2 != null && string2.contains("tickerText") && string2.contains("contentTitle") && string2.contains("url")) {
                    CrashMechanism.saveFixNotification(string2);
                }
            }
            catch (Exception exception) {
                Log.w((String)G.TAG, (String)("Transmitting crash Exception " + exception.getMessage()));
                if (BugSenseHandler.I_WANT_TO_DEBUG) {
                    exception.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    private static void saveFixNotification(final String string) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    File file = new File(G.FILES_PATH + "/" + CrashMechanism.fixfilename);
                    if (file != null && file.exists()) {
                        file.delete();
                    }
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(G.FILES_PATH + "/" + CrashMechanism.fixfilename));
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)G.TAG, (String)"Error saving crash data");
                        if (!BugSenseHandler.I_WANT_TO_DEBUG) break block3;
                        iOException.printStackTrace();
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    protected static void saveCrash(final String string, final int n) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    String string3 = "Crash_";
                    if (n == 0) {
                        string3 = "Exception_";
                    }
                    String string2 = string3 + String.valueOf(System.currentTimeMillis()) + "-" + Integer.toString(new Random(System.currentTimeMillis()).nextInt(99999));
                    try {
                        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(G.FILES_PATH + "/" + string2));
                        bufferedWriter.write(string);
                        bufferedWriter.flush();
                        bufferedWriter.close();
                    }
                    catch (IOException iOException) {
                        Log.e((String)G.TAG, (String)"Error saving crash data");
                        if (!BugSenseHandler.I_WANT_TO_DEBUG) break block3;
                        iOException.printStackTrace();
                    }
                }
            }
        });
        ExecutorService executorService = BugSense.getExecutor();
        if (thread != null && executorService != null) {
            executorService.submit(thread);
        }
    }

    private static String getBreadcrumbsLine(ArrayList<String> arrayList) {
        String string = "";
        if (arrayList == null || arrayList.size() == 0) {
            string = "";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : arrayList) {
                String string3 = string2.replaceAll("\\|", "_");
                char c = string3.charAt(0);
                if (c == '_') {
                    string3 = string3.replaceFirst("_", "-");
                }
                stringBuilder.append(string3);
                stringBuilder.append("|");
            }
            try {
                string = stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1);
            }
            catch (Exception exception) {
                Log.e((String)G.TAG, (String)"Error occured in breadcrumbs");
                string = "";
            }
        }
        return string;
    }

    private static String getClass(String string) {
        String string2 = "";
        try {
            int n = string.indexOf(":");
            if (n != -1 && n + 1 < string.length()) {
                string2 = string.substring(0, n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }
}

