/*
 * Decompiled with CFR 0.152.
 */
package org.cmc.music.myid3;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import org.cmc.music.myid3.ID3v2FrameFlags;
import org.cmc.music.myid3.MyID3Listener;
import org.cmc.music.myid3.MyID3v2Constants;
import org.cmc.music.myid3.MyID3v2FrameData;
import org.cmc.music.myid3.MyID3v2FrameImage;
import org.cmc.music.myid3.MyID3v2FrameText;
import org.cmc.music.myid3.UnicodeMetrics;

public class MyID3v2Read
implements MyID3v2Constants {
    private static final int kHIGH_BIT = 128;
    private final InputStream is;
    private final boolean async;
    private final MyID3Listener listener;
    private boolean complete = false;
    private boolean error = false;
    private boolean no_tag = false;
    private boolean stream_complete = false;
    private boolean header_read = false;
    private boolean tagRead = false;
    private int index = 0;
    private int last = -1;
    private byte versionMajor;
    private byte versionMinor;
    private boolean tagUnsynchronization = false;
    private boolean tagCompression = false;
    private boolean tagExtendedHeader = false;
    private boolean tagExperimentalIndicator = false;
    private boolean tagFooterPresent = false;
    private final Vector tags = new Vector();
    private static final String LEGAL_FRAME_ID_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();
    private long bytes_read = 0L;
    private int tagLength = 0;
    private final byte[] buffer = new byte[1024];
    private String errorMessage = null;

    public MyID3v2Read(MyID3Listener listener, InputStream is, boolean async) {
        this.listener = listener;
        this.is = is;
        this.async = async;
    }

    public void dump() {
    }

    public boolean isComplete() {
        return this.complete || this.error || this.no_tag;
    }

    public boolean isError() {
        return this.error;
    }

    public boolean hasTags() {
        return !this.error && this.complete && !this.no_tag;
    }

    public boolean iteration() {
        if (this.isComplete()) {
            return true;
        }
        if (!this.read()) {
            return false;
        }
        if (this.isComplete()) {
            return true;
        }
        if (!this.header_read) {
            if (this.bytes_read < 10L) {
                if (this.stream_complete) {
                    this.error = true;
                }
                return true;
            }
            this.readHeader();
        }
        if (!this.tagRead) {
            if (this.bytes_read < (long)this.tagLength) {
                if (this.stream_complete) {
                    this.error = true;
                }
                return true;
            }
            this.readTag();
            this.complete = true;
        }
        return true;
    }

    private int readInt3(byte[] bytes, boolean check_tagLength) {
        if (this.index + 2 >= this.tagLength && check_tagLength) {
            this.setError("readInt3(index: " + this.index + ", tagLength: " + this.tagLength);
            return -1;
        }
        if (this.index + 3 >= bytes.length) {
            this.setError("readInt3(index: " + this.index + ", bytes.length: " + bytes.length);
            return -1;
        }
        int[] array = new int[]{0xFF & bytes[this.index++], 0xFF & bytes[this.index++], 0xFF & bytes[this.index++]};
        int result = array[0] << 16 | array[1] << 8 | array[2] << 0;
        return result;
    }

    public static Number readSynchsafeInt(byte[] bytes, int start) {
        if (start + 3 >= bytes.length) {
            return null;
        }
        int index = start;
        int[] array = new int[]{0xFF & bytes[index++], 0xFF & bytes[index++], 0xFF & bytes[index++], 0xFF & bytes[index++]};
        int i = 0;
        while (i < array.length) {
            if ((array[i] & 0x80) > 0) {
                int n = i;
                array[n] = array[n] & 0x80;
            }
            ++i;
        }
        int result = array[0] << 21 | array[1] << 14 | array[2] << 7 | array[3] << 0;
        return new Integer(result);
    }

    private int readSynchsafeInt(byte[] bytes, boolean check_tagLength) {
        if (this.index + 3 >= this.tagLength && check_tagLength) {
            this.setError("readSynchsafeInt(index: " + this.index + ", tagLength: " + this.tagLength);
            return -1;
        }
        if (this.index + 3 >= bytes.length) {
            this.setError("readSynchsafeInt(index: " + this.index + ", bytes.length: " + bytes.length);
            return -1;
        }
        int[] array = new int[]{0xFF & bytes[this.index++], 0xFF & bytes[this.index++], 0xFF & bytes[this.index++], 0xFF & bytes[this.index++]};
        int i = 0;
        while (i < array.length) {
            if ((array[i] & 0x80) > 0) {
                int n = i;
                array[n] = array[n] & 0x80;
            }
            ++i;
        }
        int result = array[0] << 21 | array[1] << 14 | array[2] << 7 | array[3] << 0;
        return result;
    }

    private int readInt(byte[] bytes, boolean check_tagLength) {
        if (this.index + 3 >= this.tagLength && check_tagLength) {
            this.setError("readInt(index: " + this.index + ", tagLength: " + this.tagLength);
            return -1;
        }
        if (this.index + 3 >= bytes.length) {
            this.setError("readInt(index: " + this.index + ", bytes.length: " + bytes.length);
            return -1;
        }
        int[] array = new int[]{0xFF & bytes[this.index++], 0xFF & bytes[this.index++], 0xFF & bytes[this.index++], 0xFF & bytes[this.index++]};
        int result = array[0] << 24 | array[1] << 16 | array[2] << 8 | array[3] << 0;
        return result;
    }

    private int readShort(byte[] bytes) {
        if (this.index + 1 >= this.tagLength || this.index + 1 >= bytes.length) {
            this.setError("readShort(index: " + this.index + ", tagLength: " + this.tagLength + ", bytes.length: " + bytes.length);
            return -1;
        }
        byte[] array = new byte[]{bytes[this.index++], bytes[this.index++]};
        int result = array[0] << 8 | array[1] << 0;
        return result;
    }

    private void readHeader() {
        long flags;
        byte[] bytes = this.baos.toByteArray();
        if (bytes.length < 10) {
            this.setError("missing header");
            return;
        }
        if (this.listener != null) {
            this.listener.log("id3v2 header");
        }
        if (bytes[this.index++] != 73) {
            this.no_tag = true;
        } else if (bytes[this.index++] != 68) {
            this.no_tag = true;
        } else if (bytes[this.index++] != 51) {
            this.no_tag = true;
        }
        if (this.error || this.no_tag) {
            return;
        }
        this.versionMajor = bytes[this.index++];
        this.versionMinor = bytes[this.index++];
        if (this.listener != null) {
            this.listener.log("\tid3v2 versionMajor", this.versionMajor);
            this.listener.log("\tid3v2 versionMinor", this.versionMinor);
        }
        if (this.versionMajor < 2 || this.versionMajor > 4) {
            this.setError("Unknown id3v2 Major Version: " + this.versionMajor);
            return;
        }
        long workingFlags = flags = (long)bytes[this.index++];
        if (this.versionMajor == 2) {
            if ((workingFlags & 0x80L) > 0L) {
                this.tagUnsynchronization = true;
                workingFlags ^= 0x80L;
            }
            if ((workingFlags & 0x40L) > 0L) {
                this.tagCompression = true;
                workingFlags ^= 0x40L;
            }
        } else if (this.versionMajor == 3) {
            if ((workingFlags & 0x80L) > 0L) {
                this.tagUnsynchronization = true;
                workingFlags ^= 0x80L;
            }
            if ((workingFlags & 0x40L) > 0L) {
                this.tagExtendedHeader = true;
                workingFlags ^= 0x40L;
            }
            if ((workingFlags & 0x20L) > 0L) {
                this.tagExperimentalIndicator = true;
                workingFlags ^= 0x20L;
            }
            if ((workingFlags & 0x10L) > 0L) {
                workingFlags ^= 0x10L;
            }
        } else if (this.versionMajor == 4) {
            if ((workingFlags & 0x80L) > 0L) {
                this.tagUnsynchronization = true;
                workingFlags ^= 0x80L;
            }
            if ((workingFlags & 0x40L) > 0L) {
                this.tagExtendedHeader = true;
                workingFlags ^= 0x40L;
            }
            if ((workingFlags & 0x20L) > 0L) {
                this.tagExperimentalIndicator = true;
                workingFlags ^= 0x20L;
            }
            if ((workingFlags & 0x10L) > 0L) {
                this.tagFooterPresent = true;
                workingFlags ^= 0x10L;
            }
        } else {
            this.setError("Unknown id3v2 Major Version: " + this.versionMajor);
            return;
        }
        if (workingFlags > 0L) {
            this.setError("Unknown id3v2 tag flags(id3v2 version: " + this.versionMajor + "): " + Long.toHexString(flags));
            return;
        }
        if (this.listener != null) {
            this.listener.log("\tunsynchronization", this.tagUnsynchronization);
            this.listener.log("\tcompression", this.tagCompression);
            this.listener.log("\textendedHeader", this.tagExtendedHeader);
            this.listener.log("\texperimentalIndicator", this.tagExperimentalIndicator);
            this.listener.log("\tfooterPresent", this.tagFooterPresent);
        }
        this.tagLength = this.readSynchsafeInt(bytes, false);
        this.tagLength += 10;
        this.last = this.tagLength;
        if (this.tagFooterPresent) {
            this.tagLength += 10;
        }
        this.header_read = true;
        if (this.index != 10) {
            this.setError("index!=kHEADER_SIZE");
        }
        if (this.listener != null) {
            this.listener.log("\ttagLength", this.tagLength);
            this.listener.log();
        }
    }

    private byte[] ununsynchronize(byte[] bytes) {
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        int i = 0;
        while (i < bytes.length) {
            byte b = bytes[i++];
            result.write(b);
            if ((0xFF & b) != 255) continue;
            if (i >= bytes.length) break;
            byte b1 = bytes[i];
            if ((0xFF & b1) != 0) continue;
            ++i;
        }
        bytes = result.toByteArray();
        return bytes;
    }

    private String parseFrameID(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            int b = 0xFF & bytes[i];
            char c = (char)b;
            if (LEGAL_FRAME_ID_CHARACTERS.indexOf(c) < 0) {
                this.setError("invalid id3v2 frame id byte: " + Integer.toHexString(b));
                return null;
            }
            ++i;
        }
        return new String(bytes);
    }

    private boolean isZeroFrameId(byte[] bytes) {
        int i = 0;
        while (i < bytes.length) {
            if ((0xFF & bytes[i]) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void readTag() {
        byte[] bytes = this.baos.toByteArray();
        if (bytes.length < this.tagLength) {
            this.setError("missing tag");
            return;
        }
        if (this.tagUnsynchronization) {
            bytes = this.ununsynchronize(bytes);
        }
        if (this.tagExtendedHeader) {
            this.index += 4;
        }
        int tagCount = 0;
        int tag_num = 0;
        while (this.index + 7 < this.last && !this.error) {
            if (this.index + 7 >= this.last) break;
            byte[] frameID = this.versionMajor >= 3 ? new byte[]{bytes[this.index++], bytes[this.index++], bytes[this.index++], bytes[this.index++]} : new byte[]{bytes[this.index++], bytes[this.index++], bytes[this.index++]};
            if (this.isZeroFrameId(frameID)) {
                if (this.listener == null) break;
                this.listener.log("zero frameID", frameID);
                break;
            }
            String frameIDString = this.parseFrameID(frameID);
            if (frameIDString == null) break;
            if (this.listener != null) {
                this.listener.log("id3v2 frameIDString", frameIDString);
            }
            int frameLength = this.versionMajor >= 4 ? this.readSynchsafeInt(bytes, true) : (this.versionMajor >= 3 ? this.readInt(bytes, true) : this.readInt3(bytes, true));
            if (this.listener != null) {
                this.listener.log("frameLength", frameLength);
            }
            int maxTagLength = this.tagLength - this.index;
            if (this.versionMajor >= 3) {
                maxTagLength += 2;
            }
            if (frameLength == 0) {
                if (this.listener == null) break;
                this.listener.log("frame has zero length.");
                break;
            }
            if (frameLength > maxTagLength || frameLength < 0) {
                if (this.listener != null) {
                    this.listener.log("frame length exceeds tag length", frameLength);
                    this.listener.log("bad frameLength versionMajor", this.versionMajor);
                    this.listener.log("bad frameLength versionMinor", this.versionMinor);
                    this.listener.log("bad frameLength frameIDString", frameIDString);
                    this.listener.log("bad frameLength maxTagLength", maxTagLength);
                    this.listener.log("bad frameLength frameLength", String.valueOf(frameLength) + " (0x" + Integer.toHexString(frameLength) + ")");
                    this.listener.log("bad frameLength tagLength", String.valueOf(this.tagLength) + " (0x" + Integer.toHexString(this.tagLength) + ")");
                    this.listener.log("bad frameLength index", this.index);
                    this.listener.log("bytes", bytes);
                }
                this.setError("bad frame length(" + tag_num + ": " + frameIDString + "): " + frameLength + " (" + new String(frameID));
                break;
            }
            ID3v2FrameFlags flags = null;
            if (this.versionMajor == 3 || this.versionMajor == 4) {
                int value;
                int workingFlags = value = this.readShort(bytes);
                flags = new ID3v2FrameFlags();
                if (this.versionMajor == 3) {
                    if ((workingFlags & 0x8000) > 0) {
                        flags.setTagAlterPreservation(true);
                        workingFlags ^= 0x8000;
                    }
                    if ((workingFlags & 0x4000) > 0) {
                        flags.setFileAlterPreservation(true);
                        workingFlags ^= 0x4000;
                    }
                    if ((workingFlags & 0x2000) > 0) {
                        flags.setReadOnly(true);
                        workingFlags ^= 0x2000;
                    }
                    if ((workingFlags & 0x20) > 0) {
                        flags.setGroupingIdentity(true);
                        workingFlags ^= 0x20;
                    }
                    if ((workingFlags & 0x80) > 0) {
                        flags.setCompression(true);
                        workingFlags ^= 0x80;
                    }
                    if ((workingFlags & 0x40) > 0) {
                        flags.setEncryption(true);
                        workingFlags ^= 0x40;
                    }
                } else if (this.versionMajor == 4) {
                    if ((workingFlags & 0x4000) > 0) {
                        flags.setTagAlterPreservation(true);
                        workingFlags ^= 0x4000;
                    }
                    if ((workingFlags & 0x2000) > 0) {
                        flags.setFileAlterPreservation(true);
                        workingFlags ^= 0x2000;
                    }
                    if ((workingFlags & 0x1000) > 0) {
                        flags.setReadOnly(true);
                        workingFlags ^= 0x1000;
                    }
                    if ((workingFlags & 0x40) > 0) {
                        flags.setGroupingIdentity(true);
                        workingFlags ^= 0x40;
                    }
                    if ((workingFlags & 8) > 0) {
                        flags.setCompression(true);
                        workingFlags ^= 8;
                    }
                    if ((workingFlags & 4) > 0) {
                        flags.setEncryption(true);
                        workingFlags ^= 4;
                    }
                    if ((workingFlags & 2) > 0) {
                        flags.setUnsynchronisation(true);
                        workingFlags ^= 2;
                    }
                    if ((workingFlags & 1) > 0) {
                        flags.setDataLengthIndicator(true);
                        workingFlags ^= 1;
                    }
                }
                if (workingFlags > 0) {
                    this.setError("Unknown id3v2 frame flags(id3v2 version: " + this.versionMajor + "): " + Long.toHexString(value));
                    return;
                }
            } else if (this.versionMajor == 2) {
                flags = new ID3v2FrameFlags();
            } else {
                this.setError("Unknown ID3v2 version: " + this.versionMajor);
                return;
            }
            if (this.listener != null) {
                this.listener.log("flags", flags.getSummary());
            }
            if (frameLength > 0) {
                int dataLengthIndicator = -1;
                if (flags != null && flags.getDataLengthIndicator()) {
                    dataLengthIndicator = this.readSynchsafeInt(bytes, true);
                    frameLength -= 4;
                    if (this.listener != null) {
                        this.listener.log("dataLengthIndicator", dataLengthIndicator);
                    }
                }
                byte[] frameBytes = new byte[frameLength];
                System.arraycopy(bytes, this.index, frameBytes, 0, frameLength);
                this.index += frameLength;
                if (flags != null && flags.getUnsynchronisation()) {
                    frameBytes = this.ununsynchronize(frameBytes);
                }
                try {
                    if (frameID[0] == 84) {
                        if (this.listener != null) {
                            this.listener.log("text frame");
                        }
                        this.readTextTag(frameLength, frameID, frameBytes, frameIDString);
                    } else {
                        if (this.listener != null) {
                            this.listener.log("data frame");
                        }
                        this.readDataTag(frameLength, frameID, frameBytes, frameIDString, flags);
                    }
                }
                catch (IOException e) {
                    if (this.listener != null) {
                        this.listener.log("IOException", e.getMessage());
                    }
                    this.setError(e.getMessage());
                    return;
                }
            }
            ++tagCount;
            if (this.listener != null) {
                this.listener.log();
            }
            ++tag_num;
        }
        this.tagRead = true;
        if (this.listener != null) {
            this.listener.log();
        }
    }

    private void readDataTag(int frameLength, byte[] frameID, byte[] frameBytes, String frameIDString, ID3v2FrameFlags flags) throws IOException {
        if (frameIDString.equals("COMM") || frameIDString.equals("COM")) {
            if (frameBytes.length < 5) {
                this.setError("Unexpected COMM frame length(1): " + frameLength + " (" + new String(frameID));
                return;
            }
            int frameIndex = 0;
            int charEncodingCode = 0xFF & frameBytes[frameIndex++];
            byte language_1 = frameBytes[frameIndex++];
            byte language_2 = frameBytes[frameIndex++];
            byte language_3 = frameBytes[frameIndex++];
            String summary = this.readString(frameBytes, frameIndex, charEncodingCode);
            int stringDataLength = this.findStringDataLength(frameBytes, frameIndex, charEncodingCode);
            String comment = this.readString(frameBytes, frameIndex += stringDataLength, charEncodingCode);
            MyID3v2FrameText tag = new MyID3v2FrameText(frameIDString, frameBytes, comment);
            this.tags.add(tag);
        } else if (frameIDString.equals("PIC") || frameIDString.equals("APIC")) {
            String mimeType;
            int frameIndex = 0;
            int charEncodingCode = 0xFF & frameBytes[frameIndex++];
            if (frameIDString.equals("PIC")) {
                int imageFormat1 = 0xFF & frameBytes[frameIndex++];
                int imageFormat2 = 0xFF & frameBytes[frameIndex++];
                int imageFormat3 = 0xFF & frameBytes[frameIndex++];
                String extension = "" + (char)imageFormat1 + (char)imageFormat2 + (char)imageFormat3;
                mimeType = extension.toLowerCase();
                if (!mimeType.startsWith("image/")) {
                    mimeType = "image/" + mimeType;
                }
            } else {
                mimeType = this.readString(frameBytes, frameIndex, charEncodingCode);
                int stringDataLength = this.findStringDataLength(frameBytes, frameIndex, charEncodingCode);
                frameIndex += stringDataLength;
            }
            int pictureType = 0xFF & frameBytes[frameIndex++];
            String description = this.readString(frameBytes, frameIndex, charEncodingCode);
            int stringDataLength = this.findStringDataLength(frameBytes, frameIndex, charEncodingCode);
            byte[] imageData = new byte[frameBytes.length - (frameIndex += stringDataLength)];
            System.arraycopy(frameBytes, frameIndex, imageData, 0, imageData.length);
            this.tags.add(new MyID3v2FrameImage(frameIDString, frameBytes, flags, imageData, mimeType, description, pictureType));
        } else if (frameIDString.equals("PRIV")) {
            int frameIndex = 0;
            int charEncodingCode = 0;
            String owner_identifier = this.readString(frameBytes, frameIndex, charEncodingCode);
            int stringDataLength = this.findStringDataLength(frameBytes, frameIndex, charEncodingCode);
            frameIndex += stringDataLength;
            if (owner_identifier.startsWith("WM/")) {
                return;
            }
        } else {
            this.tags.add(new MyID3v2FrameData(frameIDString, frameBytes, flags));
        }
    }

    private void readTextTag(int frameLength, byte[] frameID, byte[] frameBytes, String frameIDString) throws IOException {
        if (frameLength != 1) {
            if (frameLength < 2) {
                this.setError("Unexpected frame length(1): " + frameLength + " (" + new String(frameID));
            } else {
                MyID3v2FrameText tag;
                int charEncodingCode = 0xFF & frameBytes[0];
                int frameIndex = 1;
                String value = this.readString(frameBytes, frameIndex, charEncodingCode);
                if (this.listener != null) {
                    this.listener.logWithLength("value", value);
                }
                String value2 = null;
                if (frameIDString.equals("TXXX")) {
                    int stringDataLength = this.findStringDataLength(frameBytes, frameIndex, charEncodingCode);
                    value2 = this.readString(frameBytes, frameIndex += stringDataLength, charEncodingCode);
                    if (this.listener != null) {
                        this.listener.logWithLength("value2", value2);
                    }
                    tag = new MyID3v2FrameText(frameIDString, frameBytes, value, value2);
                } else {
                    tag = new MyID3v2FrameText(frameIDString, frameBytes, value);
                }
                this.tags.add(tag);
            }
        }
    }

    private String getCharacterEncodingName(int charEncodingCode) throws IOException {
        switch (charEncodingCode) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16";
            }
            case 2: {
                return "UTF-16";
            }
            case 3: {
                return "UTF-8";
            }
        }
        throw new IOException("Unknown charEncodingCode: " + charEncodingCode);
    }

    private String getCharacterEncodingFullName(int charEncodingCode) throws IOException {
        switch (charEncodingCode) {
            case 0: {
                return "ISO-8859-1";
            }
            case 1: {
                return "UTF-16 with BOM";
            }
            case 2: {
                return "UTF-16 without BOM";
            }
            case 3: {
                return "UTF-8";
            }
        }
        throw new IOException("Unknown charEncodingCode: " + charEncodingCode);
    }

    private String readString(byte[] bytes, int start, int charEncodingCode) throws IOException {
        if (this.listener != null) {
            this.listener.log("reading string with encoding", this.getCharacterEncodingFullName(charEncodingCode));
        }
        UnicodeMetrics unicodeMetrics = UnicodeMetrics.getInstance(charEncodingCode);
        int unicodeMetricsEnd = unicodeMetrics.findEndWithoutTerminator(bytes, start);
        int unicodeMetricsLength = unicodeMetricsEnd - start;
        String charsetName = this.getCharacterEncodingName(charEncodingCode);
        return new String(bytes, start, unicodeMetricsLength, charsetName);
    }

    private int findStringDataLength(byte[] bytes, int start, int charEncodingCode) throws IOException {
        UnicodeMetrics unicodeMetrics = UnicodeMetrics.getInstance(charEncodingCode);
        int unicodeMetricsEnd = unicodeMetrics.findEndWithTerminator(bytes, start);
        int unicodeMetricsLength = unicodeMetricsEnd - start;
        return unicodeMetricsLength;
    }

    private boolean read() {
        int read;
        block9: {
            block8: {
                block7: {
                    block6: {
                        try {
                            if (this.is.available() >= 0) break block6;
                            this.stream_complete = true;
                            return true;
                        }
                        catch (IOException e) {
                            this.setError(e.getMessage());
                            return true;
                        }
                    }
                    if (this.async || this.is.available() >= 1) break block7;
                    this.stream_complete = true;
                    return true;
                }
                if (this.is.available() >= 1) break block8;
                return false;
            }
            read = this.is.read(this.buffer);
            if (read >= 1) break block9;
            this.setError("unexpected stream closed");
            return true;
        }
        this.baos.write(this.buffer, 0, read);
        this.bytes_read += (long)read;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void setError(String s) {
        this.error = true;
        this.errorMessage = s;
    }

    public Vector getTags() {
        return this.tags;
    }

    public byte getVersionMajor() {
        return this.versionMajor;
    }

    public byte getVersionMinor() {
        return this.versionMinor;
    }

    public long getProgress() {
        return this.bytes_read;
    }

    public byte[] getBytes() {
        if (this.error || this.no_tag || !this.complete) {
            return null;
        }
        byte[] bytes = this.baos.toByteArray();
        if (bytes.length < this.tagLength) {
            return null;
        }
        byte[] result = new byte[this.tagLength];
        System.arraycopy(bytes, 0, result, 0, this.tagLength);
        return result;
    }
}

