/*
  This file is part of f-palette-CANopen

  2011/11/08
  Copyright (C): Future Robotics Technology Center, Chiba institute of technology
  TI F2803x Port: Masaharu Shimizu@Future Robotics Technology Center, Chiba institute of technology
  
  This work is based on
   -    Canfestival
        http://sourceforge.net/projects/canfestival/
  Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// F28035 implementation of the  CANopen timer driver, uses Timer 1 (16 bit)

//## Include TI header files
#include "DSP2803x_Device.h"     // DSP2803x Headerfile Include File
#include "DSP2803x_Examples.h"   // DSP2803x Examples Include File

// Includes for the Canfestival driver
#include "canfestival.h"
#include "timer.h"

// Define the timer registers
#define TimerCounter    CpuTimer1Regs.TIM.all
#define TimerPeriod     CpuTimer1Regs.PRD.all

interrupt void cpu_timer1_isr(void);
extern s_timer_entry timers[MAX_NB_TIMER];


/************************** Modul variables **********************************/
// Store the last timer value to calculate the elapsed time
static TIMEVAL last_time_set = TIMEVAL_MAX;     

void initTimer(void)
/******************************************************************************
Initializes the timer1.Count Down Timer.
INPUT	void
OUTPUT	void
******************************************************************************/
{
	UNS16	i;
	s_timer_entry	s_timer_init = {TIMER_FREE, NULL, NULL, 0, 0, 0};

	/* Initialize timer control array */
	/* Beause timers[1] or bigger is not initialized. (Not zero) */
	for(i = 0; i < MAX_NB_TIMER;i++){
		timers[i] = s_timer_init;
	}
	// Initialize timer period to maximum:
	TimerPeriod  = 0xFFFFFFFF;
    // Initialize pre-scale counter to divide by 1 (SYSCLKOUT):
	CpuTimer1Regs.TPR.all  = (60*4);
	CpuTimer1Regs.TPRH.all = 0;
    // Make sure timers are stopped:
	CpuTimer1Regs.TCR.bit.TSS = 1;
	// Reload all counter register with period value:
	CpuTimer1Regs.TCR.bit.TRB = 1;
	//Intterrupt Enable
	CpuTimer1Regs.TCR.bit.TIE = 1;  // 0 = Disable/ 1 = Enable Timer Interrupt

   EALLOW;  // This is needed to write to EALLOW protected registers
   PieVectTable.TINT1 = &cpu_timer1_isr;
   EDIS;    // This is needed to disable write to EALLOW protected registers

// Enable CPU INT1 which is connected to CPU-Timer 1:
   IER |= M_INT13;

	StartCpuTimer1();
	last_time_set = TimerCounter;
	setTimer(MS_TO_TIMEVAL(10));/* 10ms after satrt */

}

void setTimer(TIMEVAL value)
/******************************************************************************
Set the timer for the next alarm.
INPUT	value TIMEVAL (unsigned long)
OUTPUT	void
******************************************************************************/
{
  last_time_set = getElapsedTime() + value;
  TimerCounter = value;	// Add the desired time to timer interrupt time
}

TIMEVAL getElapsedTime(void)
/******************************************************************************
Return the elapsed time to tell the Stack how much time is spent since last call.
INPUT	void
OUTPUT	value TIMEVAL (unsigned long) the elapsed time
******************************************************************************/
{
  TIMEVAL timer,returntmp;

	
  timer = TimerCounter;            // Copy the value of the running timer
  if (timer > last_time_set){                    // In case the timer value is higher than the last time.
    returntmp = (timer - last_time_set);             // Calculate the time difference
	}
  else if (timer < last_time_set){
    returntmp = (last_time_set - timer);             // Calculate the time difference for countdown timer;
	}
  else{
    returntmp = 0;
	}

    return returntmp;
}

interrupt void cpu_timer1_isr(void)
/******************************************************************************
Interruptserviceroutine Timer 1
******************************************************************************/
{
	EALLOW;
	last_time_set = TIMEVAL_MAX;
	TimeDispatch();                               // Call the time handler of the stack to adapt the elapsed time
	EDIS;
}


