/*
  This file is part of f-palette-CANopen

  2011/11/08
  Copyright (C): Future Robotics Technology Center, Chiba institute of technology
  TI F2803x Port: Masaharu Shimizu@Future Robotics Technology Center, Chiba institute of technology
  
  This work is based on
   -    Canfestival
        http://sourceforge.net/projects/canfestival/
  Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __APPLICFG_DSP__
#define __APPLICFG_DSP__

#include <string.h>
#include <stdio.h>

/*  Define the architecture : little_endian or big_endian
 -----------------------------------------------------
 Test :
 UNS32 v = 0x1234ABCD;
 char *data = &v;

 Result for a little_endian architecture :
 data[0] = 0xCD;
 data[1] = 0xAB;
 data[2] = 0x34;
 data[3] = 0x12;

 Result for a big_endian architecture :
 data[0] = 0x12;
 data[1] = 0x34;
 data[2] = 0xAB;
 data[3] = 0xCD;
 */

/* Integers */
#define INTEGER8 char
#define INTEGER16 short
#define INTEGER24 long
#define INTEGER32 long
#define INTEGER40 long long
#define INTEGER48 long long
#define INTEGER56 long long
#define INTEGER64 long long

/* Unsigned integers */
#define UNS8   unsigned char
#define UNS16  unsigned short
#define UNS32  unsigned long
#define UNS24  unsigned long
#define UNS40  unsigned long long
#define UNS48  unsigned long long
#define UNS56  unsigned long long
#define UNS64  unsigned long long

/* Reals */
#define REAL32	float
#define REAL64 double


/* Definition of error and warning macros */
/* -------------------------------------- */
#if defined DEBUG_ERR_CONSOLE_ON || defined DEBUG_WAR_CONSOLE_ON
#include <stdio.h>
#endif

#if 0
#include "errors.h"
#endif

/* Add flash section pragma */
/* Linker file F28035.cmd was modified */
/* FlashG  function */
#pragma CODE_SECTION(_getODentry, "flashG");
#pragma CODE_SECTION(EMCY_setError, "flashG");
#pragma CODE_SECTION(setNodeId, "flashG");
#pragma CODE_SECTION(canDispatch, "flashG");
#pragma CODE_SECTION(setState, "flashG");
#pragma CODE_SECTION(proceedNODE_GUARD, "flashG");

/* function of pdo.c */
#pragma CODE_SECTION(buildPDO, "flashG");
#pragma CODE_SECTION(sendPDOrequest, "flashG");
#pragma CODE_SECTION(proceedPDO, "flashG");
#pragma CODE_SECTION(CopyBits, "flashG");
#pragma CODE_SECTION(_sendPDOevent, "flashG");
#pragma CODE_SECTION(sendOnePDOevent, "flashG");
#pragma CODE_SECTION(PDOInit, "flashG");
#pragma CODE_SECTION(PDOStop, "flashG");

/* function of sdo.c */
#pragma CODE_SECTION(SDOTimeoutAlarm, "flashG");
#pragma CODE_SECTION(proceedSDO, "flashG");
#pragma CODE_SECTION(SDOlineToObjdict, "flashG");
#pragma CODE_SECTION(objdictToSDOline, "flashG");
#pragma CODE_SECTION(lineToSDO, "flashG");
#pragma CODE_SECTION(SDOtoLine, "flashG");
#pragma CODE_SECTION(failedSDO, "flashG");
#pragma CODE_SECTION(resetSDOline, "flashG");
#pragma CODE_SECTION(initSDOline, "flashG");
#pragma CODE_SECTION(sendSDO, "flashG");
#pragma CODE_SECTION(sendSDOabort, "flashG");
#pragma CODE_SECTION(writeNetworkDictCallBackAI, "flashG");
#pragma CODE_SECTION(readNetworkDictCallbackAI, "flashG");
#pragma CODE_SECTION(getReadResultNetworkDict, "flashG");


/* Definition of MSG_ERR */
/* --------------------- */
#define MSG_ERR(num, str, val)

/* Definition of MSG_WAR */
/* --------------------- */
#define MSG_WAR(num, str, val)

typedef void* CAN_HANDLE;

typedef void* CAN_PORT;

#endif
