/*
  This file is part of f-palette-CANopen

  2011/11/08
  Copyright (C): Future Robotics Technology Center, Chiba institute of technology
  TI F2803x Port: Masaharu Shimizu@Future Robotics Technology Center, Chiba institute of technology
  
  This work is based on
   -    Canfestival
        http://sourceforge.net/projects/canfestival/
  Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef __CAN_CANFESTIVAL__
#define __CAN_CANFESTIVAL__

#include "applicfg.h"
#include "data.h"

// ---------  to be called by user app ---------

/* CAN festival driver function */
extern void initTimer(void);
extern unsigned char canInit(unsigned int bitrate);
extern UNS8 canSend(CAN_PORT notused, Message *m);

/* ds401 functions */
extern unsigned char digital_input_handler(CO_Data* d, unsigned char *newInput, unsigned char size);
extern unsigned char digital_output_handler(CO_Data* d, unsigned char *newOuput, unsigned char size);
extern unsigned char analog_input_handler(CO_Data* d, unsigned int *newInput, unsigned char size);
extern void transmission_sendPDOevent(CO_Data* d);

#endif
