/*
  This file is part of f-palette-CANopen

  2011/11/08
  Copyright (C): Future Robotics Technology Center, Chiba institute of technology
  TI F2803x Port: Masaharu Shimizu@Future Robotics Technology Center, Chiba institute of technology
  
  This work is based on
   -    Canfestival
        http://sourceforge.net/projects/canfestival/
  Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __TIMERSCFG_H__
#define __TIMERSCFG_H__


// Time unit : us
// Time resolution : 32bit 

// Whatever your microcontroller, the timer wont work if
// TIMEVAL is not at least on 32 bits
#define TIMEVAL UNS32

// The max count of the timer 32bit
#define TIMEVAL_MAX 0xFFFFFFFF

// The timer is incrementing every 4 us.
#define MS_TO_TIMEVAL(ms) (ms * 250)
#define US_TO_TIMEVAL(us) (us >> 2)


#endif
