/*
 * Decompiled with CFR 0.152.
 */
package jp.fraction.hatena.node;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.fraction.hatena.HatenaContext;
import jp.fraction.hatena.node.AbstractPatternNode;

public class TableNode
extends AbstractPatternNode {
    private Pattern pattern = Pattern.compile("^\\|([^\\|]*\\|(?:[^\\|]*\\|)+)$");
    private Pattern headPattern = Pattern.compile("^\\*(.*)");

    public Pattern getPattern() {
        return this.pattern;
    }

    public Pattern getHeadPattern() {
        return this.headPattern;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext c) {
        String line;
        Matcher m;
        html.append("<table>");
        while (c.hasNext() && (m = this.getMatcher(line = c.nextLine())).matches()) {
            c.shiftLine();
            html.append("<tr>");
            String[] td = line.split("\\|");
            for (int i = 1; i < td.length; ++i) {
                String item = td[i];
                Matcher hm = this.getHeadPattern().matcher(item);
                if (hm.matches()) {
                    html.append("<th>");
                    html.append(hm.group(1));
                    html.append("</th>");
                    continue;
                }
                html.append("<td>");
                html.append(item);
                html.append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
        return html;
    }

    public StringBuilder parse(StringBuilder html, HatenaContext context, Matcher m) {
        return this.parse(html, context);
    }
}

