<?php
/*
 * 基本設定
 */
// セッション機能 ( true=spiderのセッションID発行機能を使う / false=PHP標準を使う )
// ※PHPのセッションID発行機能はIDが重複するバグがありますが、spiderの発行機能は環境によっては利用できません。
define( 'SPIDER_USE_SPIDER_SESSION_ID',	false );

// 言語
define ( 'CHARSET_LANGUAGE',		'Japanese' );
// PHP内部文字セット（基本的に変更しないこと）
define ( 'CHARSET_INTERNAL', 	'UTF-8' );
// HTTP出力文字セット
define ( 'CHARSET_HTTP_OUTPUT',	'UTF-8' );
// 文字セット判断順序
define ( 'CHARSET_ORDER',			'UTF-8,EUC-JP,SJIS,SJIS-win,JIS,UTF-7' );
// 出力ハンドラ
define ( 'OUTPUT_HANDLER',		'mb_output_handler' );
// カナ変換規則
define ( 'CHARSET_KANA_CONVERT', 'KV' );

/*
 * 拡張設定
 */
// ロックディレクトリ名
define ( 'DIR_NAME_LOCK',				'lock' );
// ライブラリディレクトリ名
define ( 'DIR_NAME_LIB',				'lib' );
// テンポラリディレクトリ名
define ( 'DIR_NAME_TEMPORARY',		'tmp' );
// テンプレート配置ディレクトリ名
define ( 'DIR_NAME_TEMPLATE',		'templates' );
// キャッシュディレクトリ名
define ( 'DIR_NAME_CACHE',			'cache' );
// バイナリディレクトリ名
define ( 'DIR_NAME_BIN',				'bin' );
// アプリケーションログ保存ディレクトリ
define ( 'DIR_NAME_LOG',				'logs' );
// CMSページ振り分けファイル配置ディレクトリ名
define ( 'DIR_NAME_CMS_PAGE',		'pages' );
// データ保存ディレクトリ
define ( 'DIR_NAME_DATA',				'data' );

/*
 * ユーザーエージェント分岐定義
 */
// 分岐タイプ定義
$GLOBALS['SPIDER_USER_AGENT_TYPE_ARRAY']	= array(
	'au'			=> 'au',
	'softbank'		=> 'SoftBank',
	'docomo2'		=> 'DoCoMo2.0',
	'docomo'		=> 'DoCoMo1.0',
	'pc'			=> 'PC',
);
// 分岐タイプの定義
$GLOBALS['SPIDER_USER_AGENT_TYPE_REGX_ARRAY']	= array(
	'/^KDDI\\-/'							=> 'au',
	'/^UP\\.Browser\\/[0-9\\.]+\\-/'	=> 'au',
	'/^J\\-PHONE/'						=> 'softbank',
	'/^Vodafone/'							=> 'softbank',
	'/^SoftBank/'							=> 'softbank',
	'/^DoCoMo\\/2/'						=> 'docomo2',
	'/^DoCoMo\\/1/'						=> 'docomo',
);

/*
 * 基本定義 
 */
// テンプレートディレクトリパス
define( 'DIR_PATH_TEMPLATE', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_TEMPLATE );
// ライブラリフォルダの絶対パス
define ( 'DIR_PATH_LIB', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_LIB );
// プロセスロックの一時フォルダ
define ( 'DIR_PATH_LOCK', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_LOCK );
// 全体で利用する一時フォルダ
define ( 'DIR_PATH_TMP', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_TEMPORARY );
// キャッシュディレクトリパス
define( 'DIR_PATH_CACHE',	DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_CACHE );
// バイナリディレクトリパス
define( 'DIR_PATH_BIN',	DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_BIN );
// アプリケーションログ保存ディレクトリパス
define( 'DIR_PATH_LOG',	DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_LOG );
// CMSページ振り分けファイル配置ディレクトリ
define( 'DIR_PATH_CMS_PAGE', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_CMS_PAGE );
// データ保存ディレクトリ
define( 'DIR_PATH_DATA', DIR_PATH_SPIDER_DATA . DIRECTORY_SEPARATOR . DIR_NAME_DATA );

/*
 * システムレポートとメール通知設定
 */
// システムメール定義ファイル名
define ( 'FILE_NAME_SYSTEM_DEFINITION',	'system.inc.php' );
// システムメール定義ファイルパス
define ( 'FILE_PATH_SYSTEM_DEFINITION',	DIR_PATH_DATA.DIRECTORY_SEPARATOR.FILE_NAME_SYSTEM_DEFINITION );

?>
