<?php
/**
 * 実行ファイルを作成します。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.01
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class spider_ExecutableFileCreator {

	var $execute_file_path;

	var $org_body_strings;
	var $out_body_strings;

	var $template_type;
	var $template_outer;
	
	/** 基本	*/
	var $module_name_array	= array();
	var $template_array		= array();
	
	var $bin_dir_root;
	var $template_dir_root;
	var $agent_type		= 'pc';
	
	/** 互換性	*/
	var $page_title;

	/** 今後の拡張	*/
	var $output_handler			= 'mb_output_handler';
	var $output_language		= 'Japanese';
	var $output_charset			= 'UTF-8';
	var $internal_charset		= 'UTF-8';
	var $detect_order			= "UTF-8,EUC-JP,SJIS,SJIS-win,JIS,UTF-7";
	var $convert_kana			= "";
	
	/** CMSページ振り分け	*/
	var $has_cms_page			= false;
	var $cms_page_file_path		= null;
	
	/** 表示前実行コードハッシュ	*/
	var $preview_process_hash		= array();
	/** 表示後実行コードハッシュ	*/
	var $postview_process_hash		= array();
	/** 表示文字列に対する処理実行コードハッシュ	*/
	var $convert_view_process_hash	= array();

	/**
	 * コンストラクタ
	 * @param $execute_file_path 実行ファイルパス
	 * @param $bin_dir_root 実行ファイルを出力するルートパス
	 * @param $template_dir_root テンプレートが存在するルートパス
	 */
	function spider_ExecutableFileCreator($execute_file_path,$bin_dir_root=null,$template_dir_root=null) {
		
		$this->_confirm_agent();
		
		// テンプレートディレクトリルート
		if( strlen(trim($template_dir_root)) > 0 ) {
			$this->template_dir_root	= $template_dir_root;
		} else {
			$this->template_dir_root	= DIR_PATH_TEMPLATE;
		}
		// バイナリディレクトリルート
		if( strlen(trim($bin_dir_root)) > 0 ) {
			$this->bin_dir_root	= $bin_dir_root;
		} else {
			$this->bin_dir_root	= DIR_PATH_BIN;
		}
		// 実行ファイルパス
		$this->execute_file_path	= $execute_file_path;
		
	}
	/**
	 * HTMLボディを生成する
	 */
	function convertBody() {
		$action_lines				= file( $this->execute_file_path );
		$this->out_body_strings		= implode( "", $action_lines );
		$this->org_body_strings		= $this->out_body_strings;
		
		// 改行コード統一と連続改行の削除
		$this->out_body_strings = str_replace( "\r\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\r", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n", "\n", $this->out_body_strings );
		$this->out_body_strings = str_replace( "\n\n", "\n", $this->out_body_strings );

		// cms.phpインクルード行を削除
		preg_match_all( '/include_once\\([^\\)]*?cms\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		preg_match_all( '/require_once\\([^\\)]*?cms\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		// spider.inc.phpインクルード行を削除
		preg_match_all( '/include_once\\([^\\)]*?spider\\.inc\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}
		preg_match_all( '/require_once\\([^\\)]*?spider\\.inc\\.php[^\\)]*?\\)\\;/'
			, $this->out_body_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$this->out_body_strings = str_replace( $target, "", $this->out_body_strings );
			}
		}

		// プレモジュール確認
		$this->_pickout_premodules();
		
		// 変換タグの読み込みと変換
		$tag_object_array	= array();
		$dir_path_tags	= dirname(__FILE__).DIRECTORY_SEPARATOR."tags".DIRECTORY_SEPARATOR;
		if ( is_dir($dir_path_tags) ) {
			if ( $dh = opendir( $dir_path_tags ) ) {
				while ( ( $file_name = readdir($dh) ) !== false ) {
					if( $file_name != "." && $file_name != ".."
						&& preg_match('/^[0-9a-zA-Z]+?\\.class\\.php$/',$file_name)) {
						require_once( dirname(__FILE__).DIRECTORY_SEPARATOR
							."tags".DIRECTORY_SEPARATOR.$file_name );
						$tag_class_name	= "spider_tags_".substr($file_name,0,strpos($file_name,"."));
						$tag_class_obj	= new $tag_class_name;
						if( !is_array( $tag_object_array[$tag_class_obj->priority]) ) {
							$tag_object_array[$tag_class_obj->priority]	= array();
						}
						array_push( $tag_object_array[$tag_class_obj->priority], $tag_class_obj );
					}
				}
				closedir($dh);
			} else {
			}
		} else {
		}
		// 外部変換タグの読み込みと変換
		$external_tags_conf_file	= dirname(__FILE__)
			.DIRECTORY_SEPARATOR."tags".DIRECTORY_SEPARATOR."externals.conf";
		if( file_exists( $external_tags_conf_file ) ) {
			$lines	= file( $external_tags_conf_file );
			foreach( $lines as $line ) {
				$line	= trim($line);
				$tag_class_name	= $line;
				$tag_class_file	= DIR_PATH_LIB.DIRECTORY_SEPARATOR.str_replace('_',DIRECTORY_SEPARATOR,$line).'.class.php';
				if( file_exists($tag_class_file) ) {
					require_once( $tag_class_file );
					$tag_class_obj	= new $tag_class_name;
					if( !is_array( $tag_object_array[$tag_class_obj->priority]) ) {
						$tag_object_array[$tag_class_obj->priority]	= array();
					}
					array_push( $tag_object_array[$tag_class_obj->priority], $tag_class_obj );
				}
			}
		}
		
		ksort($tag_object_array);
		foreach( $tag_object_array as $key => $tag_array ) {
			foreach($tag_array as $tag_obj ) {
				$tag_obj->convert( $this->out_body_strings, $this );
			}
		}

		// 出力文字コード変換
		$out_code = "UTF-8";
		if ( 'SJIS' == $this->output_charset
			|| 'SJIS-win' == $this->output_charset ) {
			$out_code = 'Shift_JIS';
		} else if ( 'EUC-JP' == $this->output_charset ) {
			$out_code = 'EUC-JP';
		}
		$this->out_body_strings = str_replace(
			"content=\"text/html; charset=UTF-8\""
			, 'content="text/html; charset=' . $out_code . '"'
			, $this->out_body_strings );

	}
	/**
	 * 実行ファイル実体を書き出す
	 * @param $bin_file_path 実行ファイルの出力パス
	 */
	function createBinFile( $bin_file_path, $request_object ) {

		// 実行ファイルを解析
		$this->convertBody();

		// 表示前実行部分作成
		$string  = "<?php\n";
		
		// 表示前実行コードを記述
		foreach( $this->preview_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// モジュール実行のスクリプト追加
		foreach( $this->module_name_array as $module_name ) {
			// 空白区切りでforceが指定されているなら
			$module_informations	= explode(' ', $module_name);
			$module_name			= trim( array_shift( $module_informations ) );
			$force					= 'false';
			foreach( $module_informations as $str ) {
				$str	= trim( $str );
				if( preg_match('/^[fF][oO][rR][cC][eE]$/', $str ) > 0 ) {
					$force			= 'true';
					break;
				}
			}
			$string	.= '$controller->loadModule( "' . $module_name . '", '.$force.' );'."\n";
		}
		
		// モジュール実行結果による分岐処理を記述
		$string	.= 'if ( $request_object->isError() ) {'."\n";
			$string	.= '$is_error = true;'."\n";
			$string	.= '$request_object->setAttribute("IS_ERROR", $is_error );'."\n";
			$string	.= '$tmp_array = $request_object->errors;'."\n";
			$string	.= '$request_object->setAttribute("errors", $tmp_array );'."\n";
		$string	.= '} else {'."\n";
			$string	.= '$is_error = false;'."\n";
			$string	.= '$request_object->setAttribute("IS_ERROR", $is_error );'."\n";
		$string	.= '}'."\n";

		// ファイルアウトプット機能の追加
		// リクエストオブジェクトに乗せられたヘッダ
		$string	.= 'if( count( $request_object->headers ) > 0 ) {'."\n";
		$string	.= 'foreach( $request_object->headers as $hkey => $hval ) {'."\n";
		$string	.= 'header("$hkey: $hval");'."\n";
		$string	.= '}'."\n";
		$string	.= '}'."\n";
		// 下位互換：http_outputに乗せられたヘッダ
		$string	.= 'if( count( $this->headers ) > 0 ) {'."\n";
		$string	.= 'foreach( $this->headers as $hkey => $hval ) {'."\n";
		$string	.= 'header("$hkey: $hval");'."\n";
		$string	.= '}'."\n";
		$string	.= '}'."\n";
		
		// リダイレクトの場合		
		$string	.= 'if( !is_null( $request_object->redirect_url ) && strlen($request_object->redirect_url)> 0 ) {'."\n";
		$string	.= 'header("Location: ".$request_object->redirect_url);'."\n";
		$string	.= "die;\n";
		$string	.= '}';
		// レスポンスファイルが指定されている場合
		$string	.= 'else if( !is_null( $request_object->response_file_path ) && strlen( $request_object->response_file_path ) > 0 && file_exists( $request_object->response_file_path ) ){'."\n";
		$string	.= 'readfile($request_object->response_file_path);'."\n";
		// レスポンスボディが指定されている場合
		$string	.= '} else if( !is_null( $request_object->response_body ) && strlen( $request_object->response_body ) > 0 ) {'."\n";
		$string	.= 'echo $request_object->response_body;'."\n";
		$string	.= '}';
		// 下位互換：http_outputにレスポンスファイル
		$string	.= 'else if( !is_null( $this->response_file_path ) && strlen( $this->response_file_path ) > 0 && file_exists( $this->response_file_path ) ){'."\n";
		$string	.= 'readfile($this->response_file_path);'."\n";
		// 下位互換：http_outputにレスポンスボディ
		$string	.= '} else if( !is_null( $this->response_body ) && strlen( $this->response_body ) > 0 ) {'."\n";
		$string	.= 'echo $this->response_body;';
		// レスポンスが何も指定されていないなら継続処理
		$string	.= "} else { \n\n?>";
		
		// テキスト出力があるなら出力
		$string	.= $this->out_body_strings;
		
		// 出力を文字列に取得する
		$string .= "<?php\n";
		$string .= '$outstr = ob_get_clean();'."\n";

		// 表示文字列に対する処理実行コードを記述
		foreach( $this->convert_view_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// 最終的にできた表示文字列をフラッシュする
		$string .= "ob_start('".$this->output_handler."');\n";
		$string .= "ob_implicit_flush( false );\n";
		$string .= "mb_language('".$this->output_language."');\n";
		$string .= 'echo $outstr;'."\n";
		$string .= "mb_http_output('".$this->output_charset."');\n\n";
		$string .= 'ob_flush();'."\n";
		$string .= "}\n";

		// 表示後実行コードを記述
		foreach( $this->postview_process_hash as $code_array ) {
			foreach( $code_array as $code ) {
				$string	.= $code."\n";
			}
		}

		// フラッシュ後にモジュール後処理の実行
		$string .= '$controller->post_process_all(); ';
		$string .= "?>\n";
		
		$fp		= @fopen( $bin_file_path, "w" );
		if( $fp ) {
			if (@flock($fp, LOCK_EX)) {
				fwrite( $fp, $string );
				flock($fp, LOCK_UN);
				@fclose( $fp );
				@chmod( $bin_file_path, 0666 );
			} else {
				@fclose( $fp );
				@chmod( $bin_file_path, 0666 );
				die('Core Error: Can\'t create execute file!!');
			}
		} else {
			die('Core Error: Can\'t create execute file!!');
		}
		
		// ビルドファイル作成
		$build_file_path	= $bin_file_path.".build.php";
		$bin_file_path	= str_replace('\\','\\\\',$bin_file_path );
		$string	= "<?php\n";
		$string	.= '$build=false;'."\n";
		$target_file_path	= $this->execute_file_path;
		$target_file_path	= str_replace('\\','\\\\',$target_file_path );
		$string	.= 'if( file_exists("'.$target_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$target_file_path.'") ) { $build=true; }}'."\n";
		if( strlen( trim( $this->template_outer ) ) > 0 ) {
			$template_file_path	= $this->getRealTemplateFilePath( $this->template_outer );
			$template_file_path	= str_replace('\\','\\\\',$template_file_path );
			$string	.= 'if( file_exists("'.$template_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$template_file_path.'") ) { $build=true; }}'."\n";
		}
		foreach( $this->template_array as $template_name ) {
			$template_file_path	= $this->getRealTemplateFilePath( $template_name );
			$template_file_path	= str_replace('\\','\\\\',$template_file_path );
			$string	.= 'if( file_exists("'.$template_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$template_file_path.'") ) { $build=true; }}'."\n";
		}
		// CMSページファイルとの時間比較を追加
		if( $this->has_cms_page ) {
			$string	.= 'if( file_exists("'.$this->cms_page_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$this->cms_page_file_path.'") ) { $build=true; }}'."\n";
		}
		// pre_module.inc.phpタグとの時間比較を追加
		$target_folder	= dirname($target_file_path);
		while( strlen( $target_folder ) >= strlen( APPLICATION_BASE_PATH ) ) {
			$pre_module_file_path	= $target_folder.DIRECTORY_SEPARATOR.'pre_module.inc.php';
			if( file_exists( $pre_module_file_path ) ) {
				$string	.= 'if( file_exists("'.$pre_module_file_path.'") ){if( filemtime("'.$bin_file_path.'") < filemtime("'.$pre_module_file_path.'") ) { $build=true; }}'."\n";
			}
			$target_folder	= dirname($target_folder);
		}
		
		$string	.= "?>\n";

		$fp		= @fopen( $build_file_path, "w" );
		if( $fp ) {
			if (@flock($fp, LOCK_EX)) {
				fwrite( $fp, $string );
				flock($fp, LOCK_UN);
				@fclose( $fp );
				@chmod( $build_file_path, 0666 );
			} else {
				@fclose( $fp );
				@chmod( $build_file_path, 0666 );
				die('Core Error: Can\'t create build file!!');
			}
		} else {
			die('Core Error: Can\'t create build file!!');
		}
		
		
	}
	/**
	 * プレモジュール取り出し
	 */
	function _pickout_premodules() {
		// 上位階層から確認してpre_module.inc.phpがあるか確認してモジュール追加
		$target_dir		= dirname( $this->execute_file_path );
		$target_dir		= str_replace("/",DIRECTORY_SEPARATOR,$target_dir);
		$target_dir		= str_replace("\\",DIRECTORY_SEPARATOR,$target_dir);
		$dir_name_array	= explode(DIRECTORY_SEPARATOR,$target_dir );
		$dir_path			= '';
		if( preg_match('/^[a-zA-Z]\\:\\\/',$target_dir) ) {
			// Windowsなら頭にセパレータをつけないのでそのまま
		} else {
			// Unix系ならパスはディレクトリセパレータから開始
			$dir_path		= DIRECTORY_SEPARATOR;
		}
		foreach( $dir_name_array as $dirname ) {
			if( strlen($dirname) > 0 ) {
				$dir_path	.= $dirname.DIRECTORY_SEPARATOR;
				$pre_module_file	= $dir_path."pre_module.inc.php";
				if ( file_exists( $pre_module_file ) ) {
					$lines			= file( $pre_module_file );
					foreach ( $lines as $line ) {
						$module_name	= trim( $line );
						array_push($this->module_name_array,trim($module_name));
					}
				}
			}
		}
	}

	/**
	 * テンプレートタイプにあったテンプレートファイルのパスを取得する
	 * @param $file_name 使用するテンプレートファイル名
	 */
	function getRealTemplateFilePath( $file_name ) {
		$template_file_path = '';
		if( strlen(trim($this->template_type)) > 0 ) {
			// テンプレートファイルが指定されている場合
			if( array_key_exists($this->template_type,$GLOBALS['SPIDER_USER_AGENT_TYPE_ARRAY']) ) {
				// 配列にタイプがある場合はそのまま利用
				$template_file_path = $this->template_dir_root
					. DIRECTORY_SEPARATOR . $this->template_type
					. DIRECTORY_SEPARATOR . $file_name;
			} else if ( file_exists($template_file_path) ) {
				// テンプレートタイプフォルダが存在する場合はそのまま利用
				$template_file_path = $this->template_dir_root
					. DIRECTORY_SEPARATOR . $this->template_type
					. DIRECTORY_SEPARATOR . $file_name;
			} else {
				// それ以外の場合は自動決定
				$this->template_type	= $this->agent_type;
				$template_file_path = $this->template_dir_root
					. DIRECTORY_SEPARATOR . $this->agent_type
					. DIRECTORY_SEPARATOR . $file_name;
			}
		} else {
			// テンプレートが指定されていない場合は自動決定
			$this->template_type	= $this->agent_type;
			$template_file_path = $this->template_dir_root
				. DIRECTORY_SEPARATOR . $this->agent_type
				. DIRECTORY_SEPARATOR . $file_name;
		}
		if( !file_exists($template_file_path) ) {
			// 決定したファイルが存在しない場合、配列準にファイル存在を確認して利用する
			foreach( $GLOBALS['SPIDER_USER_AGENT_TYPE_ARRAY'] as $template_type => $target_name ) {
				$this->template_type	= $template_type;
				$template_file_path		= $this->template_dir_root
					. DIRECTORY_SEPARATOR . $template_type
					. DIRECTORY_SEPARATOR . $file_name;
				if( file_exists($template_file_path) ) {
					break;
				}
			}
		}
		return $template_file_path;
	}
	/**
	 * ユーザーエージェントを確認します
	 */
	function _confirm_agent() {
		$is_defined	= false;
		foreach( $GLOBALS['SPIDER_USER_AGENT_TYPE_REGX_ARRAY'] as $regx_str => $agent_type ) {
			if( preg_match( $regx_str, $_SERVER['HTTP_USER_AGENT'] ) > 0 ) {
				$this->agent_type	= $agent_type;
				$is_defined			= true;
				break;
			}
		}
		
		if( $is_defined ) {
			
		} else {
			$this->agent_type		= 'pc';
		}
	}

}
?>