<?php
require_once( dirname( __FILE__ ) . DIRECTORY_SEPARATOR . 'HttpOutput.class.php' );
require_once( dirname(dirname( __FILE__ ))
	. DIRECTORY_SEPARATOR . 'util'
	. DIRECTORY_SEPARATOR . 'LockProcess.class.php' );
/**
 * HTTP出力を行うクラスです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class HttpOutput {

	var $headers	= array();
	var $response_body;
	var $response_file_path;

	var $template_foler_path	= null;
	var $template_name			= null;
	var $template_ext			= null;
	var $agent_type				= null;
	var $page_title				= null;

	/**
	 * コンストラクタ
	 * @param $template_foler_path テンプレートファイルのルートディレクトリ
	 */	
	function HttpOutput( $template_foler_path ) {
		$this->template_foler_path	= $template_foler_path;
	}
	/**
	 * 出力言語を設定します（デフォルトJapanese）
	 * @param $languate 出力言語
	 */
	function setLanguage( $language ) {
		$this->output_language	= $language;
	}
	/**
	 * メインテンプレートを設定します。
	 * @param $template_name テンプレート名
	 * @param $ext
	 */
	function setTemplate( $template_name, $ext=null ) {
		$this->template_name	= $template_name;
		$this->template_ext		= $ext;
	}
	/**
	 * 出力文字セットを設定します。（デフォルトUTF-8)
	 * @param $charset 文字セット
	 */
	function setOutputCharset( $charset ) {
		$this->output_charset	= $charset;
	}
	/**
	 * ページ名を設定します。
	 * @param $title 表示するページ名
	 */
	function setPageTitle( $title ) {
		$this->page_title		= $title;
	}
	/**
	 * HTTPヘッダに送信するデータを設定します。
	 * @param $key HTTPヘッダのキー名
	 * @param $value HTTPヘッダの値
	 */
	function setHeader( $key, $value ) {
		$this->headers[$key]	= $value;
	}
	/**
	 * 設定してあるHTTPヘッダのデータを削除します。
	 * @param $key 削除するHTTPヘッダのキー名
	 */
	function dropHeader( $key ) {
		unset( $this->headers[$key] );
	}
	/**
	 * 
	 * @param $body 
	 */
	function setResponseBody( $body ) {
		$this->response_body	= $body;
	}
	/**
	 * 
	 * @param $file_path 
	 */
	function setResponseFile( $file_path ) {
		$this->response_file_path	= $file_path;
	}
	/**
	 * リクエストの出力
	 * @param $controller モジュールを実行するControllerオブジェクト
	 * @param $request_object HttpRequestオブジェクト
	 */
	function output( $controller, & $request_object ) {
		
		// 実行ファイル作成オブジェクト
		require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."ExecutableFileCreator.class.php");
		$creater_object	= new spider_ExecutableFileCreator($_SERVER['SCRIPT_FILENAME']);
		
		// 2008-11-07 ユーザーエージェントタイプをリクエストにセット
		$request_object->setAttribute('spider.access_agent_type',$creater_object->agent_type);
		
		// 実行コードファイルパスをDIR_PATH_BIN以下で再現しておく
		$virtual_root	= APPLICATION_BASE_PATH;
		if( preg_match('/^[a-zA-Z]\\:\\\/', APPLICATION_BASE_PATH, $regmatch_array ) ) {
			// Windows対策ドライブをディレクトリとして変換
			$drive_name		= substr($regmatch_array[0],0,1);
			$virtual_root	= preg_replace('/^[a-zA-Z]\\:\\\/'
				,$drive_name.DIRECTORY_SEPARATOR,$virtual_root );
		} else {
			$virtual_root	= substr($virtual_root,1);
		}
		$virtual_root	.= DIRECTORY_SEPARATOR.$creater_object->agent_type;

		$bin_file_path	= DIR_PATH_BIN
			.DIRECTORY_SEPARATOR.$virtual_root
			.str_replace("/",DIRECTORY_SEPARATOR,$_SERVER['PHP_SELF']);
		
		// 指定ファイルに対してロックオブジェクト作成
		$bin_lock_name	= basename(APPLICATION_BASE_PATH)
			.str_replace("/","_S_",str_replace(DIRECTORY_SEPARATOR,"_S_",$_SERVER['PHP_SELF']));
		$lock_obj	= new util_LockProcess($bin_lock_name);

		// ファイルとテンプレートの更新を確認
		$build_file_path	= $bin_file_path.".build.php";
		$build	= false;
		if( file_exists( $build_file_path ) ) {
			// ビルドファイルが存在するなら実行してビルド済みファイルが古くないか確認
			require_once( $build_file_path );
			if( $build ) {
				// ビルドファイルが古いならビルドファイルを削除
				if( $lock_obj->lock() ) {
					if( file_exists($bin_file_path) ) {
						unlink( $bin_file_path );
					}
					if( file_exists($build_file_path) ) {
						unlink( $build_file_path );
					}
				} else {
					$lock_obj->release();
					header('Content-type: text/plain;charset=UTF-8');
					die('Core Error: 現在アクセスが非常に混雑しています。しばらくたってからもう一度アクセスしてください。');
				}
			} else if( $lock_obj->wait() ) {
				require_once( $bin_file_path );
				return;
			} else {
				$lock_obj->release();
				header('Content-type: text/plain;charset=UTF-8');
				die('Core Error: 現在アクセスが非常に混雑しています。しばらくたってからもう一度アクセスしてください。');
			}
		} else if( file_exists( $bin_file_path ) ) {
			// そうでなくてビルドファイルが存在するならビルドファイルを実行する
			if( $lock_obj->wait() ) {
				require_once( $bin_file_path );
				return;
			} else if( file_exists( $build_file_path ) ) {
				$lock_obj->release();
				header('Content-type: text/plain;charset=UTF-8');
				die('Core Error: 現在アクセスが非常に混雑しています。しばらくたってからもう一度アクセスしてください。');
			}
		} else {
			if( $lock_obj->lock() ) {
				if( file_exists($bin_file_path) ) {
					unlink( $bin_file_path );
				}
				if( file_exists($build_file_path) ) {
					unlink( $build_file_path );
				}
			} else {
				$lock_obj->release();
				header('Content-type: text/plain;charset=UTF-8');
				die('Core Error: 現在アクセスが非常に混雑しています。しばらくたってからもう一度アクセスしてください。');
			}
		}
		
		// 実行ファイル作成
		if( !file_exists( DIR_PATH_BIN.DIRECTORY_SEPARATOR.$virtual_root ) ) {
			$dir_name_array	= explode(DIRECTORY_SEPARATOR,$virtual_root);
			$tdir	= DIR_PATH_BIN;
			foreach( $dir_name_array as $dirnm ) {
				$tdir	.= DIRECTORY_SEPARATOR . $dirnm;
				$lock_name	= str_replace( DIRECTORY_SEPARATOR, "_S_", $tdir );
				$dirlock_obj	= new util_LockProcess($lock_name);
				if( !file_exists($tdir) ) {
					if( $dirlock_obj->lock() ) {
						mkdir( $tdir, 0777 );
						chmod( $tdir, 0777 );
					}
					$dirlock_obj->release();
				}
			}
		}
		$dir_path_tmp	= dirname($bin_file_path);
		if( !file_exists($dir_path_tmp) ) {
			$dir_name_array	= explode("/",dirname($_SERVER['PHP_SELF']));
			$tdir	= DIR_PATH_BIN.DIRECTORY_SEPARATOR.$virtual_root;
			foreach( $dir_name_array as $dirnm ) {
				$tdir	.= DIRECTORY_SEPARATOR . $dirnm;
				$lock_name	= str_replace( DIRECTORY_SEPARATOR, "_S_", $tdir );
				$dirlock_obj	= new util_LockProcess($lock_name);
				if( !file_exists($tdir) ) {
					if( $dirlock_obj->lock() ) {
						mkdir( $tdir, 0777 );
						chmod( $tdir, 0777 );
					}
					$dirlock_obj->release();
				}
			}
		}

		// 実行ファイル作成
		$creater_object->createBinFile( $bin_file_path, $request_object );

		// ロックを解除する
		$lock_obj->release();
		
		$request	= & $request_object;

		// 実行ファイル実行
		require( $bin_file_path );
		return;
	}
}
?>