<?php
/*
 * Created on 2008/06/11
 */
/**
 * クライアントからの要求を提供するHTTPリクエスト、
 * クライアントへの応答を送信する際の処理を行うHTTPレスポンス
 * それぞれで使用するデータを保持するクラスです。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
class HttpRequest {
	/** Attributes			*/
	var $attribute_array	= array();
	/** Errors				*/
	var $errors				= array();
	/** Global Errors		*/
	var $global_errors		= array();
	/** Response Headers	*/
	var $headers			= array();
	/** Response Body		*/
	var $response_body		= null;
	/** Response File Path	*/
	var $response_file_path	= null;
	/** Redirect To URL		*/
	var $redirect_url		= null;

	/**
	 * コンストラクタ
	 */
	function HttpRequest() {
		$this->attribute_array	= array();
		$this->errors			= array();
	}
	/**
	 * 属性を設定します。
	 * @param $key 属性名
	 * @param $value 属性値
	 */
	function setAttribute( $key, & $value ) {
		$this->attribute_array[$key]	= $value;
	}
	/**
	 * 指定キーの属性を取得します。
	 * @param $key 属性名
	 */
	function getAttribute( $key ) {
		$ref	= & $this->attribute_array[$key];
		return $ref;
	}
	/**
	 * 指定キーの性がセットされたか確認します
	 */
	function existAttribute( $key ) {
		return array_key_exists( $key, $this->attribute_array );
	}
	/**
	 * エラーメッセージを追加します。
	 * @param $message エラーメッセージ
	 */
	function addError( $message ) {
		array_push( $this->errors, $message );
	}
	/**
	 * エラーがあるか確認します。
	 * @return true:エラーあり、false:それ以外
	 */
	function isError() {
		if( count( $this->errors ) > 0 ) {
			return true;
		} else {
			return false;
		}
	}
	/**
	 * グローバルエラーを追加します
	 */
	function addGlobalError( $message ) {
		array_push( $this->global_errors, $message );
	}
	/**
	 * レスポンスヘッダを設定します
	 */
	function setResponseHeader( $key, $value ) {
		$this->headers[$key]	= $value;
	}
	/**
	 * レスポンスボディを設定します
	 */
	function setResponseBody( $body ) {
		$this->response_body	= $body;
	}
	/**
	 * レスポンスボディをファイルパスで設定します。
	 */
	function setResponseFile( $file_path ) {
		$this->response_file_path	= $file_path;
	}
	/**
	 * リダイレクト先を設定します
	 */
	function redirectTo($url) {
		$this->redirect_url	= $url;
	}
}
?>
