<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_Foreach extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_Foreach() {
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		$vars_tags_aray			= array();
		preg_match_all( '/\\{foreach\\:[^\\}]*?}/'
			, $result_strings
			, $vars_tags_aray
			, PREG_PATTERN_ORDER );
		$valiable_counter	= 0;
		foreach ( $vars_tags_aray as $vars_tags ) {
			foreach ( $vars_tags as $vars_tag ) {
				$var_name	= preg_replace( '/\\{foreach\\:/','', $vars_tag );
				$var_name	= preg_replace( '/\\}$/','', $var_name );
				$var_name	= trim( $var_name );
				$var_name	= str_replace( '  ',' ', $var_name );
				$var_name	= str_replace( '  ',' ', $var_name );
				$at_name	= null;
				list( $var_name, $key_name, $val_name )	= explode( ' ', $var_name );
				if ( strpos( $var_name, '::' ) > 0 ) {
					list( $var_name, $at_name )	= explode( '::', $var_name );
				}
				$k_name	= 'key';
				$v_name	= 'value';
				if ( strlen( $key_name ) > 0 && strlen( $val_name ) > 0 ) {
					$k_name	= $key_name;
					$v_name	= $val_name;
				} else if ( strlen( $key_name ) > 0 ) {
					$v_name	= $key_name;
				}
				$counter_name = str_replace('.','_',$var_name)."_".$at_name."_loop_counter";
				$rep_string	= "<?php ";
				$rep_string	.= '$tmp_arry'.$valiable_counter.' = $request_object->getAttribute( "'.$var_name.'" ); ';
				$rep_string	.= '$type = gettype($tmp_arry'.$valiable_counter.'); ';
				if ( strlen( trim($at_name ) ) > 0 ) {
					$rep_string	.= 'if(\'array\'==$type) { $tmp_arry'.$valiable_counter.'=$tmp_arry'.$valiable_counter.'[\''.$at_name.'\']; } ';
					$rep_string	.= 'if(\'object\'==$type) { $tmp_arry'.$valiable_counter.'=$tmp_arry'.$valiable_counter.'->'.$at_name.'; } ';
					$rep_string	.= '$type = gettype($tmp_arry'.$valiable_counter.'); ';
				}
				$rep_string	.= 'if(\'array\'==$type) { '
					. '$'.$counter_name.'=0; '
					. 'foreach( $tmp_arry'.$valiable_counter.' as $' . $k_name . '=>$' . $v_name . ' ) { '
					. '$'.$counter_name.'++; '
					. '$request_object->setAttribute("'.$counter_name.'",$'.$counter_name.'); '
					. '$request_object->setAttribute("'.$k_name.'",$'.$k_name.'); '
					. '$request_object->setAttribute("'.$v_name.'",$'.$v_name.'); ?>'
				;
				$result_strings = str_replace( $vars_tag, $rep_string, $result_strings );
				$result_strings = str_replace( '{end-foreach}', '<?php } } ?>', $result_strings );
				$result_strings = str_replace( '{/foreach}', '<?php } } ?>', $result_strings );
				$valiable_counter++;
			}
		}
	}
}
?>