<?php
/**
 * HTML用変換タグの基礎クラス
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.0.0
 * @copyright Copyright &copy; 2008, Multimedia Digital Contents Systems.Co.,Ltd.<info@md-systems.net> http://www.md-systems.net/
 * @author Multimedia Digital Contents Systems.Co.,Ltd. m.nakashima <m_nakashima@md-systems.net>
 * @since PHP 4.3
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR."TagBase.class.php");
class spider_tags_SetRequestParam extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_SetRequestParam() {
		$this->priority	= 0;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$creator ){
		
		if( preg_match('/\\{set-request-param\\:[fF][aA][lL][sS][eE]\\}/', $creator->out_body_strings ) > 0
			|| preg_match('/\\{set-request-param\\:[nN][oO]\\}/', $creator->out_body_strings ) > 0 ) {
			// falseかnoが指定されているなら登録しない
			$creator->out_body_strings = preg_replace( '/\\{set-request-param\\:[fF][aA][lL][sS][eE]\\}/'
				, "", $creator->out_body_strings );
		} else {
			// 明示的に否定していないなら暗黙的にパラメータを登録
			$creator->out_body_strings = preg_replace( '/\\{set-request-param\\:[^\\}]*?\\}/'
				, "", $creator->out_body_strings );
			// cookie及びpost,getの値をリクエストに登録
			$process_code = 'foreach($_POST as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'post.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			$process_code	.= 'foreach($_GET as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'get.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			$process_code	.= 'foreach($_COOKIE as $key=>$value){'."\n";
			$process_code	.= '$request_object->setAttribute(\'cookie.\'.$key,$value);'."\n";
			$process_code	.= '}'."\n";
			if( !is_array($creator->preview_process_hash) ){
				$creator->preview_process_hash	= array();
			}
			if( !is_array($creator->preview_process_hash[$this->priority]) ){
				$creator->preview_process_hash[$this->priority]	= array();
			}
			array_push( $creator->preview_process_hash[$this->priority], $process_code );
		}
		
	}
}
?>