<?php
/*
 * Created on 2007/05/18
 */
// Framework Version

define ( 'DIR_PATH_SPIDER_DATA',	dirname(__FILE__) );

/* 設定ファイルの読み込み	*/
if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR.'service' ) ) {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.service.inc.php' );
} else if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR.'development' ) ) {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.dev.inc.php' );
} else {
	require_once( dirname(__FILE__).DIRECTORY_SEPARATOR.'define.inc.php' );
}
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}

// チェック実行
if( !file_exists(DIR_PATH_TEMPLATE) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : テンプレートディレクトリがありません。' );
}
if( !file_exists(DIR_PATH_LIB) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : ライブラリディレクトリがありません。' );
}
if( !file_exists(DIR_PATH_LOCK) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : プロセスロックディレクトリがありません。' );
} else if( !is_writable(DIR_PATH_LOCK) ){
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : プロセスロックディレクトリが書き込み不能になっています。' );
}
if( !file_exists(DIR_PATH_TMP) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : 一時ディレクトリがありません。' );
} else if( !is_writable(DIR_PATH_TMP) ){
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : 一時ディレクトリが書き込み不能になっています。' );
}
if( !file_exists(DIR_PATH_CACHE) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : キャッシュディレクトリがありません。' );
} else if( !is_writable(DIR_PATH_CACHE) ){
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : キャッシュディレクトリが書き込み不能になっています。' );
}
if( !file_exists(DIR_PATH_BIN) ) {
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : バイナリ保存ディレクトリがありません。' );
} else if( !is_writable(DIR_PATH_BIN) ){
	header( 'Content-type: text/plain;charset=UTF-8' );
	die( 'Core Error : バイナリ保存ディレクトリが書き込み不能になっています。' );
}

mb_language('japanese');
mb_internal_encoding('UTF-8');
ob_start('mb_output_handler');
if( preg_match('/Windows/',$_ENV['OS'] ) > 0 ) {
	mb_http_output('SJIS-win');
} else if( preg_match('/[eE][uU][cC][jJ][pP]/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('EUC_JP');
} else if( preg_match('/[uU][tT][fF]\\-8/', $_ENV['LANG'] ) > 0 ) {
	mb_http_output('UTF-8');
}
ob_implicit_flush( true );

require_once( "MDB2.php" );
if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR.'service' ) ) {
	require_once( dirname(__FILE__)
		.DIRECTORY_SEPARATOR."lib"
		.DIRECTORY_SEPARATOR."database"
		.DIRECTORY_SEPARATOR."package_define.service.inc.php");
} else if( file_exists( dirname(__FILE__).DIRECTORY_SEPARATOR.'development' ) ) {
	require_once( dirname(__FILE__)
		.DIRECTORY_SEPARATOR."lib"
		.DIRECTORY_SEPARATOR."database"
		.DIRECTORY_SEPARATOR."package_define.dev.inc.php");
} else {
	require_once( dirname(__FILE__)
		.DIRECTORY_SEPARATOR."lib"
		.DIRECTORY_SEPARATOR."database"
		.DIRECTORY_SEPARATOR."package_define.inc.php");
}
if ( file_exists( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' ) ) {
	include_once( dirname( __FILE__ ).DIRECTORY_SEPARATOR.'unique_setting.inc.php' );
}
require_once( dirname(__FILE__)
	.DIRECTORY_SEPARATOR."lib"
	.DIRECTORY_SEPARATOR."database"
	.DIRECTORY_SEPARATOR."package_define.inc.php");

$GLOBALS['dbo']	= null;
if( DATABASE_TYPE == 'pgsql' ) {
	define('DSN','pgsql://' . DATABASE_USER . ':' . DATABASE_PASS
		. '@' . DATABASE_HOST . '/' . DATABASE_NAME );
	require_once( dirname(__FILE__)
		.DIRECTORY_SEPARATOR."lib"
		.DIRECTORY_SEPARATOR."database"
		.DIRECTORY_SEPARATOR."DatabaseConnection.class.php");
	$dbo =& MDB2::singleton( DSN );
	if ( MDB2::isError( $dbo ) ) {
		die('接続失敗');
	} else {
		$db_connection = new database_DatabaseConnection( $dbo );
		$db_connection->connect();
	}
	$GLOBALS['dbo']		= $db_connection;
} else {
	define('DSN','mysql://' . DATABASE_USER . ':' . DATABASE_PASS
		. '@' . DATABASE_HOST . '/' . DATABASE_NAME );
	$dbo =& MDB2::singleton( DSN );
	if ( MDB2::isError( $dbo ) ) {
		die('接続失敗');
	} else {
		$dbo->connect();
		if ( !$result = $dbo->query( "SET NAMES 'utf8'" ) ) {
			die('文字コード変更失敗');
		}
		$db_connection	= $dbo;
	}
	$db_connection		= $dbo;
	$GLOBALS['dbo']		= $db_connection;
}

?>
